/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.am642.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.am642.model.AlarmRefOrValue;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.springframework.validation.annotation.Validated;

@Schema(description="Task resource for ungroup alarms operation")
@Validated
@Entity(name="AMUnGroupAlarms")
@Table(name="AMUnGroupAlarms")
public class UnGroupAlarms
extends BaseRootEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="alarmChangedTime")
    private OffsetDateTime alarmChangedTime = null;
    @JsonProperty(value="sourceSystemId")
    private String sourceSystemId = null;
    @JsonProperty(value="state")
    private String state = null;
    @JsonProperty(value="correlatedAlarm")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<AlarmRefOrValue> correlatedAlarm = null;
    @JsonProperty(value="parentAlarm")
    @OneToOne(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private AlarmRefOrValue parentAlarm = null;
    @JsonProperty(value="unGroupedAlarm")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<AlarmRefOrValue> unGroupedAlarm = null;

    public String getId() {
        if (this.uuid != null) {
            this.id = this.uuid;
        }
        return this.id;
    }

    public UnGroupAlarms href(String href) {
        this.href = href;
        return this;
    }

    @Override
    @Schema(description="A reference to the task")
    public String getHref() {
        return this.href;
    }

    @Override
    public void setHref(String href) {
        this.href = href;
    }

    public UnGroupAlarms alarmChangedTime(OffsetDateTime alarmChangedTime) {
        this.alarmChangedTime = alarmChangedTime;
        return this;
    }

    @Schema(description="Time of the uncorrelation")
    @Valid
    public OffsetDateTime getAlarmChangedTime() {
        return this.alarmChangedTime;
    }

    public void setAlarmChangedTime(OffsetDateTime alarmChangedTime) {
        this.alarmChangedTime = alarmChangedTime;
    }

    public UnGroupAlarms sourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
        return this;
    }

    @Schema(description="Source system identifier")
    public String getSourceSystemId() {
        return this.sourceSystemId;
    }

    public void setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
    }

    public UnGroupAlarms state(String state) {
        this.state = state;
        return this;
    }

    @Schema(description="Current state of the operation task")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public UnGroupAlarms correlatedAlarm(Set<AlarmRefOrValue> correlatedAlarm) {
        this.correlatedAlarm = correlatedAlarm;
        return this;
    }

    public UnGroupAlarms addCorrelatedAlarmItem(AlarmRefOrValue correlatedAlarmItem) {
        if (this.correlatedAlarm == null) {
            this.correlatedAlarm = new HashSet<AlarmRefOrValue>();
        }
        this.correlatedAlarm.add(correlatedAlarmItem);
        return this;
    }

    @Schema(description="Correlated alarms")
    @Valid
    public Set<AlarmRefOrValue> getCorrelatedAlarm() {
        return this.correlatedAlarm;
    }

    public void setCorrelatedAlarm(Set<AlarmRefOrValue> correlatedAlarm) {
        this.correlatedAlarm = correlatedAlarm;
    }

    public UnGroupAlarms parentAlarm(AlarmRefOrValue parentAlarm) {
        this.parentAlarm = parentAlarm;
        return this;
    }

    @Schema(description="")
    @Valid
    public AlarmRefOrValue getParentAlarm() {
        return this.parentAlarm;
    }

    public void setParentAlarm(AlarmRefOrValue parentAlarm) {
        this.parentAlarm = parentAlarm;
    }

    public UnGroupAlarms unGroupedAlarm(Set<AlarmRefOrValue> unGroupedAlarm) {
        this.unGroupedAlarm = unGroupedAlarm;
        return this;
    }

    public UnGroupAlarms addUnGroupedAlarmItem(AlarmRefOrValue unGroupedAlarmItem) {
        if (this.unGroupedAlarm == null) {
            this.unGroupedAlarm = new HashSet<AlarmRefOrValue>();
        }
        this.unGroupedAlarm.add(unGroupedAlarmItem);
        return this;
    }

    @Schema(description="The successfully uncorrelated alarms")
    @Valid
    public Set<AlarmRefOrValue> getUnGroupedAlarm() {
        return this.unGroupedAlarm;
    }

    public void setUnGroupedAlarm(Set<AlarmRefOrValue> unGroupedAlarm) {
        this.unGroupedAlarm = unGroupedAlarm;
    }

    @Override
    public UnGroupAlarms baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getAtBaseType() {
        return this.baseType;
    }

    public void setAtBaseType(String baseType) {
        this.baseType = baseType;
    }

    @Override
    public UnGroupAlarms schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this.schemaLocation;
    }

    public void setAtSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public UnGroupAlarms type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getAtType() {
        return this.type;
    }

    public void setAtType(String type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnGroupAlarms unGroupAlarms = (UnGroupAlarms)o;
        return Objects.equals(this.id, unGroupAlarms.id) && Objects.equals(this.href, unGroupAlarms.href) && Objects.equals(this.alarmChangedTime, unGroupAlarms.alarmChangedTime) && Objects.equals(this.sourceSystemId, unGroupAlarms.sourceSystemId) && Objects.equals(this.state, unGroupAlarms.state) && Objects.equals(this.correlatedAlarm, unGroupAlarms.correlatedAlarm) && Objects.equals(this.parentAlarm, unGroupAlarms.parentAlarm) && Objects.equals(this.unGroupedAlarm, unGroupAlarms.unGroupedAlarm) && Objects.equals(this.baseType, unGroupAlarms.baseType) && Objects.equals(this.schemaLocation, unGroupAlarms.schemaLocation) && Objects.equals(this.type, unGroupAlarms.type);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.href, this.alarmChangedTime, this.sourceSystemId, this.state, this.correlatedAlarm, this.parentAlarm, this.unGroupedAlarm, this.baseType, this.schemaLocation, this.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UnGroupAlarms {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    alarmChangedTime: ").append(this.toIndentedString(this.alarmChangedTime)).append("\n");
        sb.append("    sourceSystemId: ").append(this.toIndentedString(this.sourceSystemId)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    correlatedAlarm: ").append(this.toIndentedString(this.correlatedAlarm)).append("\n");
        sb.append("    parentAlarm: ").append(this.toIndentedString(this.parentAlarm)).append("\n");
        sb.append("    unGroupedAlarm: ").append(this.toIndentedString(this.unGroupedAlarm)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

