/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.am642.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.am642.model.Alarm;
import org.etsi.osl.tmf.am642.model.AlarmRefOrValue;
import org.springframework.validation.annotation.Validated;

@Schema(description="Task resource for unacknowledge alarms operation Skipped properties: id,href")
@Validated
public class UnAckAlarmsCreate {
    @JsonProperty(value="ackSystemId")
    private String ackSystemId = null;
    @JsonProperty(value="ackTime")
    private OffsetDateTime ackTime = null;
    @JsonProperty(value="ackUserId")
    private String ackUserId = null;
    @JsonProperty(value="state")
    private String state = null;
    @JsonProperty(value="alarmPattern")
    @Valid
    private List<Alarm> alarmPattern = new ArrayList<Alarm>();
    @JsonProperty(value="unAckedAlarm")
    @Valid
    private List<AlarmRefOrValue> unAckedAlarm = null;
    @JsonProperty(value="@baseType")
    private String baseType = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@type")
    private String type = null;

    public UnAckAlarmsCreate ackSystemId(String ackSystemId) {
        this.ackSystemId = ackSystemId;
        return this;
    }

    @Schema(description="Name of the unacknowledging system")
    @NotNull
    public String getAckSystemId() {
        return this.ackSystemId;
    }

    public void setAckSystemId(String ackSystemId) {
        this.ackSystemId = ackSystemId;
    }

    public UnAckAlarmsCreate ackTime(OffsetDateTime ackTime) {
        this.ackTime = ackTime;
        return this;
    }

    @Schema(description="Time of the unacknowledgement")
    @Valid
    public OffsetDateTime getAckTime() {
        return this.ackTime;
    }

    public void setAckTime(OffsetDateTime ackTime) {
        this.ackTime = ackTime;
    }

    public UnAckAlarmsCreate ackUserId(String ackUserId) {
        this.ackUserId = ackUserId;
        return this;
    }

    @Schema(description="Name of the unacknowledging user")
    @NotNull
    public String getAckUserId() {
        return this.ackUserId;
    }

    public void setAckUserId(String ackUserId) {
        this.ackUserId = ackUserId;
    }

    public UnAckAlarmsCreate state(String state) {
        this.state = state;
        return this;
    }

    @Schema(description="Current state of the operation task")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public UnAckAlarmsCreate alarmPattern(List<Alarm> alarmPattern) {
        this.alarmPattern = alarmPattern;
        return this;
    }

    public UnAckAlarmsCreate addAlarmPatternItem(Alarm alarmPatternItem) {
        this.alarmPattern.add(alarmPatternItem);
        return this;
    }

    @Schema(description="Alarm patterns to match target alarms. An alarm will match if all of the sttributes in any of the patterns compare equal to those attributes of the alarm.")
    @NotNull
    @Valid
    @Size(min=1)
    public @NotNull @Valid @Size(min=1) List<Alarm> getAlarmPattern() {
        return this.alarmPattern;
    }

    public void setAlarmPattern(List<Alarm> alarmPattern) {
        this.alarmPattern = alarmPattern;
    }

    public UnAckAlarmsCreate unAckedAlarm(List<AlarmRefOrValue> unAckedAlarm) {
        this.unAckedAlarm = unAckedAlarm;
        return this;
    }

    public UnAckAlarmsCreate addUnAckedAlarmItem(AlarmRefOrValue unAckedAlarmItem) {
        if (this.unAckedAlarm == null) {
            this.unAckedAlarm = new ArrayList<AlarmRefOrValue>();
        }
        this.unAckedAlarm.add(unAckedAlarmItem);
        return this;
    }

    @Schema(description="The successfully unacknowledged alarms")
    @Valid
    public List<AlarmRefOrValue> getUnAckedAlarm() {
        return this.unAckedAlarm;
    }

    public void setUnAckedAlarm(List<AlarmRefOrValue> unAckedAlarm) {
        this.unAckedAlarm = unAckedAlarm;
    }

    public UnAckAlarmsCreate baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getAtBaseType() {
        return this.baseType;
    }

    public void setAtBaseType(String baseType) {
        this.baseType = baseType;
    }

    public UnAckAlarmsCreate schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this.schemaLocation;
    }

    public void setAtSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public UnAckAlarmsCreate type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getAtType() {
        return this.type;
    }

    public void setAtType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnAckAlarmsCreate unAckAlarmsCreate = (UnAckAlarmsCreate)o;
        return Objects.equals(this.ackSystemId, unAckAlarmsCreate.ackSystemId) && Objects.equals(this.ackTime, unAckAlarmsCreate.ackTime) && Objects.equals(this.ackUserId, unAckAlarmsCreate.ackUserId) && Objects.equals(this.state, unAckAlarmsCreate.state) && Objects.equals(this.alarmPattern, unAckAlarmsCreate.alarmPattern) && Objects.equals(this.unAckedAlarm, unAckAlarmsCreate.unAckedAlarm) && Objects.equals(this.baseType, unAckAlarmsCreate.baseType) && Objects.equals(this.schemaLocation, unAckAlarmsCreate.schemaLocation) && Objects.equals(this.type, unAckAlarmsCreate.type);
    }

    public int hashCode() {
        return Objects.hash(this.ackSystemId, this.ackTime, this.ackUserId, this.state, this.alarmPattern, this.unAckedAlarm, this.baseType, this.schemaLocation, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UnAckAlarmsCreate {\n");
        sb.append("    ackSystemId: ").append(this.toIndentedString(this.ackSystemId)).append("\n");
        sb.append("    ackTime: ").append(this.toIndentedString(this.ackTime)).append("\n");
        sb.append("    ackUserId: ").append(this.toIndentedString(this.ackUserId)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    alarmPattern: ").append(this.toIndentedString(this.alarmPattern)).append("\n");
        sb.append("    unAckedAlarm: ").append(this.toIndentedString(this.unAckedAlarm)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

