/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.am642.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.am642.model.Alarm;
import org.etsi.osl.tmf.am642.model.AlarmRefOrValue;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.springframework.validation.annotation.Validated;

@Schema(description="Task resource for unacknowledge alarms operation")
@Validated
@Entity(name="AMUnAckAlarms")
@Table(name="AMUnAckAlarms")
public class UnAckAlarms
extends BaseRootEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="ackSystemId")
    private String ackSystemId = null;
    private OffsetDateTime ackTime = null;
    @JsonProperty(value="ackUserId")
    private String ackUserId = null;
    @JsonProperty(value="state")
    private String state = null;
    @JsonProperty(value="alarmPattern")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<Alarm> alarmPattern = new HashSet<Alarm>();
    @JsonProperty(value="unAckedAlarm")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<AlarmRefOrValue> unAckedAlarm = new HashSet<AlarmRefOrValue>();

    public String getId() {
        if (this.uuid != null) {
            this.id = this.uuid;
        }
        return this.id;
    }

    public UnAckAlarms href(String href) {
        this.href = href;
        return this;
    }

    @Override
    @Schema(description="A reference to the task")
    public String getHref() {
        return this.href;
    }

    @Override
    public void setHref(String href) {
        this.href = href;
    }

    public UnAckAlarms ackSystemId(String ackSystemId) {
        this.ackSystemId = ackSystemId;
        return this;
    }

    @Schema(description="Name of the unacknowledging system")
    public String getAckSystemId() {
        return this.ackSystemId;
    }

    public void setAckSystemId(String ackSystemId) {
        this.ackSystemId = ackSystemId;
    }

    public UnAckAlarms ackTime(OffsetDateTime ackTime) {
        this.ackTime = ackTime;
        return this;
    }

    @Schema(description="Time of the unacknowledgement")
    @Valid
    public OffsetDateTime getAckTime() {
        return this.ackTime;
    }

    public void setAckTime(OffsetDateTime ackTime) {
        this.ackTime = ackTime;
    }

    @JsonProperty(value="ackTime")
    public String getAckTimeStr() {
        if (this.ackTime != null) {
            return this.ackTime.toString();
        }
        return null;
    }

    public UnAckAlarms ackUserId(String ackUserId) {
        this.ackUserId = ackUserId;
        return this;
    }

    @Schema(description="Name of the unacknowledging user")
    public String getAckUserId() {
        return this.ackUserId;
    }

    public void setAckUserId(String ackUserId) {
        this.ackUserId = ackUserId;
    }

    public UnAckAlarms state(String state) {
        this.state = state;
        return this;
    }

    @Schema(description="Current state of the operation task")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public UnAckAlarms alarmPattern(Set<Alarm> alarmPattern) {
        this.alarmPattern = alarmPattern;
        return this;
    }

    public UnAckAlarms addAlarmPatternItem(Alarm alarmPatternItem) {
        if (this.alarmPattern == null) {
            this.alarmPattern = new HashSet<Alarm>();
        }
        this.alarmPattern.add(alarmPatternItem);
        return this;
    }

    @Schema(description="Alarm patterns to match target alarms. An alarm will match if all of the sttributes in any of the patterns compare equal to those attributes of the alarm.")
    @Valid
    public Set<Alarm> getAlarmPattern() {
        return this.alarmPattern;
    }

    public void setAlarmPattern(Set<Alarm> alarmPattern) {
        this.alarmPattern = alarmPattern;
    }

    public UnAckAlarms unAckedAlarm(Set<AlarmRefOrValue> unAckedAlarm) {
        this.unAckedAlarm = unAckedAlarm;
        return this;
    }

    public UnAckAlarms addUnAckedAlarmItem(AlarmRefOrValue unAckedAlarmItem) {
        if (this.unAckedAlarm == null) {
            this.unAckedAlarm = new HashSet<AlarmRefOrValue>();
        }
        this.unAckedAlarm.add(unAckedAlarmItem);
        return this;
    }

    @Schema(description="The successfully unacknowledged alarms")
    @Valid
    public Set<AlarmRefOrValue> getUnAckedAlarm() {
        return this.unAckedAlarm;
    }

    public void setUnAckedAlarm(Set<AlarmRefOrValue> unAckedAlarm) {
        this.unAckedAlarm = unAckedAlarm;
    }

    @Override
    public UnAckAlarms baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getAtBaseType() {
        return this.baseType;
    }

    public void setAtBaseType(String baseType) {
        this.baseType = baseType;
    }

    @Override
    public UnAckAlarms schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this.schemaLocation;
    }

    public void setAtSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public UnAckAlarms type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getAtType() {
        return this.type;
    }

    public void setAtType(String type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnAckAlarms unAckAlarms = (UnAckAlarms)o;
        return Objects.equals(this.id, unAckAlarms.id) && Objects.equals(this.href, unAckAlarms.href) && Objects.equals(this.ackSystemId, unAckAlarms.ackSystemId) && Objects.equals(this.ackTime, unAckAlarms.ackTime) && Objects.equals(this.ackUserId, unAckAlarms.ackUserId) && Objects.equals(this.state, unAckAlarms.state) && Objects.equals(this.alarmPattern, unAckAlarms.alarmPattern) && Objects.equals(this.unAckedAlarm, unAckAlarms.unAckedAlarm) && Objects.equals(this.baseType, unAckAlarms.baseType) && Objects.equals(this.schemaLocation, unAckAlarms.schemaLocation) && Objects.equals(this.type, unAckAlarms.type);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.href, this.ackSystemId, this.ackTime, this.ackUserId, this.state, this.alarmPattern, this.unAckedAlarm, this.baseType, this.schemaLocation, this.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UnAckAlarms {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    ackSystemId: ").append(this.toIndentedString(this.ackSystemId)).append("\n");
        sb.append("    ackTime: ").append(this.toIndentedString(this.ackTime)).append("\n");
        sb.append("    ackUserId: ").append(this.toIndentedString(this.ackUserId)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    alarmPattern: ").append(this.toIndentedString(this.alarmPattern)).append("\n");
        sb.append("    unAckedAlarm: ").append(this.toIndentedString(this.unAckedAlarm)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

