/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.am642.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.am642.model.AlarmRefOrValue;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.springframework.validation.annotation.Validated;

@Schema(description="Task resource for group alarms operation")
@Validated
@Entity(name="AMGroupAlarms")
@Table(name="AMGroupAlarms")
public class GroupAlarms
extends BaseRootEntity {
    @JsonProperty(value="id")
    private String id = null;
    private OffsetDateTime alarmChangedTime = null;
    @JsonProperty(value="sourceSystemId")
    private String sourceSystemId = null;
    @JsonProperty(value="state")
    private String state = null;
    @JsonProperty(value="correlatedAlarm")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<AlarmRefOrValue> correlatedAlarm = new HashSet<AlarmRefOrValue>();
    @JsonProperty(value="groupedAlarm")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<AlarmRefOrValue> groupedAlarm = new HashSet<AlarmRefOrValue>();
    @JsonProperty(value="parentAlarm")
    @OneToOne(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private AlarmRefOrValue parentAlarm = null;

    public String getId() {
        if (this.uuid != null) {
            this.id = this.uuid;
        }
        return this.id;
    }

    public GroupAlarms alarmChangedTime(OffsetDateTime alarmChangedTime) {
        this.alarmChangedTime = alarmChangedTime;
        return this;
    }

    @Schema(description="Time of the correlation")
    @Valid
    public OffsetDateTime getAlarmChangedTime() {
        return this.alarmChangedTime;
    }

    public void setAlarmChangedTime(OffsetDateTime alarmChangedTime) {
        this.alarmChangedTime = alarmChangedTime;
    }

    @JsonProperty(value="alarmChangedTime")
    public String getAlarmChangedTimeStr() {
        if (this.alarmChangedTime != null) {
            return this.alarmChangedTime.toString();
        }
        return null;
    }

    public GroupAlarms sourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
        return this;
    }

    @Schema(description="Source system identifier")
    public String getSourceSystemId() {
        return this.sourceSystemId;
    }

    public void setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
    }

    public GroupAlarms state(String state) {
        this.state = state;
        return this;
    }

    @Schema(description="Current state of the operation task")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public GroupAlarms correlatedAlarm(Set<AlarmRefOrValue> correlatedAlarm) {
        this.correlatedAlarm = correlatedAlarm;
        return this;
    }

    public GroupAlarms addCorrelatedAlarmItem(AlarmRefOrValue correlatedAlarmItem) {
        if (this.correlatedAlarm == null) {
            this.correlatedAlarm = new HashSet<AlarmRefOrValue>();
        }
        this.correlatedAlarm.add(correlatedAlarmItem);
        return this;
    }

    @Schema(description="Correlated alarms")
    @Valid
    public Set<AlarmRefOrValue> getCorrelatedAlarm() {
        return this.correlatedAlarm;
    }

    public void setCorrelatedAlarm(Set<AlarmRefOrValue> correlatedAlarm) {
        this.correlatedAlarm = correlatedAlarm;
    }

    public GroupAlarms groupedAlarm(Set<AlarmRefOrValue> groupedAlarm) {
        this.groupedAlarm = groupedAlarm;
        return this;
    }

    public GroupAlarms addGroupedAlarmItem(AlarmRefOrValue groupedAlarmItem) {
        if (this.groupedAlarm == null) {
            this.groupedAlarm = new HashSet<AlarmRefOrValue>();
        }
        this.groupedAlarm.add(groupedAlarmItem);
        return this;
    }

    @Schema(description="The successfully correlated alarms")
    @Valid
    public Set<AlarmRefOrValue> getGroupedAlarm() {
        return this.groupedAlarm;
    }

    public void setGroupedAlarm(Set<AlarmRefOrValue> groupedAlarm) {
        this.groupedAlarm = groupedAlarm;
    }

    public GroupAlarms parentAlarm(AlarmRefOrValue parentAlarm) {
        this.parentAlarm = parentAlarm;
        return this;
    }

    @Schema(description="")
    @Valid
    public AlarmRefOrValue getParentAlarm() {
        return this.parentAlarm;
    }

    public void setParentAlarm(AlarmRefOrValue parentAlarm) {
        this.parentAlarm = parentAlarm;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupAlarms groupAlarms = (GroupAlarms)o;
        return Objects.equals(this.id, groupAlarms.id) && Objects.equals(this.href, groupAlarms.href) && Objects.equals(this.alarmChangedTime, groupAlarms.alarmChangedTime) && Objects.equals(this.sourceSystemId, groupAlarms.sourceSystemId) && Objects.equals(this.state, groupAlarms.state) && Objects.equals(this.correlatedAlarm, groupAlarms.correlatedAlarm) && Objects.equals(this.groupedAlarm, groupAlarms.groupedAlarm) && Objects.equals(this.parentAlarm, groupAlarms.parentAlarm) && Objects.equals(this.baseType, groupAlarms.baseType) && Objects.equals(this.schemaLocation, groupAlarms.schemaLocation) && Objects.equals(this.type, groupAlarms.type);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.href, this.alarmChangedTime, this.sourceSystemId, this.state, this.correlatedAlarm, this.groupedAlarm, this.parentAlarm, this.baseType, this.schemaLocation, this.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupAlarms {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    alarmChangedTime: ").append(this.toIndentedString(this.alarmChangedTime)).append("\n");
        sb.append("    sourceSystemId: ").append(this.toIndentedString(this.sourceSystemId)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    correlatedAlarm: ").append(this.toIndentedString(this.correlatedAlarm)).append("\n");
        sb.append("    groupedAlarm: ").append(this.toIndentedString(this.groupedAlarm)).append("\n");
        sb.append("    parentAlarm: ").append(this.toIndentedString(this.parentAlarm)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

