/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.am642.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.validation.Valid;
import java.util.Objects;
import org.etsi.osl.tmf.am642.model.ThresholdRef;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.springframework.validation.annotation.Validated;

@Schema(description="Identifies the details of the threshold that has been crossed.")
@Validated
@Entity(name="AMCrossedThreshInfo")
@Table(name="AMCrossedThreshInfo")
public class CrossedThresholdInformation
extends BaseRootEntity {
    @JsonProperty(value="direction")
    private String direction = null;
    @JsonProperty(value="granularity")
    private String granularity = null;
    @JsonProperty(value="indicatorName")
    private String indicatorName = null;
    @JsonProperty(value="indicatorUnit")
    private String indicatorUnit = null;
    @JsonProperty(value="observedValue")
    private String observedValue = null;
    @JsonProperty(value="thresholdCrossingDescription")
    private String thresholdCrossingDescription = null;
    @JsonProperty(value="threshold")
    @OneToOne(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private ThresholdRef threshold = null;

    public CrossedThresholdInformation direction(String direction) {
        this.direction = direction;
        return this;
    }

    @Schema(description="Indicates the threshold crossing direction: up or down.")
    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public CrossedThresholdInformation granularity(String granularity) {
        this.granularity = granularity;
        return this;
    }

    @Schema(description="Indicates the granularity at which the indicator is evaluated for threshold crossing")
    public String getGranularity() {
        return this.granularity;
    }

    public void setGranularity(String granularity) {
        this.granularity = granularity;
    }

    public CrossedThresholdInformation indicatorName(String indicatorName) {
        this.indicatorName = indicatorName;
        return this;
    }

    @Schema(description="Indicates the name of indicator which crossed the threshold.")
    public String getIndicatorName() {
        return this.indicatorName;
    }

    public void setIndicatorName(String indicatorName) {
        this.indicatorName = indicatorName;
    }

    public CrossedThresholdInformation indicatorUnit(String indicatorUnit) {
        this.indicatorUnit = indicatorUnit;
        return this;
    }

    @Schema(description="Indicates the unit of the measurement of the indicator corresponding to the threshold that has been crossed.")
    public String getIndicatorUnit() {
        return this.indicatorUnit;
    }

    public void setIndicatorUnit(String indicatorUnit) {
        this.indicatorUnit = indicatorUnit;
    }

    public CrossedThresholdInformation observedValue(String observedValue) {
        this.observedValue = observedValue;
        return this;
    }

    @Schema(description="Indicates the value of the indicator which crossed the threshold.")
    public String getObservedValue() {
        return this.observedValue;
    }

    public void setObservedValue(String observedValue) {
        this.observedValue = observedValue;
    }

    public CrossedThresholdInformation thresholdCrossingDescription(String thresholdCrossingDescription) {
        this.thresholdCrossingDescription = thresholdCrossingDescription;
        return this;
    }

    @Schema(description="Indicates further information on the threshold crossing alarm.")
    public String getThresholdCrossingDescription() {
        return this.thresholdCrossingDescription;
    }

    public void setThresholdCrossingDescription(String thresholdCrossingDescription) {
        this.thresholdCrossingDescription = thresholdCrossingDescription;
    }

    public CrossedThresholdInformation threshold(ThresholdRef threshold) {
        this.threshold = threshold;
        return this;
    }

    @Schema(description="")
    @Valid
    public ThresholdRef getThreshold() {
        return this.threshold;
    }

    public void setThreshold(ThresholdRef threshold) {
        this.threshold = threshold;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getAtType() {
        return this.type;
    }

    public void setAtType(String type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CrossedThresholdInformation crossedThresholdInformation = (CrossedThresholdInformation)o;
        return Objects.equals(this.direction, crossedThresholdInformation.direction) && Objects.equals(this.granularity, crossedThresholdInformation.granularity) && Objects.equals(this.indicatorName, crossedThresholdInformation.indicatorName) && Objects.equals(this.indicatorUnit, crossedThresholdInformation.indicatorUnit) && Objects.equals(this.observedValue, crossedThresholdInformation.observedValue) && Objects.equals(this.thresholdCrossingDescription, crossedThresholdInformation.thresholdCrossingDescription) && Objects.equals(this.threshold, crossedThresholdInformation.threshold) && Objects.equals(this.baseType, crossedThresholdInformation.baseType) && Objects.equals(this.schemaLocation, crossedThresholdInformation.schemaLocation) && Objects.equals(this.type, crossedThresholdInformation.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CrossedThresholdInformation {\n");
        sb.append("    direction: ").append(this.toIndentedString(this.direction)).append("\n");
        sb.append("    granularity: ").append(this.toIndentedString(this.granularity)).append("\n");
        sb.append("    indicatorName: ").append(this.toIndentedString(this.indicatorName)).append("\n");
        sb.append("    indicatorUnit: ").append(this.toIndentedString(this.indicatorUnit)).append("\n");
        sb.append("    observedValue: ").append(this.toIndentedString(this.observedValue)).append("\n");
        sb.append("    thresholdCrossingDescription: ").append(this.toIndentedString(this.thresholdCrossingDescription)).append("\n");
        sb.append("    threshold: ").append(this.toIndentedString(this.threshold)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

