/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.am642.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.am642.model.Alarm;
import org.etsi.osl.tmf.am642.model.AlarmRefOrValue;
import org.etsi.osl.tmf.am642.model.Comment;
import org.springframework.validation.annotation.Validated;

@Schema(description="Task resource for comment alarms operation Skipped properties: id,href")
@Validated
public class CommentAlarmsCreate {
    @JsonProperty(value="state")
    private String state = null;
    @JsonProperty(value="alarmPattern")
    @Valid
    private List<Alarm> alarmPattern = new ArrayList<Alarm>();
    @JsonProperty(value="comment")
    private Comment comment = null;
    @JsonProperty(value="commentedAlarm")
    @Valid
    private List<AlarmRefOrValue> commentedAlarm = null;
    @JsonProperty(value="@baseType")
    private String baseType = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@type")
    private String type = null;

    public CommentAlarmsCreate state(String state) {
        this.state = state;
        return this;
    }

    @Schema(description="Current state of the operation task")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public CommentAlarmsCreate alarmPattern(List<Alarm> alarmPattern) {
        this.alarmPattern = alarmPattern;
        return this;
    }

    public CommentAlarmsCreate addAlarmPatternItem(Alarm alarmPatternItem) {
        this.alarmPattern.add(alarmPatternItem);
        return this;
    }

    @Schema(description="Alarm patterns to match target alarms. An alarm will match if all of the sttributes in any of the patterns compare equal to those attributes of the alarm.")
    @NotNull
    @Valid
    @Size(min=1)
    public @NotNull @Valid @Size(min=1) List<Alarm> getAlarmPattern() {
        return this.alarmPattern;
    }

    public void setAlarmPattern(List<Alarm> alarmPattern) {
        this.alarmPattern = alarmPattern;
    }

    public CommentAlarmsCreate comment(Comment comment) {
        this.comment = comment;
        return this;
    }

    @Schema(description="")
    @NotNull
    @Valid
    public Comment getComment() {
        return this.comment;
    }

    public void setComment(Comment comment) {
        this.comment = comment;
    }

    public CommentAlarmsCreate commentedAlarm(List<AlarmRefOrValue> commentedAlarm) {
        this.commentedAlarm = commentedAlarm;
        return this;
    }

    public CommentAlarmsCreate addCommentedAlarmItem(AlarmRefOrValue commentedAlarmItem) {
        if (this.commentedAlarm == null) {
            this.commentedAlarm = new ArrayList<AlarmRefOrValue>();
        }
        this.commentedAlarm.add(commentedAlarmItem);
        return this;
    }

    @Schema(description="The successfully commented alarms")
    @Valid
    public List<AlarmRefOrValue> getCommentedAlarm() {
        return this.commentedAlarm;
    }

    public void setCommentedAlarm(List<AlarmRefOrValue> commentedAlarm) {
        this.commentedAlarm = commentedAlarm;
    }

    public CommentAlarmsCreate baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getAtBaseType() {
        return this.baseType;
    }

    public void setAtBaseType(String baseType) {
        this.baseType = baseType;
    }

    public CommentAlarmsCreate schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this.schemaLocation;
    }

    public void setAtSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public CommentAlarmsCreate type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getAtType() {
        return this.type;
    }

    public void setAtType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommentAlarmsCreate commentAlarmsCreate = (CommentAlarmsCreate)o;
        return Objects.equals(this.state, commentAlarmsCreate.state) && Objects.equals(this.alarmPattern, commentAlarmsCreate.alarmPattern) && Objects.equals(this.comment, commentAlarmsCreate.comment) && Objects.equals(this.commentedAlarm, commentAlarmsCreate.commentedAlarm) && Objects.equals(this.baseType, commentAlarmsCreate.baseType) && Objects.equals(this.schemaLocation, commentAlarmsCreate.schemaLocation) && Objects.equals(this.type, commentAlarmsCreate.type);
    }

    public int hashCode() {
        return Objects.hash(this.state, this.alarmPattern, this.comment, this.commentedAlarm, this.baseType, this.schemaLocation, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CommentAlarmsCreate {\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    alarmPattern: ").append(this.toIndentedString(this.alarmPattern)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    commentedAlarm: ").append(this.toIndentedString(this.commentedAlarm)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

