/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.am642.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.validation.Valid;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.am642.model.Alarm;
import org.etsi.osl.tmf.am642.model.AlarmRefOrValue;
import org.etsi.osl.tmf.am642.model.Comment;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.springframework.validation.annotation.Validated;

@Schema(description="Task resource for comment alarms operation")
@Validated
@Entity(name="AMCommentAlarms")
@Table(name="AMCommentAlarms")
public class CommentAlarms
extends BaseRootEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="state")
    private String state = null;
    @JsonProperty(value="alarmPattern")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<Alarm> alarmPattern = new HashSet<Alarm>();
    @JsonProperty(value="comment")
    @OneToOne(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Comment comment = null;
    @JsonProperty(value="commentedAlarm")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<AlarmRefOrValue> commentedAlarm = new HashSet<AlarmRefOrValue>();

    public String getId() {
        if (this.uuid != null) {
            this.id = this.uuid;
        }
        return this.id;
    }

    public CommentAlarms state(String state) {
        this.state = state;
        return this;
    }

    @Schema(description="Current state of the operation task")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public CommentAlarms alarmPattern(Set<Alarm> alarmPattern) {
        this.alarmPattern = alarmPattern;
        return this;
    }

    public CommentAlarms addAlarmPatternItem(Alarm alarmPatternItem) {
        if (this.alarmPattern == null) {
            this.alarmPattern = new HashSet<Alarm>();
        }
        this.alarmPattern.add(alarmPatternItem);
        return this;
    }

    @Schema(description="Alarm patterns to match target alarms. An alarm will match if all of the sttributes in any of the patterns compare equal to those attributes of the alarm.")
    @Valid
    public Set<Alarm> getAlarmPattern() {
        return this.alarmPattern;
    }

    public void setAlarmPattern(Set<Alarm> alarmPattern) {
        this.alarmPattern = alarmPattern;
    }

    public CommentAlarms comment(Comment comment) {
        this.comment = comment;
        return this;
    }

    @Schema(description="")
    @Valid
    public Comment getComment() {
        return this.comment;
    }

    public void setComment(Comment comment) {
        this.comment = comment;
    }

    public CommentAlarms commentedAlarm(Set<AlarmRefOrValue> commentedAlarm) {
        this.commentedAlarm = commentedAlarm;
        return this;
    }

    public CommentAlarms addCommentedAlarmItem(AlarmRefOrValue commentedAlarmItem) {
        if (this.commentedAlarm == null) {
            this.commentedAlarm = new HashSet<AlarmRefOrValue>();
        }
        this.commentedAlarm.add(commentedAlarmItem);
        return this;
    }

    @Schema(description="The successfully commented alarms")
    @Valid
    public Set<AlarmRefOrValue> getCommentedAlarm() {
        return this.commentedAlarm;
    }

    public void setCommentedAlarm(Set<AlarmRefOrValue> commentedAlarm) {
        this.commentedAlarm = commentedAlarm;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommentAlarms commentAlarms = (CommentAlarms)o;
        return Objects.equals(this.id, commentAlarms.id) && Objects.equals(this.href, commentAlarms.href) && Objects.equals(this.state, commentAlarms.state) && Objects.equals(this.alarmPattern, commentAlarms.alarmPattern) && Objects.equals(this.comment, commentAlarms.comment) && Objects.equals(this.commentedAlarm, commentAlarms.commentedAlarm) && Objects.equals(this.baseType, commentAlarms.baseType) && Objects.equals(this.schemaLocation, commentAlarms.schemaLocation) && Objects.equals(this.type, commentAlarms.type);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.href, this.state, this.alarmPattern, this.comment, this.commentedAlarm, this.baseType, this.schemaLocation, this.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CommentAlarms {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    alarmPattern: ").append(this.toIndentedString(this.alarmPattern)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    commentedAlarm: ").append(this.toIndentedString(this.commentedAlarm)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

