/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.am642.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Lob;
import jakarta.persistence.Table;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.springframework.validation.annotation.Validated;

@Schema(description="Indicates the comments entered on the alarm.")
@Validated
@Entity(name="AMcomment")
@Table(name="AMcomment")
public class Comment
extends BaseRootEntity {
    @JsonProperty(value="comment")
    @Lob
    @Column(name="LCOMMENT", columnDefinition="LONGTEXT")
    private String comment = null;
    @JsonProperty(value="systemId")
    private String systemId = null;
    private OffsetDateTime time = null;
    @JsonProperty(value="userId")
    private String userId = null;

    public Comment comment(String comment) {
        this.comment = comment;
        return this;
    }

    @Schema(description="Indicates the text of the comment.")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Comment systemId(String systemId) {
        this.systemId = systemId;
        return this;
    }

    @Schema(description="Indicates the system identifier on which the client set the comment.")
    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public Comment time(OffsetDateTime time) {
        this.time = time;
        return this;
    }

    @Schema(description="Indicates the time commenting the alarm")
    @Valid
    public OffsetDateTime getTime() {
        return this.time;
    }

    public void setTime(OffsetDateTime time) {
        this.time = time;
    }

    @JsonProperty(value="time")
    public String getTimeStr() {
        if (this.time != null) {
            return this.time.toString();
        }
        return null;
    }

    public void setTime(String time) {
        if (time != null) {
            this.time = OffsetDateTime.parse(time);
        }
    }

    public Comment userId(String userId) {
        this.userId = userId;
        return this;
    }

    @Schema(description="Indicates the user commenting the alarm.")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Comment comment = (Comment)o;
        return Objects.equals(this.comment, comment.comment) && Objects.equals(this.systemId, comment.systemId) && Objects.equals(this.time, comment.time) && Objects.equals(this.userId, comment.userId) && Objects.equals(this.baseType, comment.baseType) && Objects.equals(this.schemaLocation, comment.schemaLocation) && Objects.equals(this.type, comment.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Comment {\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    systemId: ").append(this.toIndentedString(this.systemId)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

