/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.am642.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.am642.model.Alarm;
import org.etsi.osl.tmf.am642.model.AlarmRefOrValue;
import org.springframework.validation.annotation.Validated;

@Schema(description="Task resource for clear alarms operation Skipped properties: id,href")
@Validated
public class ClearAlarmsCreate {
    @JsonProperty(value="alarmClearedTime")
    private OffsetDateTime alarmClearedTime = null;
    @JsonProperty(value="clearSystemId")
    private String clearSystemId = null;
    @JsonProperty(value="clearUserId")
    private String clearUserId = null;
    @JsonProperty(value="state")
    private String state = null;
    @JsonProperty(value="alarmPattern")
    @Valid
    private List<Alarm> alarmPattern = new ArrayList<Alarm>();
    @JsonProperty(value="clearedAlarm")
    @Valid
    private List<AlarmRefOrValue> clearedAlarm = null;
    @JsonProperty(value="@baseType")
    private String baseType = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@type")
    private String type = null;

    public ClearAlarmsCreate alarmClearedTime(OffsetDateTime alarmClearedTime) {
        this.alarmClearedTime = alarmClearedTime;
        return this;
    }

    @Schema(description="Time of the alarm clearing")
    @NotNull
    @Valid
    public OffsetDateTime getAlarmClearedTime() {
        return this.alarmClearedTime;
    }

    public void setAlarmClearedTime(OffsetDateTime alarmClearedTime) {
        this.alarmClearedTime = alarmClearedTime;
    }

    public ClearAlarmsCreate clearSystemId(String clearSystemId) {
        this.clearSystemId = clearSystemId;
        return this;
    }

    @Schema(description="Name of the clearing system")
    @NotNull
    public String getClearSystemId() {
        return this.clearSystemId;
    }

    public void setClearSystemId(String clearSystemId) {
        this.clearSystemId = clearSystemId;
    }

    public ClearAlarmsCreate clearUserId(String clearUserId) {
        this.clearUserId = clearUserId;
        return this;
    }

    @Schema(description="Name of the clearing user")
    @NotNull
    public String getClearUserId() {
        return this.clearUserId;
    }

    public void setClearUserId(String clearUserId) {
        this.clearUserId = clearUserId;
    }

    public ClearAlarmsCreate state(String state) {
        this.state = state;
        return this;
    }

    @Schema(description="Current state of the operation task")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public ClearAlarmsCreate alarmPattern(List<Alarm> alarmPattern) {
        this.alarmPattern = alarmPattern;
        return this;
    }

    public ClearAlarmsCreate addAlarmPatternItem(Alarm alarmPatternItem) {
        this.alarmPattern.add(alarmPatternItem);
        return this;
    }

    @Schema(description="Alarm patterns to match target alarms. An alarm will match if all of the sttributes in any of the patterns compare equal to those attributes of the alarm.")
    @NotNull
    @Valid
    @Size(min=1)
    public @NotNull @Valid @Size(min=1) List<Alarm> getAlarmPattern() {
        return this.alarmPattern;
    }

    public void setAlarmPattern(List<Alarm> alarmPattern) {
        this.alarmPattern = alarmPattern;
    }

    public ClearAlarmsCreate clearedAlarm(List<AlarmRefOrValue> clearedAlarm) {
        this.clearedAlarm = clearedAlarm;
        return this;
    }

    public ClearAlarmsCreate addClearedAlarmItem(AlarmRefOrValue clearedAlarmItem) {
        if (this.clearedAlarm == null) {
            this.clearedAlarm = new ArrayList<AlarmRefOrValue>();
        }
        this.clearedAlarm.add(clearedAlarmItem);
        return this;
    }

    @Schema(description="The successfully cleared alarms")
    @Valid
    public List<AlarmRefOrValue> getClearedAlarm() {
        return this.clearedAlarm;
    }

    public void setClearedAlarm(List<AlarmRefOrValue> clearedAlarm) {
        this.clearedAlarm = clearedAlarm;
    }

    public ClearAlarmsCreate baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getAtBaseType() {
        return this.baseType;
    }

    public void setAtBaseType(String baseType) {
        this.baseType = baseType;
    }

    public ClearAlarmsCreate schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this.schemaLocation;
    }

    public void setAtSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public ClearAlarmsCreate type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getAtType() {
        return this.type;
    }

    public void setAtType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClearAlarmsCreate clearAlarmsCreate = (ClearAlarmsCreate)o;
        return Objects.equals(this.alarmClearedTime, clearAlarmsCreate.alarmClearedTime) && Objects.equals(this.clearSystemId, clearAlarmsCreate.clearSystemId) && Objects.equals(this.clearUserId, clearAlarmsCreate.clearUserId) && Objects.equals(this.state, clearAlarmsCreate.state) && Objects.equals(this.alarmPattern, clearAlarmsCreate.alarmPattern) && Objects.equals(this.clearedAlarm, clearAlarmsCreate.clearedAlarm) && Objects.equals(this.baseType, clearAlarmsCreate.baseType) && Objects.equals(this.schemaLocation, clearAlarmsCreate.schemaLocation) && Objects.equals(this.type, clearAlarmsCreate.type);
    }

    public int hashCode() {
        return Objects.hash(this.alarmClearedTime, this.clearSystemId, this.clearUserId, this.state, this.alarmPattern, this.clearedAlarm, this.baseType, this.schemaLocation, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ClearAlarmsCreate {\n");
        sb.append("    alarmClearedTime: ").append(this.toIndentedString(this.alarmClearedTime)).append("\n");
        sb.append("    clearSystemId: ").append(this.toIndentedString(this.clearSystemId)).append("\n");
        sb.append("    clearUserId: ").append(this.toIndentedString(this.clearUserId)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    alarmPattern: ").append(this.toIndentedString(this.alarmPattern)).append("\n");
        sb.append("    clearedAlarm: ").append(this.toIndentedString(this.clearedAlarm)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

