/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.am642.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.am642.model.Alarm;
import org.etsi.osl.tmf.am642.model.AlarmRefOrValue;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.springframework.validation.annotation.Validated;

@Schema(description="Task resource for clear alarms operation")
@Validated
@Entity(name="AMClearAlarms")
@Table(name="AMClearAlarms")
@ApiResponse
public class ClearAlarms
extends BaseRootEntity {
    @JsonProperty(value="id")
    private String id = null;
    private OffsetDateTime alarmClearedTime = null;
    @JsonProperty(value="clearSystemId")
    private String clearSystemId = null;
    @JsonProperty(value="clearUserId")
    private String clearUserId = null;
    @JsonProperty(value="state")
    private String state = null;
    @JsonProperty(value="alarmPattern")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<Alarm> alarmPattern = new HashSet<Alarm>();
    @JsonProperty(value="clearedAlarm")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<AlarmRefOrValue> clearedAlarm = new HashSet<AlarmRefOrValue>();

    public String getId() {
        if (this.uuid != null) {
            this.id = this.uuid;
        }
        return this.id;
    }

    public ClearAlarms alarmClearedTime(OffsetDateTime alarmClearedTime) {
        this.alarmClearedTime = alarmClearedTime;
        return this;
    }

    @Schema(description="Time of the alarm clearing")
    @Valid
    public OffsetDateTime getAlarmClearedTime() {
        return this.alarmClearedTime;
    }

    public void setAlarmClearedTime(OffsetDateTime alarmClearedTime) {
        this.alarmClearedTime = alarmClearedTime;
    }

    @JsonProperty(value="alarmClearedTime")
    public String getAlarmClearedTimeStr() {
        if (this.alarmClearedTime != null) {
            return this.alarmClearedTime.toString();
        }
        return null;
    }

    public ClearAlarms clearSystemId(String clearSystemId) {
        this.clearSystemId = clearSystemId;
        return this;
    }

    @Schema(description="Name of the clearing system")
    public String getClearSystemId() {
        return this.clearSystemId;
    }

    public void setClearSystemId(String clearSystemId) {
        this.clearSystemId = clearSystemId;
    }

    public ClearAlarms clearUserId(String clearUserId) {
        this.clearUserId = clearUserId;
        return this;
    }

    @Schema(description="Name of the clearing user")
    public String getClearUserId() {
        return this.clearUserId;
    }

    public void setClearUserId(String clearUserId) {
        this.clearUserId = clearUserId;
    }

    public ClearAlarms state(String state) {
        this.state = state;
        return this;
    }

    @Schema(description="Current state of the operation task")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public ClearAlarms alarmPattern(Set<Alarm> alarmPattern) {
        this.alarmPattern = alarmPattern;
        return this;
    }

    public ClearAlarms addAlarmPatternItem(Alarm alarmPatternItem) {
        if (this.alarmPattern == null) {
            this.alarmPattern = new HashSet<Alarm>();
        }
        this.alarmPattern.add(alarmPatternItem);
        return this;
    }

    @Schema(description="Alarm patterns to match target alarms. An alarm will match if all of the sttributes in any of the patterns compare equal to those attributes of the alarm.")
    @Valid
    public Set<Alarm> getAlarmPattern() {
        return this.alarmPattern;
    }

    public void setAlarmPattern(Set<Alarm> alarmPattern) {
        this.alarmPattern = alarmPattern;
    }

    public ClearAlarms clearedAlarm(Set<AlarmRefOrValue> clearedAlarm) {
        this.clearedAlarm = clearedAlarm;
        return this;
    }

    public ClearAlarms addClearedAlarmItem(AlarmRefOrValue clearedAlarmItem) {
        if (this.clearedAlarm == null) {
            this.clearedAlarm = new HashSet<AlarmRefOrValue>();
        }
        this.clearedAlarm.add(clearedAlarmItem);
        return this;
    }

    @Schema(description="The successfully cleared alarms")
    @Valid
    public Set<AlarmRefOrValue> getClearedAlarm() {
        return this.clearedAlarm;
    }

    public void setClearedAlarm(Set<AlarmRefOrValue> clearedAlarm) {
        this.clearedAlarm = clearedAlarm;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClearAlarms clearAlarms = (ClearAlarms)o;
        return Objects.equals(this.id, clearAlarms.id) && Objects.equals(this.href, clearAlarms.href) && Objects.equals(this.alarmClearedTime, clearAlarms.alarmClearedTime) && Objects.equals(this.clearSystemId, clearAlarms.clearSystemId) && Objects.equals(this.clearUserId, clearAlarms.clearUserId) && Objects.equals(this.state, clearAlarms.state) && Objects.equals(this.alarmPattern, clearAlarms.alarmPattern) && Objects.equals(this.clearedAlarm, clearAlarms.clearedAlarm) && Objects.equals(this.baseType, clearAlarms.baseType) && Objects.equals(this.schemaLocation, clearAlarms.schemaLocation) && Objects.equals(this.type, clearAlarms.type);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.href, this.alarmClearedTime, this.clearSystemId, this.clearUserId, this.state, this.alarmPattern, this.clearedAlarm, this.baseType, this.schemaLocation, this.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ClearAlarms {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    alarmClearedTime: ").append(this.toIndentedString(this.alarmClearedTime)).append("\n");
        sb.append("    clearSystemId: ").append(this.toIndentedString(this.clearSystemId)).append("\n");
        sb.append("    clearUserId: ").append(this.toIndentedString(this.clearUserId)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    alarmPattern: ").append(this.toIndentedString(this.alarmPattern)).append("\n");
        sb.append("    clearedAlarm: ").append(this.toIndentedString(this.clearedAlarm)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

