/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.am642.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.am642.model.AffectedService;
import org.etsi.osl.tmf.am642.model.AlarmRef;
import org.etsi.osl.tmf.am642.model.AlarmedObject;
import org.etsi.osl.tmf.am642.model.Comment;
import org.etsi.osl.tmf.am642.model.CrossedThresholdInformation;
import org.etsi.osl.tmf.am642.model.RelatedPlaceRefOrValue;
import org.springframework.validation.annotation.Validated;

@Schema(description="This resource represents an alarm supporting the information model defined in ITU-T X.733. Skipped properties: id,href,alarmRaisedTime,sourceSystemId")
@Validated
public class AlarmUpdate {
    @JsonProperty(value="ackState")
    protected String ackState = null;
    @JsonProperty(value="ackSystemId")
    protected String ackSystemId = null;
    @JsonProperty(value="ackUserId")
    protected String ackUserId = null;
    protected OffsetDateTime alarmChangedTime = null;
    protected OffsetDateTime alarmClearedTime = null;
    @JsonProperty(value="alarmDetails")
    protected String alarmDetails = null;
    @JsonProperty(value="alarmEscalation")
    protected Boolean alarmEscalation = null;
    protected OffsetDateTime alarmReportingTime = null;
    @JsonProperty(value="alarmType")
    protected String alarmType = null;
    @JsonProperty(value="alarmedObjectType")
    protected String alarmedObjectType = null;
    @JsonProperty(value="clearSystemId")
    protected String clearSystemId = null;
    @JsonProperty(value="clearUserId")
    protected String clearUserId = null;
    @JsonProperty(value="externalAlarmId")
    protected String externalAlarmId = null;
    @JsonProperty(value="isRootCause")
    protected Boolean isRootCause = null;
    @JsonProperty(value="perceivedSeverity")
    protected String perceivedSeverity = null;
    @JsonProperty(value="plannedOutageIndicator")
    protected String plannedOutageIndicator = null;
    @JsonProperty(value="probableCause")
    protected String probableCause = null;
    @JsonProperty(value="proposedRepairedActions")
    protected String proposedRepairedActions = null;
    @JsonProperty(value="reportingSystemId")
    protected String reportingSystemId = null;
    @JsonProperty(value="serviceAffecting")
    protected Boolean serviceAffecting = null;
    @JsonProperty(value="specificProblem")
    protected String specificProblem = null;
    @JsonProperty(value="state")
    protected String state = null;
    @JsonProperty(value="affectedService")
    @Valid
    protected List<AffectedService> affectedService = null;
    @JsonProperty(value="alarmedObject")
    protected AlarmedObject alarmedObject = null;
    @JsonProperty(value="comment")
    @Valid
    protected List<Comment> comment = null;
    @JsonProperty(value="correlatedAlarm")
    @Valid
    protected List<AlarmRef> correlatedAlarm = null;
    @JsonProperty(value="crossedThresholdInformation")
    protected CrossedThresholdInformation crossedThresholdInformation = null;
    @JsonProperty(value="parentAlarm")
    @Valid
    protected List<AlarmRef> parentAlarm = null;
    @JsonProperty(value="place")
    @Valid
    protected List<RelatedPlaceRefOrValue> place = null;
    @JsonProperty(value="@baseType")
    protected String baseType = null;
    @JsonProperty(value="@schemaLocation")
    protected String schemaLocation = null;
    @JsonProperty(value="@type")
    protected String type = null;

    public AlarmUpdate ackState(String ackState) {
        this.ackState = ackState;
        return this;
    }

    @Schema(description="Provides the Acknowledgement State of the alarm")
    public String getAckState() {
        return this.ackState;
    }

    public void setAckState(String ackState) {
        this.ackState = ackState;
    }

    public AlarmUpdate ackSystemId(String ackSystemId) {
        this.ackSystemId = ackSystemId;
        return this;
    }

    @Schema(description="Provides the name of the system that last changed the ackState of an alarm, i.e. acknowledged or unacknowledged the alarm.")
    public String getAckSystemId() {
        return this.ackSystemId;
    }

    public void setAckSystemId(String ackSystemId) {
        this.ackSystemId = ackSystemId;
    }

    public AlarmUpdate ackUserId(String ackUserId) {
        this.ackUserId = ackUserId;
        return this;
    }

    @Schema(description="Provides the id of the user who has last changed the ack state of the alarm, i.e. acknowledged or unacknowledged the alarm.")
    public String getAckUserId() {
        return this.ackUserId;
    }

    public void setAckUserId(String ackUserId) {
        this.ackUserId = ackUserId;
    }

    public AlarmUpdate alarmChangedTime(OffsetDateTime alarmChangedTime) {
        this.alarmChangedTime = alarmChangedTime;
        return this;
    }

    @Schema(description="Indicates the last date and time when the alarm is changed on the alarm-owning system. Any change to the alarm whether coming from the alarmed resource, or triggered by a change from the client is changing this time.")
    @Valid
    public OffsetDateTime getAlarmChangedTime() {
        return this.alarmChangedTime;
    }

    @JsonProperty(value="alarmChangedTime")
    public String getAlarmChangedTimeStr() {
        if (this.alarmChangedTime != null) {
            return this.alarmChangedTime.toString();
        }
        return null;
    }

    public void setAlarmChangedTime(String alarmChangedTime) {
        if (alarmChangedTime != null) {
            this.alarmChangedTime = OffsetDateTime.parse(alarmChangedTime);
        }
    }

    public void setAlarmChangedTime(OffsetDateTime alarmChangedTime) {
        this.alarmChangedTime = alarmChangedTime;
    }

    public AlarmUpdate alarmClearedTime(OffsetDateTime alarmClearedTime) {
        this.alarmClearedTime = alarmClearedTime;
        return this;
    }

    @Schema(description="Indicates the time (as a date + time) at which the alarm is cleared at the source. ")
    @Valid
    public OffsetDateTime getAlarmClearedTime() {
        return this.alarmClearedTime;
    }

    public void setAlarmClearedTime(OffsetDateTime alarmClearedTime) {
        this.alarmClearedTime = alarmClearedTime;
    }

    @JsonProperty(value="alarmClearedTime")
    public String getAlarmClearedTimeStr() {
        if (this.alarmClearedTime != null) {
            return this.alarmClearedTime.toString();
        }
        return null;
    }

    public void setAlarmClearedTime(String alarmClearedTime) {
        if (alarmClearedTime != null) {
            this.alarmClearedTime = OffsetDateTime.parse(alarmClearedTime);
        }
    }

    public AlarmUpdate alarmDetails(String alarmDetails) {
        this.alarmDetails = alarmDetails;
        return this;
    }

    @Schema(description="Contains further information on the alarm.")
    public String getAlarmDetails() {
        return this.alarmDetails;
    }

    public void setAlarmDetails(String alarmDetails) {
        this.alarmDetails = alarmDetails;
    }

    public AlarmUpdate alarmEscalation(Boolean alarmEscalation) {
        this.alarmEscalation = alarmEscalation;
        return this;
    }

    @Schema(description="Indicates if this alarm has been escalated or not. ")
    public Boolean isAlarmEscalation() {
        return this.alarmEscalation;
    }

    public void setAlarmEscalation(Boolean alarmEscalation) {
        this.alarmEscalation = alarmEscalation;
    }

    public AlarmUpdate alarmReportingTime(OffsetDateTime alarmReportingTime) {
        this.alarmReportingTime = alarmReportingTime;
        return this;
    }

    @Schema(description="Indicates the time (as a date + time) at which the alarm was reported by the owning OSS. It might be different from the alarmRaisedTime. For instance, if the alarm list is maintained by an EMS, the alarmRaisedtime would be the time the alarm   was detected by the NE, while the alarmReportingTime would be the time this alarm was stored in the alarm list of the EMS.")
    @Valid
    public OffsetDateTime getAlarmReportingTime() {
        return this.alarmReportingTime;
    }

    public void setAlarmReportingTime(OffsetDateTime alarmReportingTime) {
        this.alarmReportingTime = alarmReportingTime;
    }

    @JsonProperty(value="alarmReportingTime")
    public String getAlarmReportingTimeStr() {
        if (this.alarmReportingTime != null) {
            return this.alarmReportingTime.toString();
        }
        return null;
    }

    public void setAlarmReportingTime(String alarmReportingTime) {
        if (alarmReportingTime != null) {
            this.alarmReportingTime = OffsetDateTime.parse(alarmReportingTime);
        }
    }

    public AlarmUpdate alarmType(String alarmType) {
        this.alarmType = alarmType;
        return this;
    }

    @Schema(description="Categorize the alarm. Should be one of the values defined in X.733 8.1.1 or 3GPP TS 32.111-2 Annex A:  Communications Alarm  Processing Error Alarm  Environmental Alarm  Quality of Service Alarm  Equipment Alarm  Integrity Violation  Operational Violation  Physical Violation  Security Service or Mechanism Violation  Time Domain Violation")
    public String getAlarmType() {
        return this.alarmType;
    }

    public void setAlarmType(String alarmType) {
        this.alarmType = alarmType;
    }

    public AlarmUpdate alarmedObjectType(String alarmedObjectType) {
        this.alarmedObjectType = alarmedObjectType;
        return this;
    }

    @Schema(description="The type (class) of the managed object associated with the event.")
    public String getAlarmedObjectType() {
        return this.alarmedObjectType;
    }

    public void setAlarmedObjectType(String alarmedObjectType) {
        this.alarmedObjectType = alarmedObjectType;
    }

    public AlarmUpdate clearSystemId(String clearSystemId) {
        this.clearSystemId = clearSystemId;
        return this;
    }

    @Schema(description="Provides the id of the system where the user who invoked the alarmCleared operation is located. ")
    public String getClearSystemId() {
        return this.clearSystemId;
    }

    public void setClearSystemId(String clearSystemId) {
        this.clearSystemId = clearSystemId;
    }

    public AlarmUpdate clearUserId(String clearUserId) {
        this.clearUserId = clearUserId;
        return this;
    }

    @Schema(description="Provides the id of the user who invoked the alarmCleared operation")
    public String getClearUserId() {
        return this.clearUserId;
    }

    public void setClearUserId(String clearUserId) {
        this.clearUserId = clearUserId;
    }

    public AlarmUpdate externalAlarmId(String externalAlarmId) {
        this.externalAlarmId = externalAlarmId;
        return this;
    }

    @Schema(description="An identifier of the alarm in the source system.")
    public String getExternalAlarmId() {
        return this.externalAlarmId;
    }

    public void setExternalAlarmId(String externalAlarmId) {
        this.externalAlarmId = externalAlarmId;
    }

    public AlarmUpdate isRootCause(Boolean isRootCause) {
        this.isRootCause = isRootCause;
        return this;
    }

    @Schema(description="Indicates whether the alarm is a root cause alarm.. ")
    public Boolean isIsRootCause() {
        return this.isRootCause;
    }

    public void setIsRootCause(Boolean isRootCause) {
        this.isRootCause = isRootCause;
    }

    public AlarmUpdate perceivedSeverity(String perceivedSeverity) {
        this.perceivedSeverity = perceivedSeverity;
        return this;
    }

    @Schema(description="Lists the possible severities that can be allocated to an Alarm. The values are consistent with ITU-T Recommendation X.733. Once an alarm has been cleared, its perceived severity is set to 'cleared' and can no longer be set.")
    public String getPerceivedSeverity() {
        return this.perceivedSeverity;
    }

    public void setPerceivedSeverity(String perceivedSeverity) {
        this.perceivedSeverity = perceivedSeverity;
    }

    public AlarmUpdate plannedOutageIndicator(String plannedOutageIndicator) {
        this.plannedOutageIndicator = plannedOutageIndicator;
        return this;
    }

    @Schema(description="Indicates that the Managed Object (related to this alarm) is in planned outage (in planned maintenance, or out-of-service). ")
    public String getPlannedOutageIndicator() {
        return this.plannedOutageIndicator;
    }

    public void setPlannedOutageIndicator(String plannedOutageIndicator) {
        this.plannedOutageIndicator = plannedOutageIndicator;
    }

    public AlarmUpdate probableCause(String probableCause) {
        this.probableCause = probableCause;
        return this;
    }

    @Schema(description="Provides the probable cause of the alarm. The values are consistent with ITU-T Recommendation X.733 or 3GPP TS 32.111-2 Annex B.")
    public String getProbableCause() {
        return this.probableCause;
    }

    public void setProbableCause(String probableCause) {
        this.probableCause = probableCause;
    }

    public AlarmUpdate proposedRepairedActions(String proposedRepairedActions) {
        this.proposedRepairedActions = proposedRepairedActions;
        return this;
    }

    @Schema(description="Indicates proposed repair actions, if known to the system emitting the alarm.")
    public String getProposedRepairedActions() {
        return this.proposedRepairedActions;
    }

    public void setProposedRepairedActions(String proposedRepairedActions) {
        this.proposedRepairedActions = proposedRepairedActions;
    }

    public AlarmUpdate reportingSystemId(String reportingSystemId) {
        this.reportingSystemId = reportingSystemId;
        return this;
    }

    @Schema(description="Reporting system identity.")
    public String getReportingSystemId() {
        return this.reportingSystemId;
    }

    public void setReportingSystemId(String reportingSystemId) {
        this.reportingSystemId = reportingSystemId;
    }

    public AlarmUpdate serviceAffecting(Boolean serviceAffecting) {
        this.serviceAffecting = serviceAffecting;
        return this;
    }

    @Schema(description="Indicates whether the alarm affects service or not.")
    public Boolean isServiceAffecting() {
        return this.serviceAffecting;
    }

    public void setServiceAffecting(Boolean serviceAffecting) {
        this.serviceAffecting = serviceAffecting;
    }

    public AlarmUpdate specificProblem(String specificProblem) {
        this.specificProblem = specificProblem;
        return this;
    }

    @Schema(description="Provides more specific information about the alarm.")
    public String getSpecificProblem() {
        return this.specificProblem;
    }

    public void setSpecificProblem(String specificProblem) {
        this.specificProblem = specificProblem;
    }

    public AlarmUpdate state(String state) {
        this.state = state;
        return this;
    }

    @Schema(description="Defines the alarm state during its life cycle")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public AlarmUpdate affectedService(List<AffectedService> affectedService) {
        this.affectedService = affectedService;
        return this;
    }

    public AlarmUpdate addAffectedServiceItem(AffectedService affectedServiceItem) {
        if (this.affectedService == null) {
            this.affectedService = new ArrayList<AffectedService>();
        }
        this.affectedService.add(affectedServiceItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<AffectedService> getAffectedService() {
        return this.affectedService;
    }

    public void setAffectedService(List<AffectedService> affectedService) {
        this.affectedService = affectedService;
    }

    public AlarmUpdate alarmedObject(AlarmedObject alarmedObject) {
        this.alarmedObject = alarmedObject;
        return this;
    }

    @Schema(description="")
    @Valid
    public AlarmedObject getAlarmedObject() {
        return this.alarmedObject;
    }

    public void setAlarmedObject(AlarmedObject alarmedObject) {
        this.alarmedObject = alarmedObject;
    }

    public AlarmUpdate comment(List<Comment> comment) {
        this.comment = comment;
        return this;
    }

    public AlarmUpdate addCommentItem(Comment commentItem) {
        if (this.comment == null) {
            this.comment = new ArrayList<Comment>();
        }
        this.comment.add(commentItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<Comment> getComment() {
        return this.comment;
    }

    public void setComment(List<Comment> comment) {
        this.comment = comment;
    }

    public AlarmUpdate correlatedAlarm(List<AlarmRef> correlatedAlarm) {
        this.correlatedAlarm = correlatedAlarm;
        return this;
    }

    public AlarmUpdate addCorrelatedAlarmItem(AlarmRef correlatedAlarmItem) {
        if (this.correlatedAlarm == null) {
            this.correlatedAlarm = new ArrayList<AlarmRef>();
        }
        this.correlatedAlarm.add(correlatedAlarmItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<AlarmRef> getCorrelatedAlarm() {
        return this.correlatedAlarm;
    }

    public void setCorrelatedAlarm(List<AlarmRef> correlatedAlarm) {
        this.correlatedAlarm = correlatedAlarm;
    }

    public AlarmUpdate crossedThresholdInformation(CrossedThresholdInformation crossedThresholdInformation) {
        this.crossedThresholdInformation = crossedThresholdInformation;
        return this;
    }

    @Schema(description="")
    @Valid
    public CrossedThresholdInformation getCrossedThresholdInformation() {
        return this.crossedThresholdInformation;
    }

    public void setCrossedThresholdInformation(CrossedThresholdInformation crossedThresholdInformation) {
        this.crossedThresholdInformation = crossedThresholdInformation;
    }

    public AlarmUpdate parentAlarm(List<AlarmRef> parentAlarm) {
        this.parentAlarm = parentAlarm;
        return this;
    }

    public AlarmUpdate addParentAlarmItem(AlarmRef parentAlarmItem) {
        if (this.parentAlarm == null) {
            this.parentAlarm = new ArrayList<AlarmRef>();
        }
        this.parentAlarm.add(parentAlarmItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<AlarmRef> getParentAlarm() {
        return this.parentAlarm;
    }

    public void setParentAlarm(List<AlarmRef> parentAlarm) {
        this.parentAlarm = parentAlarm;
    }

    public AlarmUpdate place(List<RelatedPlaceRefOrValue> place) {
        this.place = place;
        return this;
    }

    public AlarmUpdate addPlaceItem(RelatedPlaceRefOrValue placeItem) {
        if (this.place == null) {
            this.place = new ArrayList<RelatedPlaceRefOrValue>();
        }
        this.place.add(placeItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public List<RelatedPlaceRefOrValue> getPlace() {
        return this.place;
    }

    public void setPlace(List<RelatedPlaceRefOrValue> place) {
        this.place = place;
    }

    public AlarmUpdate baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="The base type of this alarm.")
    public String getAtBaseType() {
        return this.baseType;
    }

    public void setAtBaseType(String baseType) {
        this.baseType = baseType;
    }

    public AlarmUpdate schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A reference to the schema describing this alarm.")
    public String getAtSchemaLocation() {
        return this.schemaLocation;
    }

    public void setAtSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public AlarmUpdate type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="The type for this alarm.")
    public String getAtType() {
        return this.type;
    }

    public void setAtType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlarmUpdate alarmUpdate = (AlarmUpdate)o;
        return Objects.equals(this.ackState, alarmUpdate.ackState) && Objects.equals(this.ackSystemId, alarmUpdate.ackSystemId) && Objects.equals(this.ackUserId, alarmUpdate.ackUserId) && Objects.equals(this.alarmChangedTime, alarmUpdate.alarmChangedTime) && Objects.equals(this.alarmClearedTime, alarmUpdate.alarmClearedTime) && Objects.equals(this.alarmDetails, alarmUpdate.alarmDetails) && Objects.equals(this.alarmEscalation, alarmUpdate.alarmEscalation) && Objects.equals(this.alarmReportingTime, alarmUpdate.alarmReportingTime) && Objects.equals(this.alarmType, alarmUpdate.alarmType) && Objects.equals(this.alarmedObjectType, alarmUpdate.alarmedObjectType) && Objects.equals(this.clearSystemId, alarmUpdate.clearSystemId) && Objects.equals(this.clearUserId, alarmUpdate.clearUserId) && Objects.equals(this.externalAlarmId, alarmUpdate.externalAlarmId) && Objects.equals(this.isRootCause, alarmUpdate.isRootCause) && Objects.equals(this.perceivedSeverity, alarmUpdate.perceivedSeverity) && Objects.equals(this.plannedOutageIndicator, alarmUpdate.plannedOutageIndicator) && Objects.equals(this.probableCause, alarmUpdate.probableCause) && Objects.equals(this.proposedRepairedActions, alarmUpdate.proposedRepairedActions) && Objects.equals(this.reportingSystemId, alarmUpdate.reportingSystemId) && Objects.equals(this.serviceAffecting, alarmUpdate.serviceAffecting) && Objects.equals(this.specificProblem, alarmUpdate.specificProblem) && Objects.equals(this.state, alarmUpdate.state) && Objects.equals(this.affectedService, alarmUpdate.affectedService) && Objects.equals(this.alarmedObject, alarmUpdate.alarmedObject) && Objects.equals(this.comment, alarmUpdate.comment) && Objects.equals(this.correlatedAlarm, alarmUpdate.correlatedAlarm) && Objects.equals(this.crossedThresholdInformation, alarmUpdate.crossedThresholdInformation) && Objects.equals(this.parentAlarm, alarmUpdate.parentAlarm) && Objects.equals(this.place, alarmUpdate.place) && Objects.equals(this.baseType, alarmUpdate.baseType) && Objects.equals(this.schemaLocation, alarmUpdate.schemaLocation) && Objects.equals(this.type, alarmUpdate.type);
    }

    public int hashCode() {
        return Objects.hash(this.ackState, this.ackSystemId, this.ackUserId, this.alarmChangedTime, this.alarmClearedTime, this.alarmDetails, this.alarmEscalation, this.alarmReportingTime, this.alarmType, this.alarmedObjectType, this.clearSystemId, this.clearUserId, this.externalAlarmId, this.isRootCause, this.perceivedSeverity, this.plannedOutageIndicator, this.probableCause, this.proposedRepairedActions, this.reportingSystemId, this.serviceAffecting, this.specificProblem, this.state, this.affectedService, this.alarmedObject, this.comment, this.correlatedAlarm, this.crossedThresholdInformation, this.parentAlarm, this.place, this.baseType, this.schemaLocation, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AlarmUpdate {\n");
        sb.append("    ackState: ").append(this.toIndentedString(this.ackState)).append("\n");
        sb.append("    ackSystemId: ").append(this.toIndentedString(this.ackSystemId)).append("\n");
        sb.append("    ackUserId: ").append(this.toIndentedString(this.ackUserId)).append("\n");
        sb.append("    alarmChangedTime: ").append(this.toIndentedString(this.alarmChangedTime)).append("\n");
        sb.append("    alarmClearedTime: ").append(this.toIndentedString(this.alarmClearedTime)).append("\n");
        sb.append("    alarmDetails: ").append(this.toIndentedString(this.alarmDetails)).append("\n");
        sb.append("    alarmEscalation: ").append(this.toIndentedString(this.alarmEscalation)).append("\n");
        sb.append("    alarmReportingTime: ").append(this.toIndentedString(this.alarmReportingTime)).append("\n");
        sb.append("    alarmType: ").append(this.toIndentedString(this.alarmType)).append("\n");
        sb.append("    alarmedObjectType: ").append(this.toIndentedString(this.alarmedObjectType)).append("\n");
        sb.append("    clearSystemId: ").append(this.toIndentedString(this.clearSystemId)).append("\n");
        sb.append("    clearUserId: ").append(this.toIndentedString(this.clearUserId)).append("\n");
        sb.append("    externalAlarmId: ").append(this.toIndentedString(this.externalAlarmId)).append("\n");
        sb.append("    isRootCause: ").append(this.toIndentedString(this.isRootCause)).append("\n");
        sb.append("    perceivedSeverity: ").append(this.toIndentedString(this.perceivedSeverity)).append("\n");
        sb.append("    plannedOutageIndicator: ").append(this.toIndentedString(this.plannedOutageIndicator)).append("\n");
        sb.append("    probableCause: ").append(this.toIndentedString(this.probableCause)).append("\n");
        sb.append("    proposedRepairedActions: ").append(this.toIndentedString(this.proposedRepairedActions)).append("\n");
        sb.append("    reportingSystemId: ").append(this.toIndentedString(this.reportingSystemId)).append("\n");
        sb.append("    serviceAffecting: ").append(this.toIndentedString(this.serviceAffecting)).append("\n");
        sb.append("    specificProblem: ").append(this.toIndentedString(this.specificProblem)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    affectedService: ").append(this.toIndentedString(this.affectedService)).append("\n");
        sb.append("    alarmedObject: ").append(this.toIndentedString(this.alarmedObject)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    correlatedAlarm: ").append(this.toIndentedString(this.correlatedAlarm)).append("\n");
        sb.append("    crossedThresholdInformation: ").append(this.toIndentedString(this.crossedThresholdInformation)).append("\n");
        sb.append("    parentAlarm: ").append(this.toIndentedString(this.parentAlarm)).append("\n");
        sb.append("    place: ").append(this.toIndentedString(this.place)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

