/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.am642.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.am642.model.AffectedService;
import org.etsi.osl.tmf.am642.model.AlarmRef;
import org.etsi.osl.tmf.am642.model.AlarmedObject;
import org.etsi.osl.tmf.am642.model.Comment;
import org.etsi.osl.tmf.am642.model.CrossedThresholdInformation;
import org.etsi.osl.tmf.am642.model.RelatedPlaceRefOrValue;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.springframework.validation.annotation.Validated;

@Schema(description="An alarm defined by reference or value. The polymorphic attributes @type, @schemaLocation & @referredType are related to the alarm entity and not the RelatedAlarmRefOrValue class itself")
@Validated
@Entity(name="AMAlarmRefOrVal")
@Table(name="AMAlarmRefOrVal")
public class AlarmRefOrValue
extends BaseRootNamedEntity {
    @JsonProperty(value="id")
    private Integer id = null;
    @JsonProperty(value="ackState")
    private String ackState = null;
    @JsonProperty(value="ackSystemId")
    private String ackSystemId = null;
    @JsonProperty(value="ackUserId")
    private String ackUserId = null;
    private OffsetDateTime alarmChangedTime = null;
    private OffsetDateTime alarmClearedTime = null;
    @JsonProperty(value="alarmDetails")
    private String alarmDetails = null;
    @JsonProperty(value="alarmEscalation")
    private Boolean alarmEscalation = null;
    private OffsetDateTime alarmRaisedTime = null;
    private OffsetDateTime alarmReportingTime = null;
    @JsonProperty(value="alarmType")
    private String alarmType = null;
    @JsonProperty(value="alarmedObjectType")
    private String alarmedObjectType = null;
    @JsonProperty(value="clearSystemId")
    private String clearSystemId = null;
    @JsonProperty(value="clearUserId")
    private String clearUserId = null;
    @JsonProperty(value="externalAlarmId")
    private String externalAlarmId = null;
    @JsonProperty(value="isRootCause")
    private Boolean isRootCause = null;
    @JsonProperty(value="perceivedSeverity")
    private String perceivedSeverity = null;
    @JsonProperty(value="plannedOutageIndicator")
    private String plannedOutageIndicator = null;
    @JsonProperty(value="probableCause")
    private String probableCause = null;
    @JsonProperty(value="proposedRepairedActions")
    private String proposedRepairedActions = null;
    @JsonProperty(value="reportingSystemId")
    private String reportingSystemId = null;
    @JsonProperty(value="serviceAffecting")
    private Boolean serviceAffecting = null;
    @JsonProperty(value="sourceSystemId")
    private String sourceSystemId = null;
    @JsonProperty(value="specificProblem")
    private String specificProblem = null;
    @JsonProperty(value="state")
    private String state = null;
    @JsonProperty(value="affectedService")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<AffectedService> affectedService = new HashSet<AffectedService>();
    @JsonProperty(value="alarmedObject")
    @OneToOne(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private AlarmedObject alarmedObject = null;
    @JsonProperty(value="comment")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<Comment> comment = new HashSet<Comment>();
    @JsonProperty(value="correlatedAlarm")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<AlarmRef> correlatedAlarm = new HashSet<AlarmRef>();
    @JsonProperty(value="crossedThresholdInformation")
    @OneToOne(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private CrossedThresholdInformation crossedThresholdInformation = null;
    @JsonProperty(value="parentAlarm")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<AlarmRef> parentAlarm = new HashSet<AlarmRef>();
    @JsonProperty(value="place")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<RelatedPlaceRefOrValue> place = new HashSet<RelatedPlaceRefOrValue>();
    @JsonProperty(value="@referredType")
    private String _atReferredType = null;

    public AlarmRefOrValue id(Integer id) {
        this.id = id;
        return this;
    }

    @Schema(description="Identifier of the alarm, determined by the alarm owning system")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public AlarmRefOrValue href(String href) {
        this.href = href;
        return this;
    }

    @Override
    @Schema(description="A reference to the alarm.")
    public String getHref() {
        return this.href;
    }

    @Override
    public void setHref(String href) {
        this.href = href;
    }

    public AlarmRefOrValue ackState(String ackState) {
        this.ackState = ackState;
        return this;
    }

    @Schema(description="Provides the Acknowledgement State of the alarm")
    public String getAckState() {
        return this.ackState;
    }

    public void setAckState(String ackState) {
        this.ackState = ackState;
    }

    public AlarmRefOrValue ackSystemId(String ackSystemId) {
        this.ackSystemId = ackSystemId;
        return this;
    }

    @Schema(description="Provides the name of the system that last changed the ackState of an alarm, i.e. acknowledged or unacknowledged the alarm.")
    public String getAckSystemId() {
        return this.ackSystemId;
    }

    public void setAckSystemId(String ackSystemId) {
        this.ackSystemId = ackSystemId;
    }

    public AlarmRefOrValue ackUserId(String ackUserId) {
        this.ackUserId = ackUserId;
        return this;
    }

    @Schema(description="Provides the id of the user who has last changed the ack state of the alarm, i.e. acknowledged or unacknowledged the alarm.")
    public String getAckUserId() {
        return this.ackUserId;
    }

    public void setAckUserId(String ackUserId) {
        this.ackUserId = ackUserId;
    }

    public AlarmRefOrValue alarmChangedTime(OffsetDateTime alarmChangedTime) {
        this.alarmChangedTime = alarmChangedTime;
        return this;
    }

    @Schema(description="Indicates the last date and time when the alarm is changed on the alarm-owning system. Any change to the alarm whether coming from the alarmed resource, or triggered by a change from the client is changing this time.")
    @Valid
    public OffsetDateTime getAlarmChangedTime() {
        return this.alarmChangedTime;
    }

    public void setAlarmChangedTime(OffsetDateTime alarmChangedTime) {
        this.alarmChangedTime = alarmChangedTime;
    }

    @JsonProperty(value="alarmChangedTime")
    public String getAlarmChangedTimeStr() {
        if (this.alarmChangedTime != null) {
            return this.alarmChangedTime.toString();
        }
        return null;
    }

    public AlarmRefOrValue alarmClearedTime(OffsetDateTime alarmClearedTime) {
        this.alarmClearedTime = alarmClearedTime;
        return this;
    }

    @Schema(description="Indicates the time (as a date + time) at which the alarm is cleared at the source. ")
    @Valid
    public OffsetDateTime getAlarmClearedTime() {
        return this.alarmClearedTime;
    }

    public void setAlarmClearedTime(OffsetDateTime alarmClearedTime) {
        this.alarmClearedTime = alarmClearedTime;
    }

    @JsonProperty(value="alarmClearedTime")
    public String getAlarmClearedTimeStr() {
        if (this.alarmClearedTime != null) {
            return this.alarmClearedTime.toString();
        }
        return null;
    }

    public AlarmRefOrValue alarmDetails(String alarmDetails) {
        this.alarmDetails = alarmDetails;
        return this;
    }

    @Schema(description="Contains further information on the alarm.")
    public String getAlarmDetails() {
        return this.alarmDetails;
    }

    public void setAlarmDetails(String alarmDetails) {
        this.alarmDetails = alarmDetails;
    }

    public AlarmRefOrValue alarmEscalation(Boolean alarmEscalation) {
        this.alarmEscalation = alarmEscalation;
        return this;
    }

    @Schema(description="Indicates if this alarm has been escalated or not. ")
    public Boolean isAlarmEscalation() {
        return this.alarmEscalation;
    }

    public void setAlarmEscalation(Boolean alarmEscalation) {
        this.alarmEscalation = alarmEscalation;
    }

    public AlarmRefOrValue alarmRaisedTime(OffsetDateTime alarmRaisedTime) {
        this.alarmRaisedTime = alarmRaisedTime;
        return this;
    }

    @Schema(description="Indicates the time (as a date + time) at which the alarm occurred at its source.")
    @Valid
    public OffsetDateTime getAlarmRaisedTime() {
        return this.alarmRaisedTime;
    }

    public void setAlarmRaisedTime(OffsetDateTime alarmRaisedTime) {
        this.alarmRaisedTime = alarmRaisedTime;
    }

    @JsonProperty(value="alarmRaisedTime")
    public String getAlarmRaisedTimeStr() {
        if (this.alarmRaisedTime != null) {
            return this.alarmRaisedTime.toString();
        }
        return null;
    }

    public AlarmRefOrValue alarmReportingTime(OffsetDateTime alarmReportingTime) {
        this.alarmReportingTime = alarmReportingTime;
        return this;
    }

    @Schema(description="Indicates the time (as a date + time) at which the alarm was reported by the owning OSS. It might be different from the alarmRaisedTime. For instance, if the alarm list is maintained by an EMS, the alarmRaisedtime would be the time the alarm   was detected by the NE, while the alarmReportingTime would be the time this alarm was stored in the alarm list of the EMS.")
    @Valid
    public OffsetDateTime getAlarmReportingTime() {
        return this.alarmReportingTime;
    }

    public void setAlarmReportingTime(OffsetDateTime alarmReportingTime) {
        this.alarmReportingTime = alarmReportingTime;
    }

    @JsonProperty(value="alarmReportingTime")
    public String getAlarmReportingTimeStr() {
        if (this.alarmReportingTime != null) {
            return this.alarmReportingTime.toString();
        }
        return null;
    }

    public AlarmRefOrValue alarmType(String alarmType) {
        this.alarmType = alarmType;
        return this;
    }

    @Schema(description="Categorize the alarm. Should be one of the values defined in X.733 8.1.1 or 3GPP TS 32.111-2 Annex A:  Communications Alarm  Processing Error Alarm  Environmental Alarm  Quality of Service Alarm  Equipment Alarm  Integrity Violation  Operational Violation  Physical Violation  Security Service or Mechanism Violation  Time Domain Violation")
    public String getAlarmType() {
        return this.alarmType;
    }

    public void setAlarmType(String alarmType) {
        this.alarmType = alarmType;
    }

    public AlarmRefOrValue alarmedObjectType(String alarmedObjectType) {
        this.alarmedObjectType = alarmedObjectType;
        return this;
    }

    @Schema(description="The type (class) of the managed object associated with the event.")
    public String getAlarmedObjectType() {
        return this.alarmedObjectType;
    }

    public void setAlarmedObjectType(String alarmedObjectType) {
        this.alarmedObjectType = alarmedObjectType;
    }

    public AlarmRefOrValue clearSystemId(String clearSystemId) {
        this.clearSystemId = clearSystemId;
        return this;
    }

    @Schema(description="Provides the id of the system where the user who invoked the alarmCleared operation is located. ")
    public String getClearSystemId() {
        return this.clearSystemId;
    }

    public void setClearSystemId(String clearSystemId) {
        this.clearSystemId = clearSystemId;
    }

    public AlarmRefOrValue clearUserId(String clearUserId) {
        this.clearUserId = clearUserId;
        return this;
    }

    @Schema(description="Provides the id of the user who invoked the alarmCleared operation")
    public String getClearUserId() {
        return this.clearUserId;
    }

    public void setClearUserId(String clearUserId) {
        this.clearUserId = clearUserId;
    }

    public AlarmRefOrValue externalAlarmId(String externalAlarmId) {
        this.externalAlarmId = externalAlarmId;
        return this;
    }

    @Schema(description="An identifier of the alarm in the source system.")
    public String getExternalAlarmId() {
        return this.externalAlarmId;
    }

    public void setExternalAlarmId(String externalAlarmId) {
        this.externalAlarmId = externalAlarmId;
    }

    public AlarmRefOrValue isRootCause(Boolean isRootCause) {
        this.isRootCause = isRootCause;
        return this;
    }

    @Schema(description="Indicates whether the alarm is a root cause alarm.. ")
    public Boolean isIsRootCause() {
        return this.isRootCause;
    }

    public void setIsRootCause(Boolean isRootCause) {
        this.isRootCause = isRootCause;
    }

    public AlarmRefOrValue perceivedSeverity(String perceivedSeverity) {
        this.perceivedSeverity = perceivedSeverity;
        return this;
    }

    @Schema(description="Lists the possible severities that can be allocated to an Alarm. The values are consistent with ITU-T Recommendation X.733. Once an alarm has been cleared, its perceived severity is set to 'cleared' and can no longer be set.")
    public String getPerceivedSeverity() {
        return this.perceivedSeverity;
    }

    public void setPerceivedSeverity(String perceivedSeverity) {
        this.perceivedSeverity = perceivedSeverity;
    }

    public AlarmRefOrValue plannedOutageIndicator(String plannedOutageIndicator) {
        this.plannedOutageIndicator = plannedOutageIndicator;
        return this;
    }

    @Schema(description="Indicates that the Managed Object (related to this alarm) is in planned outage (in planned maintenance, or out-of-service). ")
    public String getPlannedOutageIndicator() {
        return this.plannedOutageIndicator;
    }

    public void setPlannedOutageIndicator(String plannedOutageIndicator) {
        this.plannedOutageIndicator = plannedOutageIndicator;
    }

    public AlarmRefOrValue probableCause(String probableCause) {
        this.probableCause = probableCause;
        return this;
    }

    @Schema(description="Provides the probable cause of the alarm. The values are consistent with ITU-T Recommendation X.733 or 3GPP TS 32.111-2 Annex B.")
    public String getProbableCause() {
        return this.probableCause;
    }

    public void setProbableCause(String probableCause) {
        this.probableCause = probableCause;
    }

    public AlarmRefOrValue proposedRepairedActions(String proposedRepairedActions) {
        this.proposedRepairedActions = proposedRepairedActions;
        return this;
    }

    @Schema(description="Indicates proposed repair actions, if known to the system emitting the alarm.")
    public String getProposedRepairedActions() {
        return this.proposedRepairedActions;
    }

    public void setProposedRepairedActions(String proposedRepairedActions) {
        this.proposedRepairedActions = proposedRepairedActions;
    }

    public AlarmRefOrValue reportingSystemId(String reportingSystemId) {
        this.reportingSystemId = reportingSystemId;
        return this;
    }

    @Schema(description="Reporting system identity.")
    public String getReportingSystemId() {
        return this.reportingSystemId;
    }

    public void setReportingSystemId(String reportingSystemId) {
        this.reportingSystemId = reportingSystemId;
    }

    public AlarmRefOrValue serviceAffecting(Boolean serviceAffecting) {
        this.serviceAffecting = serviceAffecting;
        return this;
    }

    @Schema(description="Indicates whether the alarm affects service or not.")
    public Boolean isServiceAffecting() {
        return this.serviceAffecting;
    }

    public void setServiceAffecting(Boolean serviceAffecting) {
        this.serviceAffecting = serviceAffecting;
    }

    public AlarmRefOrValue sourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
        return this;
    }

    @Schema(description="Source system identity.")
    public String getSourceSystemId() {
        return this.sourceSystemId;
    }

    public void setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
    }

    public AlarmRefOrValue specificProblem(String specificProblem) {
        this.specificProblem = specificProblem;
        return this;
    }

    @Schema(description="Provides more specific information about the alarm.")
    public String getSpecificProblem() {
        return this.specificProblem;
    }

    public void setSpecificProblem(String specificProblem) {
        this.specificProblem = specificProblem;
    }

    public AlarmRefOrValue state(String state) {
        this.state = state;
        return this;
    }

    @Schema(description="Defines the alarm state during its life cycle")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public AlarmRefOrValue affectedService(Set<AffectedService> affectedService) {
        this.affectedService = affectedService;
        return this;
    }

    public AlarmRefOrValue addAffectedServiceItem(AffectedService affectedServiceItem) {
        if (this.affectedService == null) {
            this.affectedService = new HashSet<AffectedService>();
        }
        this.affectedService.add(affectedServiceItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<AffectedService> getAffectedService() {
        return this.affectedService;
    }

    public void setAffectedService(Set<AffectedService> affectedService) {
        this.affectedService = affectedService;
    }

    public AlarmRefOrValue alarmedObject(AlarmedObject alarmedObject) {
        this.alarmedObject = alarmedObject;
        return this;
    }

    @Schema(description="")
    @Valid
    public AlarmedObject getAlarmedObject() {
        return this.alarmedObject;
    }

    public void setAlarmedObject(AlarmedObject alarmedObject) {
        this.alarmedObject = alarmedObject;
    }

    public AlarmRefOrValue comment(Set<Comment> comment) {
        this.comment = comment;
        return this;
    }

    public AlarmRefOrValue addCommentItem(Comment commentItem) {
        if (this.comment == null) {
            this.comment = new HashSet<Comment>();
        }
        this.comment.add(commentItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<Comment> getComment() {
        return this.comment;
    }

    public void setComment(Set<Comment> comment) {
        this.comment = comment;
    }

    public AlarmRefOrValue correlatedAlarm(Set<AlarmRef> correlatedAlarm) {
        this.correlatedAlarm = correlatedAlarm;
        return this;
    }

    public AlarmRefOrValue addCorrelatedAlarmItem(AlarmRef correlatedAlarmItem) {
        if (this.correlatedAlarm == null) {
            this.correlatedAlarm = new HashSet<AlarmRef>();
        }
        this.correlatedAlarm.add(correlatedAlarmItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<AlarmRef> getCorrelatedAlarm() {
        return this.correlatedAlarm;
    }

    public void setCorrelatedAlarm(Set<AlarmRef> correlatedAlarm) {
        this.correlatedAlarm = correlatedAlarm;
    }

    public AlarmRefOrValue crossedThresholdInformation(CrossedThresholdInformation crossedThresholdInformation) {
        this.crossedThresholdInformation = crossedThresholdInformation;
        return this;
    }

    @Schema(description="")
    @Valid
    public CrossedThresholdInformation getCrossedThresholdInformation() {
        return this.crossedThresholdInformation;
    }

    public void setCrossedThresholdInformation(CrossedThresholdInformation crossedThresholdInformation) {
        this.crossedThresholdInformation = crossedThresholdInformation;
    }

    public AlarmRefOrValue parentAlarm(Set<AlarmRef> parentAlarm) {
        this.parentAlarm = parentAlarm;
        return this;
    }

    public AlarmRefOrValue addParentAlarmItem(AlarmRef parentAlarmItem) {
        if (this.parentAlarm == null) {
            this.parentAlarm = new HashSet<AlarmRef>();
        }
        this.parentAlarm.add(parentAlarmItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<AlarmRef> getParentAlarm() {
        return this.parentAlarm;
    }

    public void setParentAlarm(Set<AlarmRef> parentAlarm) {
        this.parentAlarm = parentAlarm;
    }

    public AlarmRefOrValue place(Set<RelatedPlaceRefOrValue> place) {
        this.place = place;
        return this;
    }

    public AlarmRefOrValue addPlaceItem(RelatedPlaceRefOrValue placeItem) {
        if (this.place == null) {
            this.place = new HashSet<RelatedPlaceRefOrValue>();
        }
        this.place.add(placeItem);
        return this;
    }

    @Schema(description="")
    @Valid
    public Set<RelatedPlaceRefOrValue> getPlace() {
        return this.place;
    }

    public void setPlace(Set<RelatedPlaceRefOrValue> place) {
        this.place = place;
    }

    public AlarmRefOrValue _atReferredType(String _atReferredType) {
        this._atReferredType = _atReferredType;
        return this;
    }

    @Schema(description="The actual type of the target instance when needed for disambiguation.")
    public String getAtReferredType() {
        return this._atReferredType;
    }

    public void setAtReferredType(String _atReferredType) {
        this._atReferredType = _atReferredType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlarmRefOrValue alarmRefOrValue = (AlarmRefOrValue)o;
        return Objects.equals(this.id, alarmRefOrValue.id) && Objects.equals(this.href, alarmRefOrValue.href) && Objects.equals(this.ackState, alarmRefOrValue.ackState) && Objects.equals(this.ackSystemId, alarmRefOrValue.ackSystemId) && Objects.equals(this.ackUserId, alarmRefOrValue.ackUserId) && Objects.equals(this.alarmChangedTime, alarmRefOrValue.alarmChangedTime) && Objects.equals(this.alarmClearedTime, alarmRefOrValue.alarmClearedTime) && Objects.equals(this.alarmDetails, alarmRefOrValue.alarmDetails) && Objects.equals(this.alarmEscalation, alarmRefOrValue.alarmEscalation) && Objects.equals(this.alarmRaisedTime, alarmRefOrValue.alarmRaisedTime) && Objects.equals(this.alarmReportingTime, alarmRefOrValue.alarmReportingTime) && Objects.equals(this.alarmType, alarmRefOrValue.alarmType) && Objects.equals(this.alarmedObjectType, alarmRefOrValue.alarmedObjectType) && Objects.equals(this.clearSystemId, alarmRefOrValue.clearSystemId) && Objects.equals(this.clearUserId, alarmRefOrValue.clearUserId) && Objects.equals(this.externalAlarmId, alarmRefOrValue.externalAlarmId) && Objects.equals(this.isRootCause, alarmRefOrValue.isRootCause) && Objects.equals(this.name, alarmRefOrValue.name) && Objects.equals(this.perceivedSeverity, alarmRefOrValue.perceivedSeverity) && Objects.equals(this.plannedOutageIndicator, alarmRefOrValue.plannedOutageIndicator) && Objects.equals(this.probableCause, alarmRefOrValue.probableCause) && Objects.equals(this.proposedRepairedActions, alarmRefOrValue.proposedRepairedActions) && Objects.equals(this.reportingSystemId, alarmRefOrValue.reportingSystemId) && Objects.equals(this.serviceAffecting, alarmRefOrValue.serviceAffecting) && Objects.equals(this.sourceSystemId, alarmRefOrValue.sourceSystemId) && Objects.equals(this.specificProblem, alarmRefOrValue.specificProblem) && Objects.equals(this.state, alarmRefOrValue.state) && Objects.equals(this.affectedService, alarmRefOrValue.affectedService) && Objects.equals(this.alarmedObject, alarmRefOrValue.alarmedObject) && Objects.equals(this.comment, alarmRefOrValue.comment) && Objects.equals(this.correlatedAlarm, alarmRefOrValue.correlatedAlarm) && Objects.equals(this.crossedThresholdInformation, alarmRefOrValue.crossedThresholdInformation) && Objects.equals(this.parentAlarm, alarmRefOrValue.parentAlarm) && Objects.equals(this.place, alarmRefOrValue.place) && Objects.equals(this.baseType, alarmRefOrValue.baseType) && Objects.equals(this.schemaLocation, alarmRefOrValue.schemaLocation) && Objects.equals(this.type, alarmRefOrValue.type) && Objects.equals(this._atReferredType, alarmRefOrValue._atReferredType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.href, this.ackState, this.ackSystemId, this.ackUserId, this.alarmChangedTime, this.alarmClearedTime, this.alarmDetails, this.alarmEscalation, this.alarmRaisedTime, this.alarmReportingTime, this.alarmType, this.alarmedObjectType, this.clearSystemId, this.clearUserId, this.externalAlarmId, this.isRootCause, this.name, this.perceivedSeverity, this.plannedOutageIndicator, this.probableCause, this.proposedRepairedActions, this.reportingSystemId, this.serviceAffecting, this.sourceSystemId, this.specificProblem, this.state, this.affectedService, this.alarmedObject, this.comment, this.correlatedAlarm, this.crossedThresholdInformation, this.parentAlarm, this.place, this.baseType, this.schemaLocation, this.type, this._atReferredType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AlarmRefOrValue {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    ackState: ").append(this.toIndentedString(this.ackState)).append("\n");
        sb.append("    ackSystemId: ").append(this.toIndentedString(this.ackSystemId)).append("\n");
        sb.append("    ackUserId: ").append(this.toIndentedString(this.ackUserId)).append("\n");
        sb.append("    alarmChangedTime: ").append(this.toIndentedString(this.alarmChangedTime)).append("\n");
        sb.append("    alarmClearedTime: ").append(this.toIndentedString(this.alarmClearedTime)).append("\n");
        sb.append("    alarmDetails: ").append(this.toIndentedString(this.alarmDetails)).append("\n");
        sb.append("    alarmEscalation: ").append(this.toIndentedString(this.alarmEscalation)).append("\n");
        sb.append("    alarmRaisedTime: ").append(this.toIndentedString(this.alarmRaisedTime)).append("\n");
        sb.append("    alarmReportingTime: ").append(this.toIndentedString(this.alarmReportingTime)).append("\n");
        sb.append("    alarmType: ").append(this.toIndentedString(this.alarmType)).append("\n");
        sb.append("    alarmedObjectType: ").append(this.toIndentedString(this.alarmedObjectType)).append("\n");
        sb.append("    clearSystemId: ").append(this.toIndentedString(this.clearSystemId)).append("\n");
        sb.append("    clearUserId: ").append(this.toIndentedString(this.clearUserId)).append("\n");
        sb.append("    externalAlarmId: ").append(this.toIndentedString(this.externalAlarmId)).append("\n");
        sb.append("    isRootCause: ").append(this.toIndentedString(this.isRootCause)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    perceivedSeverity: ").append(this.toIndentedString(this.perceivedSeverity)).append("\n");
        sb.append("    plannedOutageIndicator: ").append(this.toIndentedString(this.plannedOutageIndicator)).append("\n");
        sb.append("    probableCause: ").append(this.toIndentedString(this.probableCause)).append("\n");
        sb.append("    proposedRepairedActions: ").append(this.toIndentedString(this.proposedRepairedActions)).append("\n");
        sb.append("    reportingSystemId: ").append(this.toIndentedString(this.reportingSystemId)).append("\n");
        sb.append("    serviceAffecting: ").append(this.toIndentedString(this.serviceAffecting)).append("\n");
        sb.append("    sourceSystemId: ").append(this.toIndentedString(this.sourceSystemId)).append("\n");
        sb.append("    specificProblem: ").append(this.toIndentedString(this.specificProblem)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    affectedService: ").append(this.toIndentedString(this.affectedService)).append("\n");
        sb.append("    alarmedObject: ").append(this.toIndentedString(this.alarmedObject)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    correlatedAlarm: ").append(this.toIndentedString(this.correlatedAlarm)).append("\n");
        sb.append("    crossedThresholdInformation: ").append(this.toIndentedString(this.crossedThresholdInformation)).append("\n");
        sb.append("    parentAlarm: ").append(this.toIndentedString(this.parentAlarm)).append("\n");
        sb.append("    place: ").append(this.toIndentedString(this.place)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    _atReferredType: ").append(this.toIndentedString(this._atReferredType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

