/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.am642.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.etsi.osl.tmf.am642.model.AlarmUpdate;
import org.springframework.validation.annotation.Validated;

@Schema(description="This resource represents an alarm supporting the information model defined in ITU-T X.733. Skipped properties: id,href")
@Validated
public class AlarmCreate
extends AlarmUpdate {
    private OffsetDateTime alarmRaisedTime = null;
    @JsonProperty(value="sourceSystemId")
    private String sourceSystemId = null;

    @Schema(description="Indicates the time (as a date + time) at which the alarm occurred at its source.")
    @NotNull
    @Valid
    public OffsetDateTime getAlarmRaisedTime() {
        return this.alarmRaisedTime;
    }

    public void setAlarmRaisedTime(OffsetDateTime alarmRaisedTime) {
        this.alarmRaisedTime = alarmRaisedTime;
    }

    @JsonProperty(value="alarmRaisedTime")
    public String getAlarmRaisedTimeStr() {
        if (this.alarmRaisedTime != null) {
            return this.alarmRaisedTime.toString();
        }
        return null;
    }

    public void setAlarmRaisedTime(String aalarmRaisedTime) {
        if (aalarmRaisedTime != null) {
            this.alarmRaisedTime = OffsetDateTime.parse(aalarmRaisedTime);
        }
    }

    public AlarmCreate sourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
        return this;
    }

    @Schema(description="Source system identity.")
    @NotNull
    public String getSourceSystemId() {
        return this.sourceSystemId;
    }

    public void setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlarmCreate alarmCreate = (AlarmCreate)o;
        return Objects.equals(this.ackState, alarmCreate.ackState) && Objects.equals(this.ackSystemId, alarmCreate.ackSystemId) && Objects.equals(this.ackUserId, alarmCreate.ackUserId) && Objects.equals(this.alarmChangedTime, alarmCreate.alarmChangedTime) && Objects.equals(this.alarmClearedTime, alarmCreate.alarmClearedTime) && Objects.equals(this.alarmDetails, alarmCreate.alarmDetails) && Objects.equals(this.alarmEscalation, alarmCreate.alarmEscalation) && Objects.equals(this.alarmRaisedTime, alarmCreate.alarmRaisedTime) && Objects.equals(this.alarmReportingTime, alarmCreate.alarmReportingTime) && Objects.equals(this.alarmType, alarmCreate.alarmType) && Objects.equals(this.alarmedObjectType, alarmCreate.alarmedObjectType) && Objects.equals(this.clearSystemId, alarmCreate.clearSystemId) && Objects.equals(this.clearUserId, alarmCreate.clearUserId) && Objects.equals(this.externalAlarmId, alarmCreate.externalAlarmId) && Objects.equals(this.isRootCause, alarmCreate.isRootCause) && Objects.equals(this.perceivedSeverity, alarmCreate.perceivedSeverity) && Objects.equals(this.plannedOutageIndicator, alarmCreate.plannedOutageIndicator) && Objects.equals(this.probableCause, alarmCreate.probableCause) && Objects.equals(this.proposedRepairedActions, alarmCreate.proposedRepairedActions) && Objects.equals(this.reportingSystemId, alarmCreate.reportingSystemId) && Objects.equals(this.serviceAffecting, alarmCreate.serviceAffecting) && Objects.equals(this.sourceSystemId, alarmCreate.sourceSystemId) && Objects.equals(this.specificProblem, alarmCreate.specificProblem) && Objects.equals(this.state, alarmCreate.state) && Objects.equals(this.affectedService, alarmCreate.affectedService) && Objects.equals(this.alarmedObject, alarmCreate.alarmedObject) && Objects.equals(this.comment, alarmCreate.comment) && Objects.equals(this.correlatedAlarm, alarmCreate.correlatedAlarm) && Objects.equals(this.crossedThresholdInformation, alarmCreate.crossedThresholdInformation) && Objects.equals(this.parentAlarm, alarmCreate.parentAlarm) && Objects.equals(this.place, alarmCreate.place) && Objects.equals(this.baseType, alarmCreate.baseType) && Objects.equals(this.schemaLocation, alarmCreate.schemaLocation) && Objects.equals(this.type, alarmCreate.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.ackState, this.ackSystemId, this.ackUserId, this.alarmChangedTime, this.alarmClearedTime, this.alarmDetails, this.alarmEscalation, this.alarmRaisedTime, this.alarmReportingTime, this.alarmType, this.alarmedObjectType, this.clearSystemId, this.clearUserId, this.externalAlarmId, this.isRootCause, this.perceivedSeverity, this.plannedOutageIndicator, this.probableCause, this.proposedRepairedActions, this.reportingSystemId, this.serviceAffecting, this.sourceSystemId, this.specificProblem, this.state, this.affectedService, this.alarmedObject, this.comment, this.correlatedAlarm, this.crossedThresholdInformation, this.parentAlarm, this.place, this.baseType, this.schemaLocation, this.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AlarmCreate {\n");
        sb.append("    ackState: ").append(this.toIndentedString(this.ackState)).append("\n");
        sb.append("    ackSystemId: ").append(this.toIndentedString(this.ackSystemId)).append("\n");
        sb.append("    ackUserId: ").append(this.toIndentedString(this.ackUserId)).append("\n");
        sb.append("    alarmChangedTime: ").append(this.toIndentedString(this.alarmChangedTime)).append("\n");
        sb.append("    alarmClearedTime: ").append(this.toIndentedString(this.alarmClearedTime)).append("\n");
        sb.append("    alarmDetails: ").append(this.toIndentedString(this.alarmDetails)).append("\n");
        sb.append("    alarmEscalation: ").append(this.toIndentedString(this.alarmEscalation)).append("\n");
        sb.append("    alarmRaisedTime: ").append(this.toIndentedString(this.alarmRaisedTime)).append("\n");
        sb.append("    alarmReportingTime: ").append(this.toIndentedString(this.alarmReportingTime)).append("\n");
        sb.append("    alarmType: ").append(this.toIndentedString(this.alarmType)).append("\n");
        sb.append("    alarmedObjectType: ").append(this.toIndentedString(this.alarmedObjectType)).append("\n");
        sb.append("    clearSystemId: ").append(this.toIndentedString(this.clearSystemId)).append("\n");
        sb.append("    clearUserId: ").append(this.toIndentedString(this.clearUserId)).append("\n");
        sb.append("    externalAlarmId: ").append(this.toIndentedString(this.externalAlarmId)).append("\n");
        sb.append("    isRootCause: ").append(this.toIndentedString(this.isRootCause)).append("\n");
        sb.append("    perceivedSeverity: ").append(this.toIndentedString(this.perceivedSeverity)).append("\n");
        sb.append("    plannedOutageIndicator: ").append(this.toIndentedString(this.plannedOutageIndicator)).append("\n");
        sb.append("    probableCause: ").append(this.toIndentedString(this.probableCause)).append("\n");
        sb.append("    proposedRepairedActions: ").append(this.toIndentedString(this.proposedRepairedActions)).append("\n");
        sb.append("    reportingSystemId: ").append(this.toIndentedString(this.reportingSystemId)).append("\n");
        sb.append("    serviceAffecting: ").append(this.toIndentedString(this.serviceAffecting)).append("\n");
        sb.append("    sourceSystemId: ").append(this.toIndentedString(this.sourceSystemId)).append("\n");
        sb.append("    specificProblem: ").append(this.toIndentedString(this.specificProblem)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    affectedService: ").append(this.toIndentedString(this.affectedService)).append("\n");
        sb.append("    alarmedObject: ").append(this.toIndentedString(this.alarmedObject)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    correlatedAlarm: ").append(this.toIndentedString(this.correlatedAlarm)).append("\n");
        sb.append("    crossedThresholdInformation: ").append(this.toIndentedString(this.crossedThresholdInformation)).append("\n");
        sb.append("    parentAlarm: ").append(this.toIndentedString(this.parentAlarm)).append("\n");
        sb.append("    place: ").append(this.toIndentedString(this.place)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

