/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.am642.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.am642.model.Alarm;
import org.etsi.osl.tmf.am642.model.AlarmRefOrValue;
import org.springframework.validation.annotation.Validated;

@Schema(description="Task resource for the acknowledge alarms operation Skipped properties: id,href")
@Validated
public class AckAlarmsCreate {
    @JsonProperty(value="ackSystemId")
    private String ackSystemId = null;
    @JsonProperty(value="ackTime")
    private OffsetDateTime ackTime = null;
    @JsonProperty(value="ackUserId")
    private String ackUserId = null;
    @JsonProperty(value="state")
    private String state = null;
    @JsonProperty(value="ackedAlarm")
    @Valid
    private List<AlarmRefOrValue> ackedAlarm = null;
    @JsonProperty(value="alarmPattern")
    @Valid
    private List<Alarm> alarmPattern = new ArrayList<Alarm>();
    @JsonProperty(value="@baseType")
    private String baseType = null;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@type")
    private String type = null;

    public AckAlarmsCreate ackSystemId(String ackSystemId) {
        this.ackSystemId = ackSystemId;
        return this;
    }

    @Schema(description="Name of the acknowledging system")
    @NotNull
    public String getAckSystemId() {
        return this.ackSystemId;
    }

    public void setAckSystemId(String ackSystemId) {
        this.ackSystemId = ackSystemId;
    }

    public AckAlarmsCreate ackTime(OffsetDateTime ackTime) {
        this.ackTime = ackTime;
        return this;
    }

    @Schema(description="Time of the acknowledgement")
    @Valid
    public OffsetDateTime getAckTime() {
        return this.ackTime;
    }

    public void setAckTime(OffsetDateTime ackTime) {
        this.ackTime = ackTime;
    }

    public AckAlarmsCreate ackUserId(String ackUserId) {
        this.ackUserId = ackUserId;
        return this;
    }

    @Schema(description="Name of the acknowledging user")
    @NotNull
    public String getAckUserId() {
        return this.ackUserId;
    }

    public void setAckUserId(String ackUserId) {
        this.ackUserId = ackUserId;
    }

    public AckAlarmsCreate state(String state) {
        this.state = state;
        return this;
    }

    @Schema(description="Current state of the operation task")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public AckAlarmsCreate ackedAlarm(List<AlarmRefOrValue> ackedAlarm) {
        this.ackedAlarm = ackedAlarm;
        return this;
    }

    public AckAlarmsCreate addAckedAlarmItem(AlarmRefOrValue ackedAlarmItem) {
        if (this.ackedAlarm == null) {
            this.ackedAlarm = new ArrayList<AlarmRefOrValue>();
        }
        this.ackedAlarm.add(ackedAlarmItem);
        return this;
    }

    @Schema(description="The successfully acknowledged alarms")
    @Valid
    public List<AlarmRefOrValue> getAckedAlarm() {
        return this.ackedAlarm;
    }

    public void setAckedAlarm(List<AlarmRefOrValue> ackedAlarm) {
        this.ackedAlarm = ackedAlarm;
    }

    public AckAlarmsCreate alarmPattern(List<Alarm> alarmPattern) {
        this.alarmPattern = alarmPattern;
        return this;
    }

    public AckAlarmsCreate addAlarmPatternItem(Alarm alarmPatternItem) {
        this.alarmPattern.add(alarmPatternItem);
        return this;
    }

    @Schema(description="Alarm patterns to match target alarms. An alarm will match if all of the sttributes in any of the patterns compare equal to those attributes of the alarm.")
    @NotNull
    @Valid
    @Size(min=1)
    public @NotNull @Valid @Size(min=1) List<Alarm> getAlarmPattern() {
        return this.alarmPattern;
    }

    public void setAlarmPattern(List<Alarm> alarmPattern) {
        this.alarmPattern = alarmPattern;
    }

    public AckAlarmsCreate baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getAtBaseType() {
        return this.baseType;
    }

    public void setAtBaseType(String baseType) {
        this.baseType = baseType;
    }

    public AckAlarmsCreate schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this.schemaLocation;
    }

    public void setAtSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public AckAlarmsCreate type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class entity name")
    public String getAtType() {
        return this.type;
    }

    public void setAtType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AckAlarmsCreate ackAlarmsCreate = (AckAlarmsCreate)o;
        return Objects.equals(this.ackSystemId, ackAlarmsCreate.ackSystemId) && Objects.equals(this.ackTime, ackAlarmsCreate.ackTime) && Objects.equals(this.ackUserId, ackAlarmsCreate.ackUserId) && Objects.equals(this.state, ackAlarmsCreate.state) && Objects.equals(this.ackedAlarm, ackAlarmsCreate.ackedAlarm) && Objects.equals(this.alarmPattern, ackAlarmsCreate.alarmPattern) && Objects.equals(this.baseType, ackAlarmsCreate.baseType) && Objects.equals(this.schemaLocation, ackAlarmsCreate.schemaLocation) && Objects.equals(this.type, ackAlarmsCreate.type);
    }

    public int hashCode() {
        return Objects.hash(this.ackSystemId, this.ackTime, this.ackUserId, this.state, this.ackedAlarm, this.alarmPattern, this.baseType, this.schemaLocation, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AckAlarmsCreate {\n");
        sb.append("    ackSystemId: ").append(this.toIndentedString(this.ackSystemId)).append("\n");
        sb.append("    ackTime: ").append(this.toIndentedString(this.ackTime)).append("\n");
        sb.append("    ackUserId: ").append(this.toIndentedString(this.ackUserId)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    ackedAlarm: ").append(this.toIndentedString(this.ackedAlarm)).append("\n");
        sb.append("    alarmPattern: ").append(this.toIndentedString(this.alarmPattern)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

