/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.am642.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.am642.model.Alarm;
import org.etsi.osl.tmf.am642.model.AlarmRefOrValue;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.springframework.validation.annotation.Validated;

@Schema(description="Task resource for the acknowledge alarms operation")
@Validated
@Entity(name="AMAckAlarms")
@Table(name="AMAckAlarms")
public class AckAlarms
extends BaseRootEntity {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="href")
    private String href = null;
    @JsonProperty(value="ackSystemId")
    private String ackSystemId = null;
    private OffsetDateTime ackTime = null;
    @JsonProperty(value="ackUserId")
    private String ackUserId = null;
    @JsonProperty(value="state")
    private String state = null;
    @JsonProperty(value="ackedAlarm")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<AlarmRefOrValue> ackedAlarm = new HashSet<AlarmRefOrValue>();
    @JsonProperty(value="alarmPattern")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<Alarm> alarmPattern = new HashSet<Alarm>();

    public String getId() {
        if (this.uuid != null) {
            this.id = this.uuid;
        }
        return this.id;
    }

    public AckAlarms ackSystemId(String ackSystemId) {
        this.ackSystemId = ackSystemId;
        return this;
    }

    @Schema(description="Name of the acknowledging system")
    public String getAckSystemId() {
        return this.ackSystemId;
    }

    public void setAckSystemId(String ackSystemId) {
        this.ackSystemId = ackSystemId;
    }

    public AckAlarms ackTime(OffsetDateTime ackTime) {
        this.ackTime = ackTime;
        return this;
    }

    @Schema(description="Time of the acknowledgement")
    @Valid
    public OffsetDateTime getAckTime() {
        return this.ackTime;
    }

    public void setAckTime(OffsetDateTime ackTime) {
        this.ackTime = ackTime;
    }

    @JsonProperty(value="ackTime")
    public String getAckTimeStr() {
        if (this.ackTime != null) {
            return this.ackTime.toString();
        }
        return null;
    }

    public AckAlarms ackUserId(String ackUserId) {
        this.ackUserId = ackUserId;
        return this;
    }

    @Schema(description="Name of the acknowledging user")
    public String getAckUserId() {
        return this.ackUserId;
    }

    public void setAckUserId(String ackUserId) {
        this.ackUserId = ackUserId;
    }

    public AckAlarms state(String state) {
        this.state = state;
        return this;
    }

    @Schema(description="Current state of the operation task")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public AckAlarms ackedAlarm(Set<AlarmRefOrValue> ackedAlarm) {
        this.ackedAlarm = ackedAlarm;
        return this;
    }

    public AckAlarms addAckedAlarmItem(AlarmRefOrValue ackedAlarmItem) {
        if (this.ackedAlarm == null) {
            this.ackedAlarm = new HashSet<AlarmRefOrValue>();
        }
        this.ackedAlarm.add(ackedAlarmItem);
        return this;
    }

    @Schema(description="The successfully acknowledged alarms")
    @Valid
    public Set<AlarmRefOrValue> getAckedAlarm() {
        return this.ackedAlarm;
    }

    public void setAckedAlarm(Set<AlarmRefOrValue> ackedAlarm) {
        this.ackedAlarm = ackedAlarm;
    }

    public AckAlarms alarmPattern(Set<Alarm> alarmPattern) {
        this.alarmPattern = alarmPattern;
        return this;
    }

    public AckAlarms addAlarmPatternItem(Alarm alarmPatternItem) {
        if (this.alarmPattern == null) {
            this.alarmPattern = new HashSet<Alarm>();
        }
        this.alarmPattern.add(alarmPatternItem);
        return this;
    }

    @Schema(description="Alarm patterns to match target alarms. An alarm will match if all of the sttributes in any of the patterns compare equal to those attributes of the alarm.")
    @Valid
    public Set<Alarm> getAlarmPattern() {
        return this.alarmPattern;
    }

    public void setAlarmPattern(Set<Alarm> alarmPattern) {
        this.alarmPattern = alarmPattern;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AckAlarms ackAlarms = (AckAlarms)o;
        return Objects.equals(this.id, ackAlarms.id) && Objects.equals(this.href, ackAlarms.href) && Objects.equals(this.ackSystemId, ackAlarms.ackSystemId) && Objects.equals(this.ackTime, ackAlarms.ackTime) && Objects.equals(this.ackUserId, ackAlarms.ackUserId) && Objects.equals(this.state, ackAlarms.state) && Objects.equals(this.ackedAlarm, ackAlarms.ackedAlarm) && Objects.equals(this.alarmPattern, ackAlarms.alarmPattern) && Objects.equals(this.baseType, ackAlarms.baseType) && Objects.equals(this.schemaLocation, ackAlarms.schemaLocation) && Objects.equals(this.type, ackAlarms.type);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.href, this.ackSystemId, this.ackTime, this.ackUserId, this.state, this.ackedAlarm, this.alarmPattern, this.baseType, this.schemaLocation, this.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AckAlarms {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    ackSystemId: ").append(this.toIndentedString(this.ackSystemId)).append("\n");
        sb.append("    ackTime: ").append(this.toIndentedString(this.ackTime)).append("\n");
        sb.append("    ackUserId: ").append(this.toIndentedString(this.ackUserId)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    ackedAlarm: ").append(this.toIndentedString(this.ackedAlarm)).append("\n");
        sb.append("    alarmPattern: ").append(this.toIndentedString(this.alarmPattern)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

