package org.etsi.osl.tmf.gsm674.model;


import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import org.etsi.osl.tmf.common.model.BaseRootEntity;

/**
 * PlaceRefOrValue
 */

@JsonIgnoreProperties(
        value = "@type", // ignore manually set @type, it will be automatically generated by Jackson during serialization
        allowSetters = true // allows the @type to be set during deserialization
)
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "@type", visible = true)
@JsonSubTypes({
        @JsonSubTypes.Type(value = GeographicAddressValue.class, name = "GeographicAddressValue"),
        @JsonSubTypes.Type(value = PlaceRef.class, name = "PlaceRef"),
        @JsonSubTypes.Type(value = PlaceRefOrValue.class, name = "PlaceRefOrValue")
})

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-04-24T14:24:54.867613034Z[Etc/UTC]", comments = "Generator version: 7.6.0-SNAPSHOT")
public class PlaceRefOrValue extends BaseRootEntity {

    public PlaceRefOrValue() {
        super();
    }

    /**
     * Constructor with only required parameters
     */
    public PlaceRefOrValue(String atType) {
        this.type = atType;
    }

    public PlaceRefOrValue atType(String atType) {
        this.type = atType;
        return this;
    }

    /**
     * When sub-classing, this defines the sub-class Extensible name
     * @return atType
     */
    @NotNull
    @Schema(name = "@type", description = "When sub-classing, this defines the sub-class Extensible name", requiredMode = Schema.RequiredMode.REQUIRED)
    @JsonProperty("@type")
    public String getAtType() {
        return type;
    }

    public void setAtType(String atType) {
        this.type = atType;
    }

    public PlaceRefOrValue atBaseType(String atBaseType) {
        this.baseType = atBaseType;
        return this;
    }

    /**
     * When sub-classing, this defines the super-class
     * @return atBaseType
     */

    @Schema(name = "@baseType", description = "When sub-classing, this defines the super-class", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty("@baseType")
    public String getAtBaseType() {
        return baseType;
    }

    public void setAtBaseType(String atBaseType) {
        this.baseType = atBaseType;
    }

    public PlaceRefOrValue atSchemaLocation(String atSchemaLocation) {
        this.schemaLocation = atSchemaLocation;
        return this;
    }

    /**
     * A URI to a JSON-Schema file that defines additional attributes and relationships
     * @return atSchemaLocation
     */

    @Schema(name = "@schemaLocation", description = "A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty("@schemaLocation")
    public String getAtSchemaLocation() {
        return schemaLocation;
    }

    public void setAtSchemaLocation(String atSchemaLocation) {
        this.schemaLocation = atSchemaLocation;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PlaceRefOrValue placeRefOrValue = (PlaceRefOrValue) o;
        return Objects.equals(this.type, placeRefOrValue.type) &&
                Objects.equals(this.baseType, placeRefOrValue.baseType) &&
                Objects.equals(this.schemaLocation, placeRefOrValue.schemaLocation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(type, baseType, schemaLocation);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PlaceRefOrValue {\n");
        sb.append("    @type: ").append(toIndentedString(type)).append("\n");
        sb.append("    @baseType: ").append(toIndentedString(baseType)).append("\n");
        sb.append("    @schemaLocation: ").append(toIndentedString(schemaLocation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

