package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.*;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import lombok.Getter;
import lombok.Setter;

import javax.annotation.Generated;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * ManagementJobMVO
 */

@JsonIgnoreProperties(
   ignoreUnknown = true,
  value = "@type", // ignore manually set @type, it will be automatically generated by Jackson during serialization
  allowSetters = true // allows the @type to be set during deserialization
)
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "@type", visible = true)
@JsonSubTypes({
  @JsonSubTypes.Type(value = ManagementJobMVO.class, name = "ManagementJob"),
  @JsonSubTypes.Type(value = MeasurementCollectionJobMVO.class, name = "MeasurementCollectionJob"),
  @JsonSubTypes.Type(value = MeasurementJobMVO.class, name = "MeasurementJob")
})

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-05-15T07:30:16.936523289Z[Etc/UTC]", comments = "Generator version: 7.6.0-SNAPSHOT")
public class ManagementJobMVO {

  @JsonProperty("@type")
  private String type;

  @JsonProperty("@baseType")
  private String baseType;

  @JsonProperty("@schemaLocation")
  private String schemaLocation;

  @JsonProperty("href")
  private String href;

  @JsonProperty("uuid")
  private String uuid;

  @JsonProperty("fileTransferData")
  @Valid
  private List<FileTransferDataMVO> fileTransferData = null;

  @JsonProperty("dataAccessEndpoint")
  @Valid
  private List<DataAccessEndpointMVO> dataAccessEndpoint = null;

  @JsonProperty("scheduleDefinition")
  @Valid
  private List<ScheduleDefinitionMVO> scheduleDefinition = null;

  // Property bellow was added by UoP and is not officialy part of TMF628 Model
  // @JsonProperty("executionState")
  @Setter
  @Getter
  @JsonProperty("executionState")
  private ExecutionStateType executionState;

  public ManagementJobMVO() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public ManagementJobMVO(String type) {
    this.type = type;
  }

  public ManagementJobMVO type(String type) {
    this.type = type;
    return this;
  }

  /**
   * When sub-classing, this defines the sub-class Extensible name
   * @return atType
  */
  @NotNull 
  @Schema(name = "@type", description = "When sub-classing, this defines the sub-class Extensible name", requiredMode = Schema.RequiredMode.REQUIRED)
  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public ManagementJobMVO baseType(String baseType) {
    this.baseType = baseType;
    return this;
  }

  /**
   * When sub-classing, this defines the super-class
   * @return atBaseType
  */
  
  @Schema(name = "@baseType", description = "When sub-classing, this defines the super-class", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public String getBaseType() {
    return baseType;
  }

  public void setBaseType(String baseType) {
    this.baseType = baseType;
  }

  public ManagementJobMVO schemaLocation(String schemaLocation) {
    this.schemaLocation = schemaLocation;
    return this;
  }

  /**
   * A URI to a JSON-Schema file that defines additional attributes and relationships
   * @return atSchemaLocation
  */
  
  @Schema(name = "@schemaLocation", description = "A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public String getSchemaLocation() {
    return schemaLocation;
  }

  public void setSchemaLocation(String schemaLocation) {
    this.schemaLocation = schemaLocation;
  }

  public ManagementJobMVO href(String href) {
    this.href = href;
    return this;
  }

  /**
   * Hyperlink reference
   * @return href
  */
  
  @Schema(name = "href", description = "Hyperlink reference", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public String getHref() {
    return href;
  }

  public void setHref(String href) {
    this.href = href;
  }

  public ManagementJobMVO uuid(String uuid) {
    this.uuid = uuid;
    return this;
  }

  /**
   * unique identifier
   * @return id
  */
  
  @Schema(name = "uuid", description = "unique identifier", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public String getUuid() {
    return uuid;
  }

  public void setUuid(String uuid) {
    this.uuid = uuid;
  }

  public ManagementJobMVO fileTransferData(List<FileTransferDataMVO> fileTransferData) {
    this.fileTransferData = fileTransferData;
    return this;
  }

  public ManagementJobMVO addFileTransferDataItem(FileTransferDataMVO fileTransferDataItem) {
    if (this.fileTransferData == null) {
      this.fileTransferData = new ArrayList<>();
    }
    this.fileTransferData.add(fileTransferDataItem);
    return this;
  }

  /**
   * Get fileTransferData
   * @return fileTransferData
  */
  @Valid @Size(min = 0) 
  @Schema(name = "fileTransferData", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public List<FileTransferDataMVO> getFileTransferData() {
    return fileTransferData;
  }

  public void setFileTransferData(List<FileTransferDataMVO> fileTransferData) {
    this.fileTransferData = fileTransferData;
  }

  public ManagementJobMVO dataAccessEndpoint(List<DataAccessEndpointMVO> dataAccessEndpoint) {
    this.dataAccessEndpoint = dataAccessEndpoint;
    return this;
  }

  public ManagementJobMVO addDataAccessEndpointItem(DataAccessEndpointMVO dataAccessEndpointItem) {
    if (this.dataAccessEndpoint == null) {
      this.dataAccessEndpoint = new ArrayList<>();
    }
    this.dataAccessEndpoint.add(dataAccessEndpointItem);
    return this;
  }

  /**
   * Get dataAccessEndpoint
   * @return dataAccessEndpoint
  */
  @Valid @Size(min = 0) 
  @Schema(name = "dataAccessEndpoint", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public List<DataAccessEndpointMVO> getDataAccessEndpoint() {
    return dataAccessEndpoint;
  }

  public void setDataAccessEndpoint(List<DataAccessEndpointMVO> dataAccessEndpoint) {
    this.dataAccessEndpoint = dataAccessEndpoint;
  }

  public ManagementJobMVO scheduleDefinition(List<ScheduleDefinitionMVO> scheduleDefinition) {
    this.scheduleDefinition = scheduleDefinition;
    return this;
  }

  public ManagementJobMVO addScheduleDefinitionItem(ScheduleDefinitionMVO scheduleDefinitionItem) {
    if (this.scheduleDefinition == null) {
      this.scheduleDefinition = new ArrayList<>();
    }
    this.scheduleDefinition.add(scheduleDefinitionItem);
    return this;
  }

  /**
   * Get scheduleDefinition
   * @return scheduleDefinition
  */
  @Valid @Size(max = 1) 
  @Schema(name = "scheduleDefinition", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public List<ScheduleDefinitionMVO> getScheduleDefinition() {
    return scheduleDefinition;
  }

  public void setScheduleDefinition(List<ScheduleDefinitionMVO> scheduleDefinition) {
    this.scheduleDefinition = scheduleDefinition;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ManagementJobMVO managementJobMVO = (ManagementJobMVO) o;
    return Objects.equals(this.type, managementJobMVO.type) &&
        Objects.equals(this.baseType, managementJobMVO.baseType) &&
        Objects.equals(this.schemaLocation, managementJobMVO.schemaLocation) &&
        Objects.equals(this.href, managementJobMVO.href) &&
        Objects.equals(this.uuid, managementJobMVO.uuid) &&
        Objects.equals(this.executionState, managementJobMVO.executionState) &&
        Objects.equals(this.fileTransferData, managementJobMVO.fileTransferData) &&
        Objects.equals(this.dataAccessEndpoint, managementJobMVO.dataAccessEndpoint) &&
        Objects.equals(this.scheduleDefinition, managementJobMVO.scheduleDefinition);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, baseType, schemaLocation, href, uuid, fileTransferData, dataAccessEndpoint, scheduleDefinition);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ManagementJobMVO {\n");
    sb.append("    atType: ").append(toIndentedString(type)).append("\n");
    sb.append("    atBaseType: ").append(toIndentedString(baseType)).append("\n");
    sb.append("    atSchemaLocation: ").append(toIndentedString(schemaLocation)).append("\n");
    sb.append("    href: ").append(toIndentedString(href)).append("\n");
    sb.append("    id: ").append(toIndentedString(uuid)).append("\n");
    sb.append("    executionState: ").append(toIndentedString(executionState)).append("\n");
    sb.append("    fileTransferData: ").append(toIndentedString(fileTransferData)).append("\n");
    sb.append("    dataAccessEndpoint: ").append(toIndentedString(dataAccessEndpoint)).append("\n");
    sb.append("    scheduleDefinition: ").append(toIndentedString(scheduleDefinition)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

