package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.ri639.model.ResourceAdministrativeStateType;
import org.etsi.osl.tmf.ri639.model.ResourceOperationalStateType;
import org.etsi.osl.tmf.ri639.model.ResourceUsageStateType;

import javax.annotation.Generated;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

/**
 * LogicalResourceFVO
 */

@JsonIgnoreProperties(
  value = "@type", // ignore manually set @type, it will be automatically generated by Jackson during serialization
  allowSetters = true // allows the @type to be set during deserialization
)
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "@type", visible = true)
@JsonSubTypes({
  @JsonSubTypes.Type(value = DataAccessEndpointFVO.class, name = "DataAccessEndpoint")
})

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-05-15T07:30:16.936523289Z[Etc/UTC]", comments = "Generator version: 7.6.0-SNAPSHOT")
public class LogicalResourceFVO extends ResourceFVO {

  @JsonProperty("value")
  private String value;

  public LogicalResourceFVO() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public LogicalResourceFVO(String atType) {
    super(atType);
  }

  public LogicalResourceFVO value(String value) {
    this.value = value;
    return this;
  }

  /**
   * the value of the logical resource. E.g '0746712345' for  MSISDN's
   * @return value
  */
  
  @Schema(name = "value", description = "the value of the logical resource. E.g '0746712345' for  MSISDN's", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }


  public LogicalResourceFVO type(String type) {
    super.type(type);
    return this;
  }

  public LogicalResourceFVO baseType(String baseType) {
    super.baseType(baseType);
    return this;
  }

  public LogicalResourceFVO schemaLocation(String schemaLocation) {
    super.schemaLocation(schemaLocation);
    return this;
  }

  public LogicalResourceFVO href(String href) {
    super.href(href);
    return this;
  }

  public LogicalResourceFVO uuid(String uuid) {
    super.uuid(uuid);
    return this;
  }

  public LogicalResourceFVO category(String category) {
    super.category(category);
    return this;
  }

  public LogicalResourceFVO description(String description) {
    super.description(description);
    return this;
  }

  public LogicalResourceFVO name(String name) {
    super.name(name);
    return this;
  }

  public LogicalResourceFVO endOperatingDate(OffsetDateTime endOperatingDate) {
    super.endOperatingDate(endOperatingDate);
    return this;
  }

  public LogicalResourceFVO administrativeState(ResourceAdministrativeStateType administrativeState) {
    super.administrativeState(administrativeState);
    return this;
  }

  public LogicalResourceFVO operationalState(ResourceOperationalStateType operationalState) {
    super.operationalState(operationalState);
    return this;
  }

  public LogicalResourceFVO resourceStatus(ResourceStatusType resourceStatus) {
    super.resourceStatus(resourceStatus);
    return this;
  }

  public LogicalResourceFVO usageState(ResourceUsageStateType usageState) {
    super.usageState(usageState);
    return this;
  }

  public LogicalResourceFVO validFor(TimePeriod validFor) {
    super.validFor(validFor);
    return this;
  }

  public LogicalResourceFVO note(List<NoteFVO> note) {
    super.note(note);
    return this;
  }

  public LogicalResourceFVO addNoteItem(NoteFVO noteItem) {
    super.addNoteItem(noteItem);
    return this;
  }

  public LogicalResourceFVO resourceOrderItem(List<RelatedResourceOrderItemFVO> resourceOrderItem) {
    super.resourceOrderItem(resourceOrderItem);
    return this;
  }

  public LogicalResourceFVO addResourceOrderItemItem(RelatedResourceOrderItemFVO resourceOrderItemItem) {
    super.addResourceOrderItemItem(resourceOrderItemItem);
    return this;
  }

  public LogicalResourceFVO place(List<RelatedPlaceRefFVO> place) {
    super.place(place);
    return this;
  }

  public LogicalResourceFVO addPlaceItem(RelatedPlaceRefFVO placeItem) {
    super.addPlaceItem(placeItem);
    return this;
  }

  public LogicalResourceFVO relatedParty(List<RelatedPartyRefOrPartyRoleRefFVO> relatedParty) {
    super.relatedParty(relatedParty);
    return this;
  }

  public LogicalResourceFVO addRelatedPartyItem(RelatedPartyRefOrPartyRoleRefFVO relatedPartyItem) {
    super.addRelatedPartyItem(relatedPartyItem);
    return this;
  }

  public LogicalResourceFVO resourceRelationship(List<ResourceRelationshipFVO> resourceRelationship) {
    super.resourceRelationship(resourceRelationship);
    return this;
  }

  public LogicalResourceFVO addResourceRelationshipItem(ResourceRelationshipFVO resourceRelationshipItem) {
    super.addResourceRelationshipItem(resourceRelationshipItem);
    return this;
  }

  public LogicalResourceFVO resourceCharacteristic(List<CharacteristicFVO> resourceCharacteristic) {
    super.resourceCharacteristic(resourceCharacteristic);
    return this;
  }

  public LogicalResourceFVO addResourceCharacteristicItem(CharacteristicFVO resourceCharacteristicItem) {
    super.addResourceCharacteristicItem(resourceCharacteristicItem);
    return this;
  }

  public LogicalResourceFVO attachment(List<AttachmentRefFVO> attachment) {
    super.attachment(attachment);
    return this;
  }

  public LogicalResourceFVO addAttachmentItem(AttachmentRefFVO attachmentItem) {
    super.addAttachmentItem(attachmentItem);
    return this;
  }

  public LogicalResourceFVO resourceSpecification(ResourceSpecificationRefFVO resourceSpecification) {
    super.resourceSpecification(resourceSpecification);
    return this;
  }

  public LogicalResourceFVO startOperatingDate(OffsetDateTime startOperatingDate) {
    super.startOperatingDate(startOperatingDate);
    return this;
  }

  public LogicalResourceFVO resourceVersion(String resourceVersion) {
    super.resourceVersion(resourceVersion);
    return this;
  }

  public LogicalResourceFVO activationFeature(List<FeatureFVO> activationFeature) {
    super.activationFeature(activationFeature);
    return this;
  }

  public LogicalResourceFVO addActivationFeatureItem(FeatureFVO activationFeatureItem) {
    super.addActivationFeatureItem(activationFeatureItem);
    return this;
  }

  public LogicalResourceFVO intent(IntentRefFVO intent) {
    super.intent(intent);
    return this;
  }

  public LogicalResourceFVO externalIdentifier(List<ExternalIdentifierFVO> externalIdentifier) {
    super.externalIdentifier(externalIdentifier);
    return this;
  }

  public LogicalResourceFVO addExternalIdentifierItem(ExternalIdentifierFVO externalIdentifierItem) {
    super.addExternalIdentifierItem(externalIdentifierItem);
    return this;
  }
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LogicalResourceFVO logicalResourceFVO = (LogicalResourceFVO) o;
    return Objects.equals(this.value, logicalResourceFVO.value) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(value, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LogicalResourceFVO {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

