package org.etsi.osl.tmf.common.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;

import javax.annotation.Generated;
import java.net.URI;
import java.util.Objects;

/**
 * Base schema for adressable entities
 */

@Schema(name = "Addressable", description = "Base schema for adressable entities")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-04-25T11:17:58.147516734Z[Etc/UTC]", comments = "Generator version: 7.6.0-SNAPSHOT")
public class Addressable {

    private String id;

    private URI href;

    public Addressable id(String id) {
        this.id = id;
        return this;
    }

    /**
     * unique identifier
     *
     * @return id
     */

    @Schema(name = "id", description = "unique identifier", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Addressable href(URI href) {
        this.href = href;
        return this;
    }

    /**
     * Hyperlink reference
     *
     * @return href
     */
    @Valid
    @Schema(name = "href", description = "Hyperlink reference", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty("href")
    public URI getHref() {
        return href;
    }

    public void setHref(URI href) {
        this.href = href;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Addressable addressable = (Addressable) o;
        return Objects.equals(this.id, addressable.id) &&
                Objects.equals(this.href, addressable.href);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, href);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Addressable {\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    href: ").append(toIndentedString(href)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

