package org.etsi.osl.tmf.common.model;

public enum ERangeInterval {
    OPEN("open"),
    CLOSED("closed"),
    CLOSED_BOTTOM("closedBottom"),
    CLOSED_TOP("closedTop");

    private String value;

    ERangeInterval(String value) {this.value = value;}

    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return this.getValue();
    }

    public static ERangeInterval getEnum(String value) {
        for(ERangeInterval v : values())
            if(v.getValue().equalsIgnoreCase(value)) return v;
        throw new IllegalArgumentException();
    }
}
