package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.*;
import jakarta.persistence.Entity;
import jakarta.validation.Valid;
import org.etsi.osl.tmf.common.model.AttachmentRef;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.common.model.service.Note;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationRef;
import org.etsi.osl.tmf.ri639.model.ResourceAdministrativeStateType;
import org.etsi.osl.tmf.ri639.model.ResourceOperationalStateType;
import org.etsi.osl.tmf.ri639.model.ResourceUsageStateType;
import org.springframework.format.annotation.DateTimeFormat;

import javax.annotation.Generated;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Resource
 */

@JsonIgnoreProperties(
  value = "@type", // ignore manually set @type, it will be automatically generated by Jackson during serialization
  allowSetters = true // allows the @type to be set during deserialization
)
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "@type", visible = true)
@JsonSubTypes({
  @JsonSubTypes.Type(value = DataAccessEndpoint.class, name = "DataAccessEndpoint"),
  @JsonSubTypes.Type(value = LogicalResource.class, name = "LogicalResource"),
  @JsonSubTypes.Type(value = Resource.class, name = "Resource")
})

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-05-15T07:30:16.936523289Z[Etc/UTC]", comments = "Generator version: 7.6.0-SNAPSHOT")
@Entity(name = "PM628_Resource")
public class Resource extends BaseRootNamedEntity implements ResourceRefOrValue {

  @JsonProperty("category")
  private String category;

  @JsonProperty("description")
  private String description;

  @JsonProperty("endOperatingDate")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime endOperatingDate;

  @JsonProperty("administrativeState")
  private ResourceAdministrativeStateType administrativeState;

  @JsonProperty("operationalState")
  private ResourceOperationalStateType operationalState;

  @JsonProperty("resourceStatus")
  private ResourceStatusType resourceStatus;

  @JsonProperty("usageState")
  private ResourceUsageStateType usageState;

  @JsonProperty("validFor")
  @Embedded
  private TimePeriod validFor;

  @JsonProperty("note")
  @Valid
  @OneToMany(cascade = { CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH })
  @JoinTable(
        name = "pm628_resource_note",
        joinColumns = @JoinColumn(name = "resource_uuid"),
        inverseJoinColumns = @JoinColumn(name = "note_uuid")
  )
  private List<Note> note = new ArrayList<>();

  @JsonProperty("resourceOrderItem")
  @Valid
  @ElementCollection(targetClass = RelatedResourceOrderItem.class)
  @CollectionTable(
          name = "pm628_resource_roi",
          joinColumns = @JoinColumn(name = "resource_uid")
  )
  private List<RelatedResourceOrderItem> resourceOrderItem = new ArrayList<>();

  @JsonProperty("place")
  @Valid
  @OneToMany(cascade = { CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH })
  private List<RelatedPlaceRef> place = new ArrayList<>();

  @JsonProperty("relatedParty")
  @Valid
  @ElementCollection(targetClass = RelatedPartyRefOrPartyRoleRef.class)
  @CollectionTable(
          name = "pm628_resource_rp",
          joinColumns = @JoinColumn(name = "resource_uuid")
  )
  private List<RelatedPartyRefOrPartyRoleRef> relatedParty = new ArrayList<>();

  @JsonProperty("resourceRelationship")
  @Valid
  @OneToMany(cascade = { CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH })
  @JoinTable(
          name = "pm628_resource_res_rel",
          joinColumns = @JoinColumn(name = "resource_uuid"),
          inverseJoinColumns = @JoinColumn(name = "res_rel_uuid")
  )
  private List<ResourceRelationship> resourceRelationship = new ArrayList<>();

  @JsonProperty("resourceCharacteristic")
  @Valid
  @OneToMany(cascade = { CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH })
  @JoinTable(
          name = "pm628_resource_res_char",
          joinColumns = @JoinColumn(name = "resource_uuid"),
          inverseJoinColumns = @JoinColumn(name = "res_char_uuid")
  )
  private List<Characteristic> resourceCharacteristic = new ArrayList<>();

  @JsonProperty("attachment")
  @Valid
  @OneToMany(cascade = { CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH })
  @JoinTable(
          name = "pm628_resource_att",
          joinColumns = @JoinColumn(name = "resource_uuid"),
          inverseJoinColumns = @JoinColumn(name = "att_uuid")
  )
  private List<AttachmentRef> attachment = new ArrayList<>();

  @JsonProperty("resourceSpecification")
  @ManyToOne(cascade = { CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH })
  @JoinColumn(name = "res_spec_id")
  private ResourceSpecificationRef resourceSpecification;

  @JsonProperty("startOperatingDate")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime startOperatingDate;

  @JsonProperty("resourceVersion")
  private String resourceVersion;

  @JsonProperty("activationFeature")
  @Valid
  @OneToMany(cascade = { CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH })
  @JoinTable(
          name = "pm628_resource_act_feat",
          joinColumns = @JoinColumn(name = "resource_uuid"),
          inverseJoinColumns = @JoinColumn(name = "act_feat_uuid")
  )
  private List<Feature> activationFeature = new ArrayList<>();

  @JsonProperty("intent")
  private IntentRef intent;

  @JsonProperty("externalIdentifier")
  @Valid
  @ElementCollection(targetClass = ExternalIdentifier.class)
  @CollectionTable(
          name = "pm628_resource_ext_idf",
          joinColumns = @JoinColumn(name = "resource_uuid")
  )
  private List<ExternalIdentifier> externalIdentifier = new ArrayList<>();

  public Resource() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public Resource(String type) {
    this.type = type;
  }

  public Resource category(String category) {
    this.category = category;
    return this;
  }

  /**
   * Category of the concrete resource. e.g Gold, Silver for MSISDN concrete resource
   * @return category
  */
  
  @Schema(name = "category", description = "Category of the concrete resource. e.g Gold, Silver for MSISDN concrete resource", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("category")
  public String getCategory() {
    return category;
  }

  public void setCategory(String category) {
    this.category = category;
  }

  public Resource description(String description) {
    this.description = description;
    return this;
  }

  /**
   * free-text description of the resource
   * @return description
  */
  
  @Schema(name = "description", description = "free-text description of the resource", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public Resource endOperatingDate(OffsetDateTime endOperatingDate) {
    this.endOperatingDate = endOperatingDate;
    return this;
  }

  /**
   * A date time( DateTime). The date till the resource is operating
   * @return endOperatingDate
  */
  @Valid 
  @Schema(name = "endOperatingDate", description = "A date time( DateTime). The date till the resource is operating", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("endOperatingDate")
  public OffsetDateTime getEndOperatingDate() {
    return endOperatingDate;
  }

  public void setEndOperatingDate(OffsetDateTime endOperatingDate) {
    this.endOperatingDate = endOperatingDate;
  }

  public Resource administrativeState(ResourceAdministrativeStateType administrativeState) {
    this.administrativeState = administrativeState;
    return this;
  }

  /**
   * Get administrativeState
   * @return administrativeState
  */
  @Valid 
  @Schema(name = "administrativeState", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("administrativeState")
  public ResourceAdministrativeStateType getAdministrativeState() {
    return administrativeState;
  }

  public void setAdministrativeState(ResourceAdministrativeStateType administrativeState) {
    this.administrativeState = administrativeState;
  }

  public Resource operationalState(ResourceOperationalStateType operationalState) {
    this.operationalState = operationalState;
    return this;
  }

  /**
   * Get operationalState
   * @return operationalState
  */
  @Valid 
  @Schema(name = "operationalState", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("operationalState")
  public ResourceOperationalStateType getOperationalState() {
    return operationalState;
  }

  public void setOperationalState(ResourceOperationalStateType operationalState) {
    this.operationalState = operationalState;
  }

  public Resource resourceStatus(ResourceStatusType resourceStatus) {
    this.resourceStatus = resourceStatus;
    return this;
  }

  /**
   * Get resourceStatus
   * @return resourceStatus
  */
  @Valid 
  @Schema(name = "resourceStatus", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("resourceStatus")
  public ResourceStatusType getResourceStatus() {
    return resourceStatus;
  }

  public void setResourceStatus(ResourceStatusType resourceStatus) {
    this.resourceStatus = resourceStatus;
  }

  public Resource usageState(ResourceUsageStateType usageState) {
    this.usageState = usageState;
    return this;
  }

  /**
   * Get usageState
   * @return usageState
  */
  @Valid 
  @Schema(name = "usageState", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("usageState")
  public ResourceUsageStateType getUsageState() {
    return usageState;
  }

  public void setUsageState(ResourceUsageStateType usageState) {
    this.usageState = usageState;
  }

  public Resource validFor(TimePeriod validFor) {
    this.validFor = validFor;
    return this;
  }

  /**
   * Get validFor
   * @return validFor
  */
  @Valid 
  @Schema(name = "validFor", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("validFor")
  public TimePeriod getValidFor() {
    return validFor;
  }

  public void setValidFor(TimePeriod validFor) {
    this.validFor = validFor;
  }

  public Resource note(List<Note> note) {
    this.note = note;
    return this;
  }

  public Resource addNoteItem(Note noteItem) {
    if (this.note == null) {
      this.note = new ArrayList<>();
    }
    this.note.add(noteItem);
    return this;
  }

  /**
   * Get note
   * @return note
  */
  @Valid 
  @Schema(name = "note", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("note")
  public List<Note> getNote() {
    return note;
  }

  public void setNote(List<Note> note) {
    this.note = note;
  }

  public Resource resourceOrderItem(List<RelatedResourceOrderItem> resourceOrderItem) {
    this.resourceOrderItem = resourceOrderItem;
    return this;
  }

  public Resource addResourceOrderItemItem(RelatedResourceOrderItem resourceOrderItemItem) {
    if (this.resourceOrderItem == null) {
      this.resourceOrderItem = new ArrayList<>();
    }
    this.resourceOrderItem.add(resourceOrderItemItem);
    return this;
  }

  /**
   * A list of resource order items related to this resource
   * @return resourceOrderItem
  */
  @Valid 
  @Schema(name = "resourceOrderItem", description = "A list of resource order items related to this resource", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("resourceOrderItem")
  public List<RelatedResourceOrderItem> getResourceOrderItem() {
    return resourceOrderItem;
  }

  public void setResourceOrderItem(List<RelatedResourceOrderItem> resourceOrderItem) {
    this.resourceOrderItem = resourceOrderItem;
  }

  public Resource place(List<RelatedPlaceRef> place) {
    this.place = place;
    return this;
  }

  public Resource addPlaceItem(RelatedPlaceRef placeItem) {
    if (this.place == null) {
      this.place = new ArrayList<>();
    }
    this.place.add(placeItem);
    return this;
  }

  /**
   * Get place
   * @return place
  */
  @Valid 
  @Schema(name = "place", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("place")
  public List<RelatedPlaceRef> getPlace() {
    return place;
  }

  public void setPlace(List<RelatedPlaceRef> place) {
    this.place = place;
  }

  public Resource relatedParty(List<RelatedPartyRefOrPartyRoleRef> relatedParty) {
    this.relatedParty = relatedParty;
    return this;
  }

  public Resource addRelatedPartyItem(RelatedPartyRefOrPartyRoleRef relatedPartyItem) {
    if (this.relatedParty == null) {
      this.relatedParty = new ArrayList<>();
    }
    this.relatedParty.add(relatedPartyItem);
    return this;
  }

  /**
   * Get relatedParty
   * @return relatedParty
  */
  @Valid 
  @Schema(name = "relatedParty", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("relatedParty")
  public List<RelatedPartyRefOrPartyRoleRef> getRelatedParty() {
    return relatedParty;
  }

  public void setRelatedParty(List<RelatedPartyRefOrPartyRoleRef> relatedParty) {
    this.relatedParty = relatedParty;
  }

  public Resource resourceRelationship(List<ResourceRelationship> resourceRelationship) {
    this.resourceRelationship = resourceRelationship;
    return this;
  }

  public Resource addResourceRelationshipItem(ResourceRelationship resourceRelationshipItem) {
    if (this.resourceRelationship == null) {
      this.resourceRelationship = new ArrayList<>();
    }
    this.resourceRelationship.add(resourceRelationshipItem);
    return this;
  }

  /**
   * Get resourceRelationship
   * @return resourceRelationship
  */
  @Valid 
  @Schema(name = "resourceRelationship", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("resourceRelationship")
  public List<ResourceRelationship> getResourceRelationship() {
    return resourceRelationship;
  }

  public void setResourceRelationship(List<ResourceRelationship> resourceRelationship) {
    this.resourceRelationship = resourceRelationship;
  }

  public Resource resourceCharacteristic(List<Characteristic> resourceCharacteristic) {
    this.resourceCharacteristic = resourceCharacteristic;
    return this;
  }

  public Resource addResourceCharacteristicItem(Characteristic resourceCharacteristicItem) {
    if (this.resourceCharacteristic == null) {
      this.resourceCharacteristic = new ArrayList<>();
    }
    this.resourceCharacteristic.add(resourceCharacteristicItem);
    return this;
  }

  /**
   * Get resourceCharacteristic
   * @return resourceCharacteristic
  */
  @Valid 
  @Schema(name = "resourceCharacteristic", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("resourceCharacteristic")
  public List<Characteristic> getResourceCharacteristic() {
    return resourceCharacteristic;
  }

  public void setResourceCharacteristic(List<Characteristic> resourceCharacteristic) {
    this.resourceCharacteristic = resourceCharacteristic;
  }

  public Resource attachment(List<AttachmentRef> attachment) {
    this.attachment = attachment;
    return this;
  }

  public Resource addAttachmentItem(AttachmentRef attachmentItem) {
    if (this.attachment == null) {
      this.attachment = new ArrayList<>();
    }
    this.attachment.add(attachmentItem);
    return this;
  }

  /**
   * Get attachment
   * @return attachment
  */
  @Valid 
  @Schema(name = "attachment", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("attachment")
  public List<AttachmentRef> getAttachment() {
    return attachment;
  }

  public void setAttachment(List<AttachmentRef> attachment) {
    this.attachment = attachment;
  }

  public Resource resourceSpecification(ResourceSpecificationRef resourceSpecification) {
    this.resourceSpecification = resourceSpecification;
    return this;
  }

  /**
   * Get resourceSpecification
   * @return resourceSpecification
  */
  @Valid 
  @Schema(name = "resourceSpecification", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("resourceSpecification")
  public ResourceSpecificationRef getResourceSpecification() {
    return resourceSpecification;
  }

  public void setResourceSpecification(ResourceSpecificationRef resourceSpecification) {
    this.resourceSpecification = resourceSpecification;
  }

  public Resource startOperatingDate(OffsetDateTime startOperatingDate) {
    this.startOperatingDate = startOperatingDate;
    return this;
  }

  /**
   * A date time( DateTime). The date from which the resource is operating
   * @return startOperatingDate
  */
  @Valid 
  @Schema(name = "startOperatingDate", description = "A date time( DateTime). The date from which the resource is operating", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("startOperatingDate")
  public OffsetDateTime getStartOperatingDate() {
    return startOperatingDate;
  }

  public void setStartOperatingDate(OffsetDateTime startOperatingDate) {
    this.startOperatingDate = startOperatingDate;
  }

  public Resource resourceVersion(String resourceVersion) {
    this.resourceVersion = resourceVersion;
    return this;
  }

  /**
   * A field that identifies the specific version of an instance of a resource.
   * @return resourceVersion
  */
  
  @Schema(name = "resourceVersion", description = "A field that identifies the specific version of an instance of a resource.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("resourceVersion")
  public String getResourceVersion() {
    return resourceVersion;
  }

  public void setResourceVersion(String resourceVersion) {
    this.resourceVersion = resourceVersion;
  }

  public Resource activationFeature(List<Feature> activationFeature) {
    this.activationFeature = activationFeature;
    return this;
  }

  public Resource addActivationFeatureItem(Feature activationFeatureItem) {
    if (this.activationFeature == null) {
      this.activationFeature = new ArrayList<>();
    }
    this.activationFeature.add(activationFeatureItem);
    return this;
  }

  /**
   * Configuration features
   * @return activationFeature
  */
  @Valid 
  @Schema(name = "activationFeature", description = "Configuration features", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("activationFeature")
  public List<Feature> getActivationFeature() {
    return activationFeature;
  }

  public void setActivationFeature(List<Feature> activationFeature) {
    this.activationFeature = activationFeature;
  }

  public Resource intent(IntentRef intent) {
    this.intent = intent;
    return this;
  }

  /**
   * Get intent
   * @return intent
  */
  @Valid 
  @Schema(name = "intent", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("intent")
  public IntentRef getIntent() {
    return intent;
  }

  public void setIntent(IntentRef intent) {
    this.intent = intent;
  }

  public Resource externalIdentifier(List<ExternalIdentifier> externalIdentifier) {
    this.externalIdentifier = externalIdentifier;
    return this;
  }

  public Resource addExternalIdentifierItem(ExternalIdentifier externalIdentifierItem) {
    if (this.externalIdentifier == null) {
      this.externalIdentifier = new ArrayList<>();
    }
    this.externalIdentifier.add(externalIdentifierItem);
    return this;
  }

  /**
   * An identification of this resource that is owned by or originates in a software system different from the current system. The structure identifies the system itself, the nature of the resource within the system and the unique ID of the resource within the system. It is anticipated that multiple external IDs can be held for a single resource, e.g. if the resource passed through multiple systems on the way to the current system.
   * @return externalIdentifier
  */
  @Valid 
  @Schema(name = "externalIdentifier", description = "An identification of this resource that is owned by or originates in a software system different from the current system. The structure identifies the system itself, the nature of the resource within the system and the unique ID of the resource within the system. It is anticipated that multiple external IDs can be held for a single resource, e.g. if the resource passed through multiple systems on the way to the current system.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("externalIdentifier")
  public List<ExternalIdentifier> getExternalIdentifier() {
    return externalIdentifier;
  }

  public void setExternalIdentifier(List<ExternalIdentifier> externalIdentifier) {
    this.externalIdentifier = externalIdentifier;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Resource resource = (Resource) o;
    return Objects.equals(this.type, resource.type) &&
        Objects.equals(this.baseType, resource.baseType) &&
        Objects.equals(this.schemaLocation, resource.schemaLocation) &&
        Objects.equals(this.href, resource.href) &&
        Objects.equals(this.uuid, resource.uuid) &&
        Objects.equals(this.category, resource.category) &&
        Objects.equals(this.description, resource.description) &&
        Objects.equals(this.name, resource.name) &&
        Objects.equals(this.endOperatingDate, resource.endOperatingDate) &&
        Objects.equals(this.administrativeState, resource.administrativeState) &&
        Objects.equals(this.operationalState, resource.operationalState) &&
        Objects.equals(this.resourceStatus, resource.resourceStatus) &&
        Objects.equals(this.usageState, resource.usageState) &&
        Objects.equals(this.validFor, resource.validFor) &&
        Objects.equals(this.note, resource.note) &&
        Objects.equals(this.resourceOrderItem, resource.resourceOrderItem) &&
        Objects.equals(this.place, resource.place) &&
        Objects.equals(this.relatedParty, resource.relatedParty) &&
        Objects.equals(this.resourceRelationship, resource.resourceRelationship) &&
        Objects.equals(this.resourceCharacteristic, resource.resourceCharacteristic) &&
        Objects.equals(this.attachment, resource.attachment) &&
        Objects.equals(this.resourceSpecification, resource.resourceSpecification) &&
        Objects.equals(this.startOperatingDate, resource.startOperatingDate) &&
        Objects.equals(this.resourceVersion, resource.resourceVersion) &&
        Objects.equals(this.activationFeature, resource.activationFeature) &&
        Objects.equals(this.intent, resource.intent) &&
        Objects.equals(this.externalIdentifier, resource.externalIdentifier);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, baseType, schemaLocation, href, uuid, category, description, name, endOperatingDate, administrativeState, operationalState, resourceStatus, usageState, validFor, note, resourceOrderItem, place, relatedParty, resourceRelationship, resourceCharacteristic, attachment, resourceSpecification, startOperatingDate, resourceVersion, activationFeature, intent, externalIdentifier);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Resource {\n");
    sb.append("    atType: ").append(toIndentedString(type)).append("\n");
    sb.append("    atBaseType: ").append(toIndentedString(baseType)).append("\n");
    sb.append("    atSchemaLocation: ").append(toIndentedString(schemaLocation)).append("\n");
    sb.append("    href: ").append(toIndentedString(href)).append("\n");
    sb.append("    id: ").append(toIndentedString(uuid)).append("\n");
    sb.append("    category: ").append(toIndentedString(category)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    endOperatingDate: ").append(toIndentedString(endOperatingDate)).append("\n");
    sb.append("    administrativeState: ").append(toIndentedString(administrativeState)).append("\n");
    sb.append("    operationalState: ").append(toIndentedString(operationalState)).append("\n");
    sb.append("    resourceStatus: ").append(toIndentedString(resourceStatus)).append("\n");
    sb.append("    usageState: ").append(toIndentedString(usageState)).append("\n");
    sb.append("    validFor: ").append(toIndentedString(validFor)).append("\n");
    sb.append("    note: ").append(toIndentedString(note)).append("\n");
    sb.append("    resourceOrderItem: ").append(toIndentedString(resourceOrderItem)).append("\n");
    sb.append("    place: ").append(toIndentedString(place)).append("\n");
    sb.append("    relatedParty: ").append(toIndentedString(relatedParty)).append("\n");
    sb.append("    resourceRelationship: ").append(toIndentedString(resourceRelationship)).append("\n");
    sb.append("    resourceCharacteristic: ").append(toIndentedString(resourceCharacteristic)).append("\n");
    sb.append("    attachment: ").append(toIndentedString(attachment)).append("\n");
    sb.append("    resourceSpecification: ").append(toIndentedString(resourceSpecification)).append("\n");
    sb.append("    startOperatingDate: ").append(toIndentedString(startOperatingDate)).append("\n");
    sb.append("    resourceVersion: ").append(toIndentedString(resourceVersion)).append("\n");
    sb.append("    activationFeature: ").append(toIndentedString(activationFeature)).append("\n");
    sb.append("    intent: ").append(toIndentedString(intent)).append("\n");
    sb.append("    externalIdentifier: ").append(toIndentedString(externalIdentifier)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

