package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;

import javax.annotation.Generated;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * MeasurementJobFVO
 */

@JsonIgnoreProperties(
    ignoreUnknown = true,
  value = "@type", // ignore manually set @type, it will be automatically generated by Jackson during serialization
  allowSetters = true // allows the @type to be set during deserialization
)
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "@type", visible = true)
@JsonSubTypes({
  @JsonSubTypes.Type(value = MeasurementCollectionJobFVO.class, name = "MeasurementCollectionJob")
})

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-05-15T07:30:16.936523289Z[Etc/UTC]", comments = "Generator version: 7.6.0-SNAPSHOT")
public class MeasurementJobFVO extends ManagementJobFVO {

  @JsonProperty("consumingApplicationId")
  private String consumingApplicationId;

  @JsonProperty("producingApplicationId")
  private String producingApplicationId;

  @JsonProperty("granularity")
  private Granularity granularity;

  @JsonProperty("performanceIndicatorGroupSpecification")
  @Valid
  private List<PerformanceIndicatorGroupSpecificationFVO> performanceIndicatorGroupSpecification = new ArrayList<>();

  @JsonProperty("performanceIndicatorSpecification")
  @Valid
  private List<@Valid PerformanceIndicatorSpecificationRefOrValueFVO> performanceIndicatorSpecification = new ArrayList<>();

  @JsonProperty("trackingRecord")
  @Valid
  private List<TrackingRecordFVO> trackingRecord = new ArrayList<>();

  @JsonProperty("monitoredInstancesCriteria")
  private MonitoredInstancesCriteriaFVO monitoredInstancesCriteria;

  @JsonProperty("monitoredClassCriteria")
  private MonitoredClassCriteriaFVO monitoredClassCriteria;

  public MeasurementJobFVO() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public MeasurementJobFVO(String consumingApplicationId, String producingApplicationId, List<@Valid PerformanceIndicatorSpecificationRefOrValueFVO> performanceIndicatorSpecification, String atType) {
    super(atType);
    this.consumingApplicationId = consumingApplicationId;
    this.producingApplicationId = producingApplicationId;
    this.performanceIndicatorSpecification = performanceIndicatorSpecification;
  }

  public MeasurementJobFVO consumingApplicationId(String consumingApplicationId) {
    this.consumingApplicationId = consumingApplicationId;
    return this;
  }

  /**
   * The identifier of the application that consumes performance indicators.
   * @return consumingApplicationId
  */
  @NotNull 
  @Schema(name = "consumingApplicationId", description = "The identifier of the application that consumes performance indicators.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("consumingApplicationId")
  public String getConsumingApplicationId() {
    return consumingApplicationId;
  }

  public void setConsumingApplicationId(String consumingApplicationId) {
    this.consumingApplicationId = consumingApplicationId;
  }

  public MeasurementJobFVO producingApplicationId(String producingApplicationId) {
    this.producingApplicationId = producingApplicationId;
    return this;
  }

  /**
   * The identifier of the application that produces performance indicators.
   * @return producingApplicationId
  */
  @NotNull 
  @Schema(name = "producingApplicationId", description = "The identifier of the application that produces performance indicators.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("producingApplicationId")
  public String getProducingApplicationId() {
    return producingApplicationId;
  }

  public void setProducingApplicationId(String producingApplicationId) {
    this.producingApplicationId = producingApplicationId;
  }

  public MeasurementJobFVO granularity(Granularity granularity) {
    this.granularity = granularity;
    return this;
  }

  /**
   * Get granularity
   * @return granularity
  */
  @Valid 
  @Schema(name = "granularity", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("granularity")
  public Granularity getGranularity() {
    return granularity;
  }

  public void setGranularity(Granularity granularity) {
    this.granularity = granularity;
  }

  public MeasurementJobFVO performanceIndicatorGroupSpecification(List<PerformanceIndicatorGroupSpecificationFVO> performanceIndicatorGroupSpecification) {
    this.performanceIndicatorGroupSpecification = performanceIndicatorGroupSpecification;
    return this;
  }

  public MeasurementJobFVO addPerformanceIndicatorGroupSpecificationItem(PerformanceIndicatorGroupSpecificationFVO performanceIndicatorGroupSpecificationItem) {
    if (this.performanceIndicatorGroupSpecification == null) {
      this.performanceIndicatorGroupSpecification = new ArrayList<>();
    }
    this.performanceIndicatorGroupSpecification.add(performanceIndicatorGroupSpecificationItem);
    return this;
  }

  /**
   * Get performanceIndicatorGroupSpecification
   * @return performanceIndicatorGroupSpecification
  */
  @Valid @Size(min = 0) 
  @Schema(name = "performanceIndicatorGroupSpecification", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("performanceIndicatorGroupSpecification")
  public List<PerformanceIndicatorGroupSpecificationFVO> getPerformanceIndicatorGroupSpecification() {
    return performanceIndicatorGroupSpecification;
  }

  public void setPerformanceIndicatorGroupSpecification(List<PerformanceIndicatorGroupSpecificationFVO> performanceIndicatorGroupSpecification) {
    this.performanceIndicatorGroupSpecification = performanceIndicatorGroupSpecification;
  }

  public MeasurementJobFVO performanceIndicatorSpecification(List<@Valid PerformanceIndicatorSpecificationRefOrValueFVO> performanceIndicatorSpecification) {
    this.performanceIndicatorSpecification = performanceIndicatorSpecification;
    return this;
  }

  public MeasurementJobFVO addPerformanceIndicatorSpecificationItem(PerformanceIndicatorSpecificationRefOrValueFVO performanceIndicatorSpecificationItem) {
    if (this.performanceIndicatorSpecification == null) {
      this.performanceIndicatorSpecification = new ArrayList<>();
    }
    this.performanceIndicatorSpecification.add(performanceIndicatorSpecificationItem);
    return this;
  }

  /**
   * Get performanceIndicatorSpecification
   * @return performanceIndicatorSpecification
  */
  @NotNull @Valid @Size(min = 0) 
  @Schema(name = "performanceIndicatorSpecification", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("performanceIndicatorSpecification")
  public List<@Valid PerformanceIndicatorSpecificationRefOrValueFVO> getPerformanceIndicatorSpecification() {
    return performanceIndicatorSpecification;
  }

  public void setPerformanceIndicatorSpecification(List<@Valid PerformanceIndicatorSpecificationRefOrValueFVO> performanceIndicatorSpecification) {
    this.performanceIndicatorSpecification = performanceIndicatorSpecification;
  }

  public MeasurementJobFVO trackingRecord(List<TrackingRecordFVO> trackingRecord) {
    this.trackingRecord = trackingRecord;
    return this;
  }

  public MeasurementJobFVO addTrackingRecordItem(TrackingRecordFVO trackingRecordItem) {
    if (this.trackingRecord == null) {
      this.trackingRecord = new ArrayList<>();
    }
    this.trackingRecord.add(trackingRecordItem);
    return this;
  }

  /**
   * Get trackingRecord
   * @return trackingRecord
  */
  @Valid @Size(min = 0) 
  @Schema(name = "trackingRecord", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("trackingRecord")
  public List<TrackingRecordFVO> getTrackingRecord() {
    return trackingRecord;
  }

  public void setTrackingRecord(List<TrackingRecordFVO> trackingRecord) {
    this.trackingRecord = trackingRecord;
  }

  public MeasurementJobFVO monitoredInstancesCriteria(MonitoredInstancesCriteriaFVO monitoredInstancesCriteria) {
    this.monitoredInstancesCriteria = monitoredInstancesCriteria;
    return this;
  }

  /**
   * Get monitoredInstancesCriteria
   * @return monitoredInstancesCriteria
  */
  @Valid 
  @Schema(name = "monitoredInstancesCriteria", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("monitoredInstancesCriteria")
  public MonitoredInstancesCriteriaFVO getMonitoredInstancesCriteria() {
    return monitoredInstancesCriteria;
  }

  public void setMonitoredInstancesCriteria(MonitoredInstancesCriteriaFVO monitoredInstancesCriteria) {
    this.monitoredInstancesCriteria = monitoredInstancesCriteria;
  }

  public MeasurementJobFVO monitoredClassCriteria(MonitoredClassCriteriaFVO monitoredClassCriteria) {
    this.monitoredClassCriteria = monitoredClassCriteria;
    return this;
  }

  /**
   * Get monitoredClassCriteria
   * @return monitoredClassCriteria
  */
  @Valid 
  @Schema(name = "monitoredClassCriteria", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("monitoredClassCriteria")
  public MonitoredClassCriteriaFVO getMonitoredClassCriteria() {
    return monitoredClassCriteria;
  }

  public void setMonitoredClassCriteria(MonitoredClassCriteriaFVO monitoredClassCriteria) {
    this.monitoredClassCriteria = monitoredClassCriteria;
  }

  public MeasurementJobFVO adminState(AdministrativeState adminState) {
    super.adminState(adminState);
    return this;
  }

  public MeasurementJobFVO creationTime(OffsetDateTime creationTime) {
    super.creationTime(creationTime);
    return this;
  }

  public MeasurementJobFVO executionState(ExecutionStateType executionState) {
    super.executionState(executionState);
    return this;
  }

  public MeasurementJobFVO fileTransferData(List<FileTransferDataFVO> fileTransferData) {
    super.fileTransferData(fileTransferData);
    return this;
  }

  public MeasurementJobFVO addFileTransferDataItem(FileTransferDataFVO fileTransferDataItem) {
    super.addFileTransferDataItem(fileTransferDataItem);
    return this;
  }

  public MeasurementJobFVO dataAccessEndpoint(List<DataAccessEndpointFVO> dataAccessEndpoint) {
    super.dataAccessEndpoint(dataAccessEndpoint);
    return this;
  }

  public MeasurementJobFVO addDataAccessEndpointItem(DataAccessEndpointFVO dataAccessEndpointItem) {
    super.addDataAccessEndpointItem(dataAccessEndpointItem);
    return this;
  }

  public MeasurementJobFVO jobId(String jobId) {
    super.jobId(jobId);
    return this;
  }

  public MeasurementJobFVO jobPriority(Integer jobPriority) {
    super.jobPriority(jobPriority);
    return this;
  }

  public MeasurementJobFVO lastModifiedTime(OffsetDateTime lastModifiedTime) {
    super.lastModifiedTime(lastModifiedTime);
    return this;
  }

  public MeasurementJobFVO scheduleDefinition(List<ScheduleDefinitionFVO> scheduleDefinition) {
    super.scheduleDefinition(scheduleDefinition);
    return this;
  }

  public MeasurementJobFVO addScheduleDefinitionItem(ScheduleDefinitionFVO scheduleDefinitionItem) {
    super.addScheduleDefinitionItem(scheduleDefinitionItem);
    return this;
  }
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MeasurementJobFVO measurementJobFVO = (MeasurementJobFVO) o;
    return Objects.equals(this.consumingApplicationId, measurementJobFVO.consumingApplicationId) &&
        Objects.equals(this.producingApplicationId, measurementJobFVO.producingApplicationId) &&
        Objects.equals(this.granularity, measurementJobFVO.granularity) &&
        Objects.equals(this.performanceIndicatorGroupSpecification, measurementJobFVO.performanceIndicatorGroupSpecification) &&
        Objects.equals(this.performanceIndicatorSpecification, measurementJobFVO.performanceIndicatorSpecification) &&
        Objects.equals(this.trackingRecord, measurementJobFVO.trackingRecord) &&
        Objects.equals(this.monitoredInstancesCriteria, measurementJobFVO.monitoredInstancesCriteria) &&
        Objects.equals(this.monitoredClassCriteria, measurementJobFVO.monitoredClassCriteria) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(consumingApplicationId, producingApplicationId, granularity, performanceIndicatorGroupSpecification, performanceIndicatorSpecification, trackingRecord, monitoredInstancesCriteria, monitoredClassCriteria, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MeasurementJobFVO {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    consumingApplicationId: ").append(toIndentedString(consumingApplicationId)).append("\n");
    sb.append("    producingApplicationId: ").append(toIndentedString(producingApplicationId)).append("\n");
    sb.append("    granularity: ").append(toIndentedString(granularity)).append("\n");
    sb.append("    performanceIndicatorGroupSpecification: ").append(toIndentedString(performanceIndicatorGroupSpecification)).append("\n");
    sb.append("    performanceIndicatorSpecification: ").append(toIndentedString(performanceIndicatorSpecification)).append("\n");
    sb.append("    trackingRecord: ").append(toIndentedString(trackingRecord)).append("\n");
    sb.append("    monitoredInstancesCriteria: ").append(toIndentedString(monitoredInstancesCriteria)).append("\n");
    sb.append("    monitoredClassCriteria: ").append(toIndentedString(monitoredClassCriteria)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

