package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.ri639.model.ResourceAdministrativeStateType;
import org.etsi.osl.tmf.ri639.model.ResourceOperationalStateType;
import org.etsi.osl.tmf.ri639.model.ResourceUsageStateType;
import org.springframework.format.annotation.DateTimeFormat;

import javax.annotation.Generated;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * ResourceFVO
 */

@JsonIgnoreProperties(
  value = "@type", // ignore manually set @type, it will be automatically generated by Jackson during serialization
  allowSetters = true // allows the @type to be set during deserialization
)
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "@type", visible = true)
@JsonSubTypes({
  @JsonSubTypes.Type(value = DataAccessEndpointFVO.class, name = "DataAccessEndpoint"),
  @JsonSubTypes.Type(value = LogicalResourceFVO.class, name = "LogicalResource"),
  @JsonSubTypes.Type(value = ResourceFVO.class, name = "Resource")
})

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-05-15T07:30:16.936523289Z[Etc/UTC]", comments = "Generator version: 7.6.0-SNAPSHOT")
public class ResourceFVO implements ResourceRefOrValueFVO {

  @JsonProperty("@type")
  private String type;

  @JsonProperty("@baseType")
  private String baseType;

  @JsonProperty("@schemaLocation")
  private String schemaLocation;

  @JsonProperty("href")
  private String href;

  @JsonProperty("uuid")
  private String uuid;

  @JsonProperty("category")
  private String category;

  @JsonProperty("description")
  private String description;

  @JsonProperty("name")
  private String name;

  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime endOperatingDate;

  @JsonProperty("administrativeState")
  private ResourceAdministrativeStateType administrativeState;

  @JsonProperty("operationalState")
  private ResourceOperationalStateType operationalState;

  @JsonProperty("resourceStatus")
  private ResourceStatusType resourceStatus;

  @JsonProperty("usageState")
  private ResourceUsageStateType usageState;

  @JsonProperty("validFor")
  private TimePeriod validFor;

  @JsonProperty("note")
  @Valid
  private List<NoteFVO> note = new ArrayList<>();

  @JsonProperty("resourceOrderItem")
  @Valid
  private List<RelatedResourceOrderItemFVO> resourceOrderItem = new ArrayList<>();

  @JsonProperty("place")
  @Valid
  private List<RelatedPlaceRefFVO> place = new ArrayList<>();

  @JsonProperty("relatedParty")
  @Valid
  private List<RelatedPartyRefOrPartyRoleRefFVO> relatedParty = new ArrayList<>();

  @JsonProperty("resourceRelationship")
  @Valid
  private List<ResourceRelationshipFVO> resourceRelationship = new ArrayList<>();

  @JsonProperty("resourceCharacteristic")
  @Valid
  private List<CharacteristicFVO> resourceCharacteristic = new ArrayList<>();

  @JsonProperty("attachment")
  @Valid
  private List<AttachmentRefFVO> attachment = new ArrayList<>();

  @JsonProperty("resourceSpecification")
  private ResourceSpecificationRefFVO resourceSpecification;

  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime startOperatingDate;

  @JsonProperty("resourceVersion")
  private String resourceVersion;

  @JsonProperty("activationFeature")
  @Valid
  private List<FeatureFVO> activationFeature = new ArrayList<>();

  @JsonProperty("intent")
  private IntentRefFVO intent;

  @JsonProperty("externalIdentifier")
  @Valid
  private List<ExternalIdentifierFVO> externalIdentifier = new ArrayList<>();

  public ResourceFVO() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public ResourceFVO(String type) {
    this.type = type;
  }

  public ResourceFVO type(String type) {
    this.type = type;
    return this;
  }

  /**
   * When sub-classing, this defines the sub-class Extensible name
   * @return atType
  */
  @NotNull 
  @Schema(name = "@type", description = "When sub-classing, this defines the sub-class Extensible name", requiredMode = Schema.RequiredMode.REQUIRED)
  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public ResourceFVO baseType(String baseType) {
    this.baseType = baseType;
    return this;
  }

  /**
   * When sub-classing, this defines the super-class
   * @return atBaseType
  */
  
  @Schema(name = "@baseType", description = "When sub-classing, this defines the super-class", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public String getBaseType() {
    return baseType;
  }

  public void setBaseType(String baseType) {
    this.baseType = baseType;
  }

  public ResourceFVO schemaLocation(String schemaLocation) {
    this.schemaLocation = schemaLocation;
    return this;
  }

  /**
   * A URI to a JSON-Schema file that defines additional attributes and relationships
   * @return atSchemaLocation
  */
  
  @Schema(name = "@schemaLocation", description = "A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public String getSchemaLocation() {
    return schemaLocation;
  }

  public void setSchemaLocation(String schemaLocation) {
    this.schemaLocation = schemaLocation;
  }

  public ResourceFVO href(String href) {
    this.href = href;
    return this;
  }

  /**
   * Hyperlink reference
   * @return href
  */
  
  @Schema(name = "href", description = "Hyperlink reference", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public String getHref() {
    return href;
  }

  public void setHref(String href) {
    this.href = href;
  }

  public ResourceFVO uuid(String uuid) {
    this.uuid = uuid;
    return this;
  }

  /**
   * unique identifier
   * @return id
  */
  
  @Schema(name = "uuid", description = "unique identifier", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public String getUuid() {
    return uuid;
  }

  public void setUuid(String uuid) {
    this.uuid = uuid;
  }

  public ResourceFVO category(String category) {
    this.category = category;
    return this;
  }

  /**
   * Category of the concrete resource. e.g Gold, Silver for MSISDN concrete resource
   * @return category
  */
  
  @Schema(name = "category", description = "Category of the concrete resource. e.g Gold, Silver for MSISDN concrete resource", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public String getCategory() {
    return category;
  }

  public void setCategory(String category) {
    this.category = category;
  }

  public ResourceFVO description(String description) {
    this.description = description;
    return this;
  }

  /**
   * free-text description of the resource
   * @return description
  */
  
  @Schema(name = "description", description = "free-text description of the resource", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public ResourceFVO name(String name) {
    this.name = name;
    return this;
  }

  /**
   * the name of the resource
   * @return name
  */
  
  @Schema(name = "name", description = "the name of the resource", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public ResourceFVO endOperatingDate(OffsetDateTime endOperatingDate) {
    this.endOperatingDate = endOperatingDate;
    return this;
  }

  /**
   * A date time( DateTime). The date till the resource is operating
   * @return endOperatingDate
  */
  @Valid 
  @Schema(name = "endOperatingDate", description = "A date time( DateTime). The date till the resource is operating", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("endOperatingDate")
  public String getEndOperatingDateString() {
    return (endOperatingDate != null) ? endOperatingDate.toString() : null;
  }

  public void setEndOperatingDate(String endOperatingDate) {
    if ( endOperatingDate!= null ) {
      this.endOperatingDate = OffsetDateTime.parse( endOperatingDate );
    }
  }

  public OffsetDateTime getEndOperatingDate() {
    return endOperatingDate;
  }

  public void setEndOperatingDate(OffsetDateTime endOperatingDate) {
    this.endOperatingDate = endOperatingDate;
  }

  public ResourceFVO administrativeState(ResourceAdministrativeStateType administrativeState) {
    this.administrativeState = administrativeState;
    return this;
  }

  /**
   * Get administrativeState
   * @return administrativeState
  */
  @Valid 
  @Schema(name = "administrativeState", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public ResourceAdministrativeStateType getAdministrativeState() {
    return administrativeState;
  }

  public void setAdministrativeState(ResourceAdministrativeStateType administrativeState) {
    this.administrativeState = administrativeState;
  }

  public ResourceFVO operationalState(ResourceOperationalStateType operationalState) {
    this.operationalState = operationalState;
    return this;
  }

  /**
   * Get operationalState
   * @return operationalState
  */
  @Valid 
  @Schema(name = "operationalState", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public ResourceOperationalStateType getOperationalState() {
    return operationalState;
  }

  public void setOperationalState(ResourceOperationalStateType operationalState) {
    this.operationalState = operationalState;
  }

  public ResourceFVO resourceStatus(ResourceStatusType resourceStatus) {
    this.resourceStatus = resourceStatus;
    return this;
  }

  /**
   * Get resourceStatus
   * @return resourceStatus
  */
  @Valid 
  @Schema(name = "resourceStatus", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public ResourceStatusType getResourceStatus() {
    return resourceStatus;
  }

  public void setResourceStatus(ResourceStatusType resourceStatus) {
    this.resourceStatus = resourceStatus;
  }

  public ResourceFVO usageState(ResourceUsageStateType usageState) {
    this.usageState = usageState;
    return this;
  }

  /**
   * Get usageState
   * @return usageState
  */
  @Valid 
  @Schema(name = "usageState", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public ResourceUsageStateType getUsageState() {
    return usageState;
  }

  public void setUsageState(ResourceUsageStateType usageState) {
    this.usageState = usageState;
  }

  public ResourceFVO validFor(TimePeriod validFor) {
    this.validFor = validFor;
    return this;
  }

  /**
   * Get validFor
   * @return validFor
  */
  @Valid 
  @Schema(name = "validFor", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public TimePeriod getValidFor() {
    return validFor;
  }

  public void setValidFor(TimePeriod validFor) {
    this.validFor = validFor;
  }

  public ResourceFVO note(List<NoteFVO> note) {
    this.note = note;
    return this;
  }

  public ResourceFVO addNoteItem(NoteFVO noteItem) {
    if (this.note == null) {
      this.note = new ArrayList<>();
    }
    this.note.add(noteItem);
    return this;
  }

  /**
   * Get note
   * @return note
  */
  @Valid 
  @Schema(name = "note", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public List<NoteFVO> getNote() {
    return note;
  }

  public void setNote(List<NoteFVO> note) {
    this.note = note;
  }

  public ResourceFVO resourceOrderItem(List<RelatedResourceOrderItemFVO> resourceOrderItem) {
    this.resourceOrderItem = resourceOrderItem;
    return this;
  }

  public ResourceFVO addResourceOrderItemItem(RelatedResourceOrderItemFVO resourceOrderItemItem) {
    if (this.resourceOrderItem == null) {
      this.resourceOrderItem = new ArrayList<>();
    }
    this.resourceOrderItem.add(resourceOrderItemItem);
    return this;
  }

  /**
   * A list of resource order items related to this resource
   * @return resourceOrderItem
  */
  @Valid 
  @Schema(name = "resourceOrderItem", description = "A list of resource order items related to this resource", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public List<RelatedResourceOrderItemFVO> getResourceOrderItem() {
    return resourceOrderItem;
  }

  public void setResourceOrderItem(List<RelatedResourceOrderItemFVO> resourceOrderItem) {
    this.resourceOrderItem = resourceOrderItem;
  }

  public ResourceFVO place(List<RelatedPlaceRefFVO> place) {
    this.place = place;
    return this;
  }

  public ResourceFVO addPlaceItem(RelatedPlaceRefFVO placeItem) {
    if (this.place == null) {
      this.place = new ArrayList<>();
    }
    this.place.add(placeItem);
    return this;
  }

  /**
   * Get place
   * @return place
  */
  @Valid 
  @Schema(name = "place", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public List<RelatedPlaceRefFVO> getPlace() {
    return place;
  }

  public void setPlace(List<RelatedPlaceRefFVO> place) {
    this.place = place;
  }

  public ResourceFVO relatedParty(List<RelatedPartyRefOrPartyRoleRefFVO> relatedParty) {
    this.relatedParty = relatedParty;
    return this;
  }

  public ResourceFVO addRelatedPartyItem(RelatedPartyRefOrPartyRoleRefFVO relatedPartyItem) {
    if (this.relatedParty == null) {
      this.relatedParty = new ArrayList<>();
    }
    this.relatedParty.add(relatedPartyItem);
    return this;
  }

  /**
   * Get relatedParty
   * @return relatedParty
  */
  @Valid 
  @Schema(name = "relatedParty", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public List<RelatedPartyRefOrPartyRoleRefFVO> getRelatedParty() {
    return relatedParty;
  }

  public void setRelatedParty(List<RelatedPartyRefOrPartyRoleRefFVO> relatedParty) {
    this.relatedParty = relatedParty;
  }

  public ResourceFVO resourceRelationship(List<ResourceRelationshipFVO> resourceRelationship) {
    this.resourceRelationship = resourceRelationship;
    return this;
  }

  public ResourceFVO addResourceRelationshipItem(ResourceRelationshipFVO resourceRelationshipItem) {
    if (this.resourceRelationship == null) {
      this.resourceRelationship = new ArrayList<>();
    }
    this.resourceRelationship.add(resourceRelationshipItem);
    return this;
  }

  /**
   * Get resourceRelationship
   * @return resourceRelationship
  */
  @Valid 
  @Schema(name = "resourceRelationship", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public List<ResourceRelationshipFVO> getResourceRelationship() {
    return resourceRelationship;
  }

  public void setResourceRelationship(List<ResourceRelationshipFVO> resourceRelationship) {
    this.resourceRelationship = resourceRelationship;
  }

  public ResourceFVO resourceCharacteristic(List<CharacteristicFVO> resourceCharacteristic) {
    this.resourceCharacteristic = resourceCharacteristic;
    return this;
  }

  public ResourceFVO addResourceCharacteristicItem(CharacteristicFVO resourceCharacteristicItem) {
    if (this.resourceCharacteristic == null) {
      this.resourceCharacteristic = new ArrayList<>();
    }
    this.resourceCharacteristic.add(resourceCharacteristicItem);
    return this;
  }

  /**
   * Get resourceCharacteristic
   * @return resourceCharacteristic
  */
  @Valid 
  @Schema(name = "resourceCharacteristic", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public List<CharacteristicFVO> getResourceCharacteristic() {
    return resourceCharacteristic;
  }

  public void setResourceCharacteristic(List<CharacteristicFVO> resourceCharacteristic) {
    this.resourceCharacteristic = resourceCharacteristic;
  }

  public ResourceFVO attachment(List<AttachmentRefFVO> attachment) {
    this.attachment = attachment;
    return this;
  }

  public ResourceFVO addAttachmentItem(AttachmentRefFVO attachmentItem) {
    if (this.attachment == null) {
      this.attachment = new ArrayList<>();
    }
    this.attachment.add(attachmentItem);
    return this;
  }

  /**
   * Get attachment
   * @return attachment
  */
  @Valid 
  @Schema(name = "attachment", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public List<AttachmentRefFVO> getAttachment() {
    return attachment;
  }

  public void setAttachment(List<AttachmentRefFVO> attachment) {
    this.attachment = attachment;
  }

  public ResourceFVO resourceSpecification(ResourceSpecificationRefFVO resourceSpecification) {
    this.resourceSpecification = resourceSpecification;
    return this;
  }

  /**
   * Get resourceSpecification
   * @return resourceSpecification
  */
  @Valid 
  @Schema(name = "resourceSpecification", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public ResourceSpecificationRefFVO getResourceSpecification() {
    return resourceSpecification;
  }

  public void setResourceSpecification(ResourceSpecificationRefFVO resourceSpecification) {
    this.resourceSpecification = resourceSpecification;
  }

  public ResourceFVO startOperatingDate(OffsetDateTime startOperatingDate) {
    this.startOperatingDate = startOperatingDate;
    return this;
  }

  /**
   * A date time( DateTime). The date from which the resource is operating
   * @return startOperatingDate
  */
  @Valid 
  @Schema(name = "startOperatingDate", description = "A date time( DateTime). The date from which the resource is operating", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("startOperatingDate")
  public String getStartOperatingDateString() {
    return (startOperatingDate != null) ? startOperatingDate.toString() : null;
  }

  public void setStartOperatingDate(String startOperatingDate) {
    if ( startOperatingDate!= null ) {
      this.startOperatingDate = OffsetDateTime.parse( startOperatingDate );
    }
  }

  public OffsetDateTime getStartOperatingDate() {
    return startOperatingDate;
  }

  public void setStartOperatingDate(OffsetDateTime startOperatingDate) {
    this.startOperatingDate = startOperatingDate;
  }

  public ResourceFVO resourceVersion(String resourceVersion) {
    this.resourceVersion = resourceVersion;
    return this;
  }

  /**
   * A field that identifies the specific version of an instance of a resource.
   * @return resourceVersion
  */
  
  @Schema(name = "resourceVersion", description = "A field that identifies the specific version of an instance of a resource.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public String getResourceVersion() {
    return resourceVersion;
  }

  public void setResourceVersion(String resourceVersion) {
    this.resourceVersion = resourceVersion;
  }

  public ResourceFVO activationFeature(List<FeatureFVO> activationFeature) {
    this.activationFeature = activationFeature;
    return this;
  }

  public ResourceFVO addActivationFeatureItem(FeatureFVO activationFeatureItem) {
    if (this.activationFeature == null) {
      this.activationFeature = new ArrayList<>();
    }
    this.activationFeature.add(activationFeatureItem);
    return this;
  }

  /**
   * Configuration features
   * @return activationFeature
  */
  @Valid 
  @Schema(name = "activationFeature", description = "Configuration features", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public List<FeatureFVO> getActivationFeature() {
    return activationFeature;
  }

  public void setActivationFeature(List<FeatureFVO> activationFeature) {
    this.activationFeature = activationFeature;
  }

  public ResourceFVO intent(IntentRefFVO intent) {
    this.intent = intent;
    return this;
  }

  /**
   * Get intent
   * @return intent
  */
  @Valid 
  @Schema(name = "intent", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public IntentRefFVO getIntent() {
    return intent;
  }

  public void setIntent(IntentRefFVO intent) {
    this.intent = intent;
  }

  public ResourceFVO externalIdentifier(List<ExternalIdentifierFVO> externalIdentifier) {
    this.externalIdentifier = externalIdentifier;
    return this;
  }

  public ResourceFVO addExternalIdentifierItem(ExternalIdentifierFVO externalIdentifierItem) {
    if (this.externalIdentifier == null) {
      this.externalIdentifier = new ArrayList<>();
    }
    this.externalIdentifier.add(externalIdentifierItem);
    return this;
  }

  /**
   * An identification of this resource that is owned by or originates in a software system different from the current system. The structure identifies the system itself, the nature of the resource within the system and the unique ID of the resource within the system. It is anticipated that multiple external IDs can be held for a single resource, e.g. if the resource passed through multiple systems on the way to the current system.
   * @return externalIdentifier
  */
  @Valid 
  @Schema(name = "externalIdentifier", description = "An identification of this resource that is owned by or originates in a software system different from the current system. The structure identifies the system itself, the nature of the resource within the system and the unique ID of the resource within the system. It is anticipated that multiple external IDs can be held for a single resource, e.g. if the resource passed through multiple systems on the way to the current system.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public List<ExternalIdentifierFVO> getExternalIdentifier() {
    return externalIdentifier;
  }

  public void setExternalIdentifier(List<ExternalIdentifierFVO> externalIdentifier) {
    this.externalIdentifier = externalIdentifier;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ResourceFVO resourceFVO = (ResourceFVO) o;
    return Objects.equals(this.type, resourceFVO.type) &&
        Objects.equals(this.baseType, resourceFVO.baseType) &&
        Objects.equals(this.schemaLocation, resourceFVO.schemaLocation) &&
        Objects.equals(this.href, resourceFVO.href) &&
        Objects.equals(this.uuid, resourceFVO.uuid) &&
        Objects.equals(this.category, resourceFVO.category) &&
        Objects.equals(this.description, resourceFVO.description) &&
        Objects.equals(this.name, resourceFVO.name) &&
        Objects.equals(this.endOperatingDate, resourceFVO.endOperatingDate) &&
        Objects.equals(this.administrativeState, resourceFVO.administrativeState) &&
        Objects.equals(this.operationalState, resourceFVO.operationalState) &&
        Objects.equals(this.resourceStatus, resourceFVO.resourceStatus) &&
        Objects.equals(this.usageState, resourceFVO.usageState) &&
        Objects.equals(this.validFor, resourceFVO.validFor) &&
        Objects.equals(this.note, resourceFVO.note) &&
        Objects.equals(this.resourceOrderItem, resourceFVO.resourceOrderItem) &&
        Objects.equals(this.place, resourceFVO.place) &&
        Objects.equals(this.relatedParty, resourceFVO.relatedParty) &&
        Objects.equals(this.resourceRelationship, resourceFVO.resourceRelationship) &&
        Objects.equals(this.resourceCharacteristic, resourceFVO.resourceCharacteristic) &&
        Objects.equals(this.attachment, resourceFVO.attachment) &&
        Objects.equals(this.resourceSpecification, resourceFVO.resourceSpecification) &&
        Objects.equals(this.startOperatingDate, resourceFVO.startOperatingDate) &&
        Objects.equals(this.resourceVersion, resourceFVO.resourceVersion) &&
        Objects.equals(this.activationFeature, resourceFVO.activationFeature) &&
        Objects.equals(this.intent, resourceFVO.intent) &&
        Objects.equals(this.externalIdentifier, resourceFVO.externalIdentifier);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, baseType, schemaLocation, href, uuid, category, description, name, endOperatingDate, administrativeState, operationalState, resourceStatus, usageState, validFor, note, resourceOrderItem, place, relatedParty, resourceRelationship, resourceCharacteristic, attachment, resourceSpecification, startOperatingDate, resourceVersion, activationFeature, intent, externalIdentifier);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ResourceFVO {\n");
    sb.append("    atType: ").append(toIndentedString(type)).append("\n");
    sb.append("    atBaseType: ").append(toIndentedString(baseType)).append("\n");
    sb.append("    atSchemaLocation: ").append(toIndentedString(schemaLocation)).append("\n");
    sb.append("    href: ").append(toIndentedString(href)).append("\n");
    sb.append("    id: ").append(toIndentedString(uuid)).append("\n");
    sb.append("    category: ").append(toIndentedString(category)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    endOperatingDate: ").append(toIndentedString(endOperatingDate)).append("\n");
    sb.append("    administrativeState: ").append(toIndentedString(administrativeState)).append("\n");
    sb.append("    operationalState: ").append(toIndentedString(operationalState)).append("\n");
    sb.append("    resourceStatus: ").append(toIndentedString(resourceStatus)).append("\n");
    sb.append("    usageState: ").append(toIndentedString(usageState)).append("\n");
    sb.append("    validFor: ").append(toIndentedString(validFor)).append("\n");
    sb.append("    note: ").append(toIndentedString(note)).append("\n");
    sb.append("    resourceOrderItem: ").append(toIndentedString(resourceOrderItem)).append("\n");
    sb.append("    place: ").append(toIndentedString(place)).append("\n");
    sb.append("    relatedParty: ").append(toIndentedString(relatedParty)).append("\n");
    sb.append("    resourceRelationship: ").append(toIndentedString(resourceRelationship)).append("\n");
    sb.append("    resourceCharacteristic: ").append(toIndentedString(resourceCharacteristic)).append("\n");
    sb.append("    attachment: ").append(toIndentedString(attachment)).append("\n");
    sb.append("    resourceSpecification: ").append(toIndentedString(resourceSpecification)).append("\n");
    sb.append("    startOperatingDate: ").append(toIndentedString(startOperatingDate)).append("\n");
    sb.append("    resourceVersion: ").append(toIndentedString(resourceVersion)).append("\n");
    sb.append("    activationFeature: ").append(toIndentedString(activationFeature)).append("\n");
    sb.append("    intent: ").append(toIndentedString(intent)).append("\n");
    sb.append("    externalIdentifier: ").append(toIndentedString(externalIdentifier)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

