/*-
 * ========================LICENSE_START=================================
 * org.etsi.osl.tmf.api
 * %%
 * Copyright (C) 2019 openslice.io
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =========================LICENSE_END==================================
 */
package org.etsi.osl.tmf.pcm620.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.etsi.osl.tmf.common.model.BaseEntity;
import org.springframework.validation.annotation.Validated;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;

/**
 * Describes a non-composite relationship between product offering prices. For example one price might be an discount alteration for another price.
 */
@Schema(description = "Describes a non-composite relationship between product offering prices. For example one price might be an discount alteration for another price.")
@Validated
@jakarta.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2019-10-19T00:15:57.249+03:00")

@Entity
public class ProductOfferingPriceRelationship  extends BaseEntity {
  @JsonProperty("id")
  private String id = null;


  @JsonProperty("relationshipType")
  private String relationshipType = null;


  public ProductOfferingPriceRelationship id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Unique identifier of the associated product offering price
   * @return id
  **/
  @Schema(description = "Unique identifier of the associated product offering price")


  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }


  public ProductOfferingPriceRelationship relationshipType(String relationshipType) {
    this.relationshipType = relationshipType;
    return this;
  }

  /**
   * type of the relationship, for example override, discount, etc.
   * @return relationshipType
  **/
  @Schema(description = "type of the relationship, for example override, discount, etc.")


  public String getRelationshipType() {
    return relationshipType;
  }

  public void setRelationshipType(String relationshipType) {
    this.relationshipType = relationshipType;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProductOfferingPriceRelationship productOfferingPriceRelationship = (ProductOfferingPriceRelationship) o;
    return Objects.equals(this.id, productOfferingPriceRelationship.id) &&
        Objects.equals(this.href, productOfferingPriceRelationship.href) &&
        Objects.equals(this.name, productOfferingPriceRelationship.name) &&
        Objects.equals(this.relationshipType, productOfferingPriceRelationship.relationshipType) &&
        Objects.equals(this.baseType, productOfferingPriceRelationship.baseType) &&
        Objects.equals(this.schemaLocation, productOfferingPriceRelationship.schemaLocation) &&
        Objects.equals(this.type, productOfferingPriceRelationship.type);
  }

//  @Override
//  public int hashCode() {
//    return Objects.hash(id, href, name, relationshipType, baseType, schemaLocation, type);
//  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProductOfferingPriceRelationship {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    href: ").append(toIndentedString(href)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    relationshipType: ").append(toIndentedString(relationshipType)).append("\n");
    sb.append("    baseType: ").append(toIndentedString(baseType)).append("\n");
    sb.append("    schemaLocation: ").append(toIndentedString(schemaLocation)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

