package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Size;

import javax.annotation.Generated;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * MeasurementJobMVO
 */

@JsonIgnoreProperties(
  value = "@type", // ignore manually set @type, it will be automatically generated by Jackson during serialization
  allowSetters = true // allows the @type to be set during deserialization
)
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "@type", visible = true)
@JsonSubTypes({
  @JsonSubTypes.Type(value = MeasurementCollectionJobMVO.class, name = "MeasurementCollectionJob")
})

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-05-15T07:30:16.936523289Z[Etc/UTC]", comments = "Generator version: 7.6.0-SNAPSHOT")
public class MeasurementJobMVO extends ManagementJobMVO {

  @JsonProperty("consumingApplicationId")
  private String consumingApplicationId;

  @JsonProperty("producingApplicationId")
  private String producingApplicationId;

  @JsonProperty("granularity")
  private Granularity granularity;

  @JsonProperty("performanceIndicatorGroupSpecification")
  @Valid
  private List<PerformanceIndicatorGroupSpecificationMVO> performanceIndicatorGroupSpecification = new ArrayList<>();

  @JsonProperty("performanceIndicatorSpecification")
  @Valid
  private List<@Valid PerformanceIndicatorSpecificationRefOrValueMVO> performanceIndicatorSpecification = new ArrayList<>();

  @JsonProperty("trackingRecord")
  @Valid
  private List<TrackingRecordMVO> trackingRecord = new ArrayList<>();

  public MeasurementJobMVO() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public MeasurementJobMVO(String atType) {
    super(atType);
  }

  public MeasurementJobMVO consumingApplicationId(String consumingApplicationId) {
    this.consumingApplicationId = consumingApplicationId;
    return this;
  }

  /**
   * The identifier of the application that consumes performance indicators.
   * @return consumingApplicationId
  */
  
  @Schema(name = "consumingApplicationId", description = "The identifier of the application that consumes performance indicators.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("consumingApplicationId")
  public String getConsumingApplicationId() {
    return consumingApplicationId;
  }

  public void setConsumingApplicationId(String consumingApplicationId) {
    this.consumingApplicationId = consumingApplicationId;
  }

  public MeasurementJobMVO producingApplicationId(String producingApplicationId) {
    this.producingApplicationId = producingApplicationId;
    return this;
  }

  /**
   * The identifier of the application that produces performance indicators.
   * @return producingApplicationId
  */
  
  @Schema(name = "producingApplicationId", description = "The identifier of the application that produces performance indicators.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("producingApplicationId")
  public String getProducingApplicationId() {
    return producingApplicationId;
  }

  public void setProducingApplicationId(String producingApplicationId) {
    this.producingApplicationId = producingApplicationId;
  }

  public MeasurementJobMVO granularity(Granularity granularity) {
    this.granularity = granularity;
    return this;
  }

  /**
   * Get granularity
   * @return granularity
  */
  @Valid 
  @Schema(name = "granularity", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("granularity")
  public Granularity getGranularity() {
    return granularity;
  }

  public void setGranularity(Granularity granularity) {
    this.granularity = granularity;
  }

  public MeasurementJobMVO performanceIndicatorGroupSpecification(List<PerformanceIndicatorGroupSpecificationMVO> performanceIndicatorGroupSpecification) {
    this.performanceIndicatorGroupSpecification = performanceIndicatorGroupSpecification;
    return this;
  }

  public MeasurementJobMVO addPerformanceIndicatorGroupSpecificationItem(PerformanceIndicatorGroupSpecificationMVO performanceIndicatorGroupSpecificationItem) {
    if (this.performanceIndicatorGroupSpecification == null) {
      this.performanceIndicatorGroupSpecification = new ArrayList<>();
    }
    this.performanceIndicatorGroupSpecification.add(performanceIndicatorGroupSpecificationItem);
    return this;
  }

  /**
   * Get performanceIndicatorGroupSpecification
   * @return performanceIndicatorGroupSpecification
  */
  @Valid @Size(min = 0) 
  @Schema(name = "performanceIndicatorGroupSpecification", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("performanceIndicatorGroupSpecification")
  public List<PerformanceIndicatorGroupSpecificationMVO> getPerformanceIndicatorGroupSpecification() {
    return performanceIndicatorGroupSpecification;
  }

  public void setPerformanceIndicatorGroupSpecification(List<PerformanceIndicatorGroupSpecificationMVO> performanceIndicatorGroupSpecification) {
    this.performanceIndicatorGroupSpecification = performanceIndicatorGroupSpecification;
  }

  public MeasurementJobMVO performanceIndicatorSpecification(List<@Valid PerformanceIndicatorSpecificationRefOrValueMVO> performanceIndicatorSpecification) {
    this.performanceIndicatorSpecification = performanceIndicatorSpecification;
    return this;
  }

  public MeasurementJobMVO addPerformanceIndicatorSpecificationItem(PerformanceIndicatorSpecificationRefOrValueMVO performanceIndicatorSpecificationItem) {
    if (this.performanceIndicatorSpecification == null) {
      this.performanceIndicatorSpecification = new ArrayList<>();
    }
    this.performanceIndicatorSpecification.add(performanceIndicatorSpecificationItem);
    return this;
  }

  /**
   * Get performanceIndicatorSpecification
   * @return performanceIndicatorSpecification
  */
  @Valid @Size(min = 0) 
  @Schema(name = "performanceIndicatorSpecification", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("performanceIndicatorSpecification")
  public List<@Valid PerformanceIndicatorSpecificationRefOrValueMVO> getPerformanceIndicatorSpecification() {
    return performanceIndicatorSpecification;
  }

  public void setPerformanceIndicatorSpecification(List<@Valid PerformanceIndicatorSpecificationRefOrValueMVO> performanceIndicatorSpecification) {
    this.performanceIndicatorSpecification = performanceIndicatorSpecification;
  }

  public MeasurementJobMVO trackingRecord(List<TrackingRecordMVO> trackingRecord) {
    this.trackingRecord = trackingRecord;
    return this;
  }

  public MeasurementJobMVO addTrackingRecordItem(TrackingRecordMVO trackingRecordItem) {
    if (this.trackingRecord == null) {
      this.trackingRecord = new ArrayList<>();
    }
    this.trackingRecord.add(trackingRecordItem);
    return this;
  }

  /**
   * Get trackingRecord
   * @return trackingRecord
  */
  @Valid @Size(min = 0) 
  @Schema(name = "trackingRecord", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("trackingRecord")
  public List<TrackingRecordMVO> getTrackingRecord() {
    return trackingRecord;
  }

  public void setTrackingRecord(List<TrackingRecordMVO> trackingRecord) {
    this.trackingRecord = trackingRecord;
  }

  public MeasurementJobMVO fileTransferData(List<FileTransferDataMVO> fileTransferData) {
    super.fileTransferData(fileTransferData);
    return this;
  }

  public MeasurementJobMVO addFileTransferDataItem(FileTransferDataMVO fileTransferDataItem) {
    super.addFileTransferDataItem(fileTransferDataItem);
    return this;
  }

  public MeasurementJobMVO dataAccessEndpoint(List<DataAccessEndpointMVO> dataAccessEndpoint) {
    super.dataAccessEndpoint(dataAccessEndpoint);
    return this;
  }

  public MeasurementJobMVO addDataAccessEndpointItem(DataAccessEndpointMVO dataAccessEndpointItem) {
    super.addDataAccessEndpointItem(dataAccessEndpointItem);
    return this;
  }

  public MeasurementJobMVO scheduleDefinition(List<ScheduleDefinitionMVO> scheduleDefinition) {
    super.scheduleDefinition(scheduleDefinition);
    return this;
  }

  public MeasurementJobMVO addScheduleDefinitionItem(ScheduleDefinitionMVO scheduleDefinitionItem) {
    super.addScheduleDefinitionItem(scheduleDefinitionItem);
    return this;
  }
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MeasurementJobMVO measurementJobMVO = (MeasurementJobMVO) o;
    return Objects.equals(this.consumingApplicationId, measurementJobMVO.consumingApplicationId) &&
        Objects.equals(this.producingApplicationId, measurementJobMVO.producingApplicationId) &&
        Objects.equals(this.granularity, measurementJobMVO.granularity) &&
        Objects.equals(this.performanceIndicatorGroupSpecification, measurementJobMVO.performanceIndicatorGroupSpecification) &&
        Objects.equals(this.performanceIndicatorSpecification, measurementJobMVO.performanceIndicatorSpecification) &&
        Objects.equals(this.trackingRecord, measurementJobMVO.trackingRecord) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(consumingApplicationId, producingApplicationId, granularity, performanceIndicatorGroupSpecification, performanceIndicatorSpecification, trackingRecord, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MeasurementJobMVO {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    consumingApplicationId: ").append(toIndentedString(consumingApplicationId)).append("\n");
    sb.append("    producingApplicationId: ").append(toIndentedString(producingApplicationId)).append("\n");
    sb.append("    granularity: ").append(toIndentedString(granularity)).append("\n");
    sb.append("    performanceIndicatorGroupSpecification: ").append(toIndentedString(performanceIndicatorGroupSpecification)).append("\n");
    sb.append("    performanceIndicatorSpecification: ").append(toIndentedString(performanceIndicatorSpecification)).append("\n");
    sb.append("    trackingRecord: ").append(toIndentedString(trackingRecord)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

