/*-
 * ========================LICENSE_START=================================
 * org.etsi.osl.tmf.api
 * %%
 * Copyright (C) 2019 - 2021 openslice.io
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =========================LICENSE_END==================================
 */
package org.etsi.osl.tmf.am642.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.etsi.osl.tmf.common.model.OpensliceEvent;
import org.springframework.validation.annotation.Validated;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;

/**
 * The notification data structure
 */
@Schema(description = "The notification data structure")
@Validated
@jakarta.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.SpringCodegen", date = "2021-02-15T11:15:47.327930400+02:00[Europe/Athens]")
public class AlarmCreateEvent extends OpensliceEvent  {
  

  @JsonProperty("event")
  private AlarmCreateEventPayload event = null;

 

  public AlarmCreateEvent event(AlarmCreateEventPayload event) {
    this.event = event;
    return this;
  }

  /**
   * Get event
   * @return event
  **/
  @Schema(description = "")
  
    @Valid
    public AlarmCreateEventPayload getEvent() {
    return event;
  }

  public void setEvent(AlarmCreateEventPayload event) {
    this.event = event;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AlarmCreateEvent alarmCreateEvent = (AlarmCreateEvent) o;
    return Objects.equals(this.id, alarmCreateEvent.id) &&
        Objects.equals(this.href, alarmCreateEvent.href) &&
        Objects.equals(this.eventId, alarmCreateEvent.eventId) &&
        Objects.equals(this.eventTime, alarmCreateEvent.eventTime) &&
        Objects.equals(this.eventType, alarmCreateEvent.eventType) &&
        Objects.equals(this.correlationId, alarmCreateEvent.correlationId) &&
        Objects.equals(this.domain, alarmCreateEvent.domain) &&
        Objects.equals(this.title, alarmCreateEvent.title) &&
        Objects.equals(this.description, alarmCreateEvent.description) &&
        Objects.equals(this.priority, alarmCreateEvent.priority) &&
        Objects.equals(this.timeOcurred, alarmCreateEvent.timeOcurred) &&
        Objects.equals(this.event, alarmCreateEvent.event);
  }

//  @Override
//  public int hashCode() {
//    return Objects.hash(id, href, eventId, eventTime, eventType, correlationId, domain, title, description, priority, timeOcurred, event);
//  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AlarmCreateEvent {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    href: ").append(toIndentedString(href)).append("\n");
    sb.append("    eventId: ").append(toIndentedString(eventId)).append("\n");
    sb.append("    eventTime: ").append(toIndentedString(eventTime)).append("\n");
    sb.append("    eventType: ").append(toIndentedString(eventType)).append("\n");
    sb.append("    correlationId: ").append(toIndentedString(correlationId)).append("\n");
    sb.append("    domain: ").append(toIndentedString(domain)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
    sb.append("    timeOcurred: ").append(toIndentedString(timeOcurred)).append("\n");
    sb.append("    event: ").append(toIndentedString(event)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
