package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import org.springframework.format.annotation.DateTimeFormat;

import javax.annotation.Generated;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * ManagementJobFVO
 */

@JsonIgnoreProperties(
  value = "@type", // ignore manually set @type, it will be automatically generated by Jackson during serialization
  allowSetters = true // allows the @type to be set during deserialization
)
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "@type", visible = true)
@JsonSubTypes({
  @JsonSubTypes.Type(value = ManagementJobFVO.class, name = "ManagementJob"),
  @JsonSubTypes.Type(value = MeasurementCollectionJobFVO.class, name = "MeasurementCollectionJob"),
  @JsonSubTypes.Type(value = MeasurementJobFVO.class, name = "MeasurementJob")
})

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-05-15T07:30:16.936523289Z[Etc/UTC]", comments = "Generator version: 7.6.0-SNAPSHOT")
public class ManagementJobFVO {

  @JsonProperty("@type")
  private String type;

  @JsonProperty("@baseType")
  private String baseType;

  @JsonProperty("@schemaLocation")
  private String schemaLocation;

  @JsonProperty("href")
  private String href;

  @JsonProperty("uuid")
  private String uuid;

  @JsonProperty("adminState")
  private AdministrativeState adminState;

  @JsonProperty("creationTime")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime creationTime;

  @JsonProperty("executionState")
  private ExecutionStateType executionState;

  @JsonProperty("fileTransferData")
  @Valid
  private List<FileTransferDataFVO> fileTransferData = new ArrayList<>();

  @JsonProperty("dataAccessEndpoint")
  @Valid
  private List<DataAccessEndpointFVO> dataAccessEndpoint = new ArrayList<>();

  @JsonProperty("jobId")
  private String jobId;

  @JsonProperty("jobPriority")
  private Integer jobPriority = 5;

  @JsonProperty("lastModifiedTime")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime lastModifiedTime;

  @JsonProperty("scheduleDefinition")
  @Valid
  private List<ScheduleDefinitionFVO> scheduleDefinition = new ArrayList<>();

  public ManagementJobFVO() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public ManagementJobFVO(String type) {
    this.type = type;
  }

  public ManagementJobFVO type(String type) {
    this.type = type;
    return this;
  }

  /**
   * When sub-classing, this defines the sub-class Extensible name
   * @return atType
  */
  @NotNull 
  @Schema(name = "@type", description = "When sub-classing, this defines the sub-class Extensible name", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("@type")
  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public ManagementJobFVO baseType(String baseType) {
    this.baseType = baseType;
    return this;
  }

  /**
   * When sub-classing, this defines the super-class
   * @return atBaseType
  */
  
  @Schema(name = "@baseType", description = "When sub-classing, this defines the super-class", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("@baseType")
  public String getBaseType() {
    return baseType;
  }

  public void setBaseType(String baseType) {
    this.baseType = baseType;
  }

  public ManagementJobFVO schemaLocation(String schemaLocation) {
    this.schemaLocation = schemaLocation;
    return this;
  }

  /**
   * A URI to a JSON-Schema file that defines additional attributes and relationships
   * @return atSchemaLocation
  */
  
  @Schema(name = "@schemaLocation", description = "A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("@schemaLocation")
  public String getSchemaLocation() {
    return schemaLocation;
  }

  public void setSchemaLocation(String schemaLocation) {
    this.schemaLocation = schemaLocation;
  }

  public ManagementJobFVO href(String href) {
    this.href = href;
    return this;
  }

  /**
   * Hyperlink reference
   * @return href
  */
  
  @Schema(name = "href", description = "Hyperlink reference", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("href")
  public String getHref() {
    return href;
  }

  public void setHref(String href) {
    this.href = href;
  }

  public ManagementJobFVO uuid(String uuid) {
    this.uuid = uuid;
    return this;
  }

  /**
   * unique identifier
   * @return id
  */
  
  @Schema(name = "uuid", description = "unique identifier", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("uuid")
  public String getUuid() {
    return uuid;
  }

  public void setUuid(String uuid) {
    this.uuid = uuid;
  }

  public ManagementJobFVO adminState(AdministrativeState adminState) {
    this.adminState = adminState;
    return this;
  }

  /**
   * Get adminState
   * @return adminState
  */
  @Valid 
  @Schema(name = "adminState", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("adminState")
  public AdministrativeState getAdminState() {
    return adminState;
  }

  public void setAdminState(AdministrativeState adminState) {
    this.adminState = adminState;
  }

  public ManagementJobFVO creationTime(OffsetDateTime creationTime) {
    this.creationTime = creationTime;
    return this;
  }

  /**
   * The measurement job creation time.
   * @return creationTime
  */
  @Valid 
  @Schema(name = "creationTime", description = "The measurement job creation time.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("creationTime")
  public OffsetDateTime getCreationTime() {
    return creationTime;
  }

  public void setCreationTime(OffsetDateTime creationTime) {
    this.creationTime = creationTime;
  }

  public ManagementJobFVO executionState(ExecutionStateType executionState) {
    this.executionState = executionState;
    return this;
  }

  /**
   * Get executionState
   * @return executionState
  */
  @Valid 
  @Schema(name = "executionState", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("executionState")
  public ExecutionStateType getExecutionState() {
    return executionState;
  }

  public void setExecutionState(ExecutionStateType executionState) {
    this.executionState = executionState;
  }

  public ManagementJobFVO fileTransferData(List<FileTransferDataFVO> fileTransferData) {
    this.fileTransferData = fileTransferData;
    return this;
  }

  public ManagementJobFVO addFileTransferDataItem(FileTransferDataFVO fileTransferDataItem) {
    if (this.fileTransferData == null) {
      this.fileTransferData = new ArrayList<>();
    }
    this.fileTransferData.add(fileTransferDataItem);
    return this;
  }

  /**
   * Get fileTransferData
   * @return fileTransferData
  */
  @Valid @Size(min = 0) 
  @Schema(name = "fileTransferData", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("fileTransferData")
  public List<FileTransferDataFVO> getFileTransferData() {
    return fileTransferData;
  }

  public void setFileTransferData(List<FileTransferDataFVO> fileTransferData) {
    this.fileTransferData = fileTransferData;
  }

  public ManagementJobFVO dataAccessEndpoint(List<DataAccessEndpointFVO> dataAccessEndpoint) {
    this.dataAccessEndpoint = dataAccessEndpoint;
    return this;
  }

  public ManagementJobFVO addDataAccessEndpointItem(DataAccessEndpointFVO dataAccessEndpointItem) {
    if (this.dataAccessEndpoint == null) {
      this.dataAccessEndpoint = new ArrayList<>();
    }
    this.dataAccessEndpoint.add(dataAccessEndpointItem);
    return this;
  }

  /**
   * Get dataAccessEndpoint
   * @return dataAccessEndpoint
  */
  @Valid @Size(min = 0) 
  @Schema(name = "dataAccessEndpoint", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("dataAccessEndpoint")
  public List<DataAccessEndpointFVO> getDataAccessEndpoint() {
    return dataAccessEndpoint;
  }

  public void setDataAccessEndpoint(List<DataAccessEndpointFVO> dataAccessEndpoint) {
    this.dataAccessEndpoint = dataAccessEndpoint;
  }

  public ManagementJobFVO jobId(String jobId) {
    this.jobId = jobId;
    return this;
  }

  /**
   * The ID of the management job.
   * @return jobId
  */
  
  @Schema(name = "jobId", description = "The ID of the management job.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("jobId")
  public String getJobId() {
    return jobId;
  }

  public void setJobId(String jobId) {
    this.jobId = jobId;
  }

  public ManagementJobFVO jobPriority(Integer jobPriority) {
    this.jobPriority = jobPriority;
    return this;
  }

  /**
   * The priority of the management job. The way the management application will use the JobPriority to schedule job execution is application specific and outside the scope. Integer, limited to a range of 1 to 10.
   * minimum: 1
   * maximum: 10
   * @return jobPriority
  */
  @Min(1) @Max(10) 
  @Schema(name = "jobPriority", description = "The priority of the management job. The way the management application will use the JobPriority to schedule job execution is application specific and outside the scope. Integer, limited to a range of 1 to 10.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("jobPriority")
  public Integer getJobPriority() {
    return jobPriority;
  }

  public void setJobPriority(Integer jobPriority) {
    this.jobPriority = jobPriority;
  }

  public ManagementJobFVO lastModifiedTime(OffsetDateTime lastModifiedTime) {
    this.lastModifiedTime = lastModifiedTime;
    return this;
  }

  /**
   * The last time that a measurement job was modified.
   * @return lastModifiedTime
  */
  @Valid 
  @Schema(name = "lastModifiedTime", description = "The last time that a measurement job was modified.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("lastModifiedTime")
  public OffsetDateTime getLastModifiedTime() {
    return lastModifiedTime;
  }

  public void setLastModifiedTime(OffsetDateTime lastModifiedTime) {
    this.lastModifiedTime = lastModifiedTime;
  }

  public ManagementJobFVO scheduleDefinition(List<ScheduleDefinitionFVO> scheduleDefinition) {
    this.scheduleDefinition = scheduleDefinition;
    return this;
  }

  public ManagementJobFVO addScheduleDefinitionItem(ScheduleDefinitionFVO scheduleDefinitionItem) {
    if (this.scheduleDefinition == null) {
      this.scheduleDefinition = new ArrayList<>();
    }
    this.scheduleDefinition.add(scheduleDefinitionItem);
    return this;
  }

  /**
   * Get scheduleDefinition
   * @return scheduleDefinition
  */
  @Valid @Size(max = 1) 
  @Schema(name = "scheduleDefinition", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("scheduleDefinition")
  public List<ScheduleDefinitionFVO> getScheduleDefinition() {
    return scheduleDefinition;
  }

  public void setScheduleDefinition(List<ScheduleDefinitionFVO> scheduleDefinition) {
    this.scheduleDefinition = scheduleDefinition;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ManagementJobFVO managementJobFVO = (ManagementJobFVO) o;
    return Objects.equals(this.type, managementJobFVO.type) &&
        Objects.equals(this.baseType, managementJobFVO.baseType) &&
        Objects.equals(this.schemaLocation, managementJobFVO.schemaLocation) &&
        Objects.equals(this.href, managementJobFVO.href) &&
        Objects.equals(this.uuid, managementJobFVO.uuid) &&
        Objects.equals(this.adminState, managementJobFVO.adminState) &&
        Objects.equals(this.creationTime, managementJobFVO.creationTime) &&
        Objects.equals(this.executionState, managementJobFVO.executionState) &&
        Objects.equals(this.fileTransferData, managementJobFVO.fileTransferData) &&
        Objects.equals(this.dataAccessEndpoint, managementJobFVO.dataAccessEndpoint) &&
        Objects.equals(this.jobId, managementJobFVO.jobId) &&
        Objects.equals(this.jobPriority, managementJobFVO.jobPriority) &&
        Objects.equals(this.lastModifiedTime, managementJobFVO.lastModifiedTime) &&
        Objects.equals(this.scheduleDefinition, managementJobFVO.scheduleDefinition);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, baseType, schemaLocation, href, uuid, adminState, creationTime, executionState, fileTransferData, dataAccessEndpoint, jobId, jobPriority, lastModifiedTime, scheduleDefinition);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ManagementJobFVO {\n");
    sb.append("    atType: ").append(toIndentedString(type)).append("\n");
    sb.append("    atBaseType: ").append(toIndentedString(baseType)).append("\n");
    sb.append("    atSchemaLocation: ").append(toIndentedString(schemaLocation)).append("\n");
    sb.append("    href: ").append(toIndentedString(href)).append("\n");
    sb.append("    id: ").append(toIndentedString(uuid)).append("\n");
    sb.append("    adminState: ").append(toIndentedString(adminState)).append("\n");
    sb.append("    creationTime: ").append(toIndentedString(creationTime)).append("\n");
    sb.append("    executionState: ").append(toIndentedString(executionState)).append("\n");
    sb.append("    fileTransferData: ").append(toIndentedString(fileTransferData)).append("\n");
    sb.append("    dataAccessEndpoint: ").append(toIndentedString(dataAccessEndpoint)).append("\n");
    sb.append("    jobId: ").append(toIndentedString(jobId)).append("\n");
    sb.append("    jobPriority: ").append(toIndentedString(jobPriority)).append("\n");
    sb.append("    lastModifiedTime: ").append(toIndentedString(lastModifiedTime)).append("\n");
    sb.append("    scheduleDefinition: ").append(toIndentedString(scheduleDefinition)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

