package org.etsi.osl.tmf.common.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;

import javax.annotation.Generated;
import java.net.URI;
import java.util.Objects;

/**
 * Used when an API throws an Error, typically with a HTTP error response-code (3xx, 4xx, 5xx)
 */

@Schema(name = "Error", description = "Used when an API throws an Error, typically with a HTTP error response-code (3xx, 4xx, 5xx)")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-04-25T11:17:58.147516734Z[Etc/UTC]", comments = "Generator version: 7.6.0-SNAPSHOT")
public class Error {

    private String code;

    private String reason;

    private String message;

    private String status;

    private URI referenceError;

    private String atBaseType;

    private URI atSchemaLocation;

    private String atType;

    public Error() {
        super();
    }

    /**
     * Constructor with only required parameters
     */
    public Error(String code, String reason) {
        this.code = code;
        this.reason = reason;
    }

    public Error code(String code) {
        this.code = code;
        return this;
    }

    /**
     * Application relevant detail, defined in the API or a common list.
     *
     * @return code
     */
    @NotNull
    @Schema(name = "code", description = "Application relevant detail, defined in the API or a common list.", requiredMode = Schema.RequiredMode.REQUIRED)
    @JsonProperty("code")
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Error reason(String reason) {
        this.reason = reason;
        return this;
    }

    /**
     * Explanation of the reason for the error which can be shown to a client user.
     *
     * @return reason
     */
    @NotNull
    @Schema(name = "reason", description = "Explanation of the reason for the error which can be shown to a client user.", requiredMode = Schema.RequiredMode.REQUIRED)
    @JsonProperty("reason")
    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public Error message(String message) {
        this.message = message;
        return this;
    }

    /**
     * More details and corrective actions related to the error which can be shown to a client user.
     *
     * @return message
     */

    @Schema(name = "message", description = "More details and corrective actions related to the error which can be shown to a client user.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty("message")
    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Error status(String status) {
        this.status = status;
        return this;
    }

    /**
     * HTTP Error code extension
     *
     * @return status
     */

    @Schema(name = "status", description = "HTTP Error code extension", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty("status")
    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Error referenceError(URI referenceError) {
        this.referenceError = referenceError;
        return this;
    }

    /**
     * URI of documentation describing the error.
     *
     * @return referenceError
     */
    @Valid
    @Schema(name = "referenceError", description = "URI of documentation describing the error.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty("referenceError")
    public URI getReferenceError() {
        return referenceError;
    }

    public void setReferenceError(URI referenceError) {
        this.referenceError = referenceError;
    }

    public Error atBaseType(String atBaseType) {
        this.atBaseType = atBaseType;
        return this;
    }

    /**
     * When sub-classing, this defines the super-class.
     *
     * @return atBaseType
     */

    @Schema(name = "@baseType", description = "When sub-classing, this defines the super-class.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty("@baseType")
    public String getAtBaseType() {
        return atBaseType;
    }

    public void setAtBaseType(String atBaseType) {
        this.atBaseType = atBaseType;
    }

    public Error atSchemaLocation(URI atSchemaLocation) {
        this.atSchemaLocation = atSchemaLocation;
        return this;
    }

    /**
     * A URI to a JSON-Schema file that defines additional attributes and relationships
     *
     * @return atSchemaLocation
     */
    @Valid
    @Schema(name = "@schemaLocation", description = "A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty("@schemaLocation")
    public URI getAtSchemaLocation() {
        return atSchemaLocation;
    }

    public void setAtSchemaLocation(URI atSchemaLocation) {
        this.atSchemaLocation = atSchemaLocation;
    }

    public Error atType(String atType) {
        this.atType = atType;
        return this;
    }

    /**
     * When sub-classing, this defines the sub-class entity name.
     *
     * @return atType
     */

    @Schema(name = "@type", description = "When sub-classing, this defines the sub-class entity name.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty("@type")
    public String getAtType() {
        return atType;
    }

    public void setAtType(String atType) {
        this.atType = atType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Error error = (Error) o;
        return Objects.equals(this.code, error.code) &&
                Objects.equals(this.reason, error.reason) &&
                Objects.equals(this.message, error.message) &&
                Objects.equals(this.status, error.status) &&
                Objects.equals(this.referenceError, error.referenceError) &&
                Objects.equals(this.atBaseType, error.atBaseType) &&
                Objects.equals(this.atSchemaLocation, error.atSchemaLocation) &&
                Objects.equals(this.atType, error.atType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(code, reason, message, status, referenceError, atBaseType, atSchemaLocation, atType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Error {\n");
        sb.append("    code: ").append(toIndentedString(code)).append("\n");
        sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
        sb.append("    message: ").append(toIndentedString(message)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    referenceError: ").append(toIndentedString(referenceError)).append("\n");
        sb.append("    atBaseType: ").append(toIndentedString(atBaseType)).append("\n");
        sb.append("    atSchemaLocation: ").append(toIndentedString(atSchemaLocation)).append("\n");
        sb.append("    atType: ").append(toIndentedString(atType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

