package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.ri639.model.ResourceAdministrativeStateType;
import org.etsi.osl.tmf.ri639.model.ResourceOperationalStateType;
import org.etsi.osl.tmf.ri639.model.ResourceUsageStateType;
import org.springframework.format.annotation.DateTimeFormat;

import javax.annotation.Generated;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * ResourceMVO
 */

@JsonIgnoreProperties(
  value = "@type", // ignore manually set @type, it will be automatically generated by Jackson during serialization
  allowSetters = true // allows the @type to be set during deserialization
)
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "@type", visible = true)
@JsonSubTypes({
  @JsonSubTypes.Type(value = DataAccessEndpointMVO.class, name = "DataAccessEndpoint"),
  @JsonSubTypes.Type(value = LogicalResourceMVO.class, name = "LogicalResource"),
  @JsonSubTypes.Type(value = ResourceMVO.class, name = "Resource")
})

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-05-15T07:30:16.936523289Z[Etc/UTC]", comments = "Generator version: 7.6.0-SNAPSHOT")
public class ResourceMVO implements ResourceRefOrValueMVO {

  @JsonProperty("@type")
  private String type;

  @JsonProperty("@baseType")
  private String baseType;

  @JsonProperty("@schemaLocation")
  private String schemaLocation;

  @JsonProperty("href")
  private String href;

  @JsonProperty("uuid")
  private String uuid;

  @JsonProperty("category")
  private String category;

  @JsonProperty("description")
  private String description;

  @JsonProperty("name")
  private String name;

  @JsonProperty("endOperatingDate")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime endOperatingDate;

  @JsonProperty("administrativeState")
  private ResourceAdministrativeStateType administrativeState;

  @JsonProperty("operationalState")
  private ResourceOperationalStateType operationalState;

  @JsonProperty("resourceStatus")
  private ResourceStatusType resourceStatus;

  @JsonProperty("usageState")
  private ResourceUsageStateType usageState;

  @JsonProperty("validFor")
  private TimePeriod validFor;

  @JsonProperty("note")
  @Valid
  private List<NoteMVO> note = new ArrayList<>();

  @JsonProperty("resourceOrderItem")
  @Valid
  private List<RelatedResourceOrderItemMVO> resourceOrderItem = new ArrayList<>();

  @JsonProperty("place")
  @Valid
  private List<RelatedPlaceRefMVO> place = new ArrayList<>();

  @JsonProperty("relatedParty")
  @Valid
  private List<RelatedPartyRefOrPartyRoleRefMVO> relatedParty = new ArrayList<>();

  @JsonProperty("resourceRelationship")
  @Valid
  private List<ResourceRelationshipMVO> resourceRelationship = new ArrayList<>();

  @JsonProperty("resourceCharacteristic")
  @Valid
  private List<CharacteristicMVO> resourceCharacteristic = new ArrayList<>();

  @JsonProperty("attachment")
  @Valid
  private List<AttachmentRefMVO> attachment = new ArrayList<>();

  @JsonProperty("resourceSpecification")
  private ResourceSpecificationRefMVO resourceSpecification;

  @JsonProperty("startOperatingDate")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime startOperatingDate;

  @JsonProperty("resourceVersion")
  private String resourceVersion;

  @JsonProperty("activationFeature")
  @Valid
  private List<FeatureMVO> activationFeature = new ArrayList<>();

  @JsonProperty("intent")
  private IntentRefMVO intent;

  @JsonProperty("externalIdentifier")
  @Valid
  private List<ExternalIdentifierMVO> externalIdentifier = new ArrayList<>();

  public ResourceMVO() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public ResourceMVO(String type) {
    this.type = type;
  }

  public ResourceMVO type(String type) {
    this.type = type;
    return this;
  }

  /**
   * When sub-classing, this defines the sub-class Extensible name
   * @return atType
  */
  @NotNull 
  @Schema(name = "@type", description = "When sub-classing, this defines the sub-class Extensible name", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("@type")
  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public ResourceMVO baseType(String baseType) {
    this.baseType = baseType;
    return this;
  }

  /**
   * When sub-classing, this defines the super-class
   * @return atBaseType
  */
  
  @Schema(name = "@baseType", description = "When sub-classing, this defines the super-class", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("@baseType")
  public String getBaseType() {
    return baseType;
  }

  public void setBaseType(String baseType) {
    this.baseType = baseType;
  }

  public ResourceMVO schemaLocation(String schemaLocation) {
    this.schemaLocation = schemaLocation;
    return this;
  }

  /**
   * A URI to a JSON-Schema file that defines additional attributes and relationships
   * @return atSchemaLocation
  */
  
  @Schema(name = "@schemaLocation", description = "A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("@schemaLocation")
  public String getSchemaLocation() {
    return schemaLocation;
  }

  public void setSchemaLocation(String schemaLocation) {
    this.schemaLocation = schemaLocation;
  }

  public ResourceMVO href(String href) {
    this.href = href;
    return this;
  }

  /**
   * Hyperlink reference
   * @return href
  */
  
  @Schema(name = "href", description = "Hyperlink reference", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("href")
  public String getHref() {
    return href;
  }

  public void setHref(String href) {
    this.href = href;
  }

  public ResourceMVO uuid(String uuid) {
    this.uuid = uuid;
    return this;
  }

  /**
   * unique identifier
   * @return id
  */
  
  @Schema(name = "uuid", description = "unique identifier", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("uuid")
  public String getUuid() {
    return uuid;
  }

  public void setUuid(String uuid) {
    this.uuid = uuid;
  }

  public ResourceMVO category(String category) {
    this.category = category;
    return this;
  }

  /**
   * Category of the concrete resource. e.g Gold, Silver for MSISDN concrete resource
   * @return category
  */
  
  @Schema(name = "category", description = "Category of the concrete resource. e.g Gold, Silver for MSISDN concrete resource", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("category")
  public String getCategory() {
    return category;
  }

  public void setCategory(String category) {
    this.category = category;
  }

  public ResourceMVO description(String description) {
    this.description = description;
    return this;
  }

  /**
   * free-text description of the resource
   * @return description
  */
  
  @Schema(name = "description", description = "free-text description of the resource", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public ResourceMVO name(String name) {
    this.name = name;
    return this;
  }

  /**
   * the name of the resource
   * @return name
  */
  
  @Schema(name = "name", description = "the name of the resource", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public ResourceMVO endOperatingDate(OffsetDateTime endOperatingDate) {
    this.endOperatingDate = endOperatingDate;
    return this;
  }

  /**
   * A date time( DateTime). The date till the resource is operating
   * @return endOperatingDate
  */
  @Valid 
  @Schema(name = "endOperatingDate", description = "A date time( DateTime). The date till the resource is operating", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("endOperatingDate")
  public OffsetDateTime getEndOperatingDate() {
    return endOperatingDate;
  }

  public void setEndOperatingDate(OffsetDateTime endOperatingDate) {
    this.endOperatingDate = endOperatingDate;
  }

  public ResourceMVO administrativeState(ResourceAdministrativeStateType administrativeState) {
    this.administrativeState = administrativeState;
    return this;
  }

  /**
   * Get administrativeState
   * @return administrativeState
  */
  @Valid 
  @Schema(name = "administrativeState", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("administrativeState")
  public ResourceAdministrativeStateType getAdministrativeState() {
    return administrativeState;
  }

  public void setAdministrativeState(ResourceAdministrativeStateType administrativeState) {
    this.administrativeState = administrativeState;
  }

  public ResourceMVO operationalState(ResourceOperationalStateType operationalState) {
    this.operationalState = operationalState;
    return this;
  }

  /**
   * Get operationalState
   * @return operationalState
  */
  @Valid 
  @Schema(name = "operationalState", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("operationalState")
  public ResourceOperationalStateType getOperationalState() {
    return operationalState;
  }

  public void setOperationalState(ResourceOperationalStateType operationalState) {
    this.operationalState = operationalState;
  }

  public ResourceMVO resourceStatus(ResourceStatusType resourceStatus) {
    this.resourceStatus = resourceStatus;
    return this;
  }

  /**
   * Get resourceStatus
   * @return resourceStatus
  */
  @Valid 
  @Schema(name = "resourceStatus", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("resourceStatus")
  public ResourceStatusType getResourceStatus() {
    return resourceStatus;
  }

  public void setResourceStatus(ResourceStatusType resourceStatus) {
    this.resourceStatus = resourceStatus;
  }

  public ResourceMVO usageState(ResourceUsageStateType usageState) {
    this.usageState = usageState;
    return this;
  }

  /**
   * Get usageState
   * @return usageState
  */
  @Valid 
  @Schema(name = "usageState", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("usageState")
  public ResourceUsageStateType getUsageState() {
    return usageState;
  }

  public void setUsageState(ResourceUsageStateType usageState) {
    this.usageState = usageState;
  }

  public ResourceMVO validFor(TimePeriod validFor) {
    this.validFor = validFor;
    return this;
  }

  /**
   * Get validFor
   * @return validFor
  */
  @Valid 
  @Schema(name = "validFor", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("validFor")
  public TimePeriod getValidFor() {
    return validFor;
  }

  public void setValidFor(TimePeriod validFor) {
    this.validFor = validFor;
  }

  public ResourceMVO note(List<NoteMVO> note) {
    this.note = note;
    return this;
  }

  public ResourceMVO addNoteItem(NoteMVO noteItem) {
    if (this.note == null) {
      this.note = new ArrayList<>();
    }
    this.note.add(noteItem);
    return this;
  }

  /**
   * Get note
   * @return note
  */
  @Valid 
  @Schema(name = "note", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("note")
  public List<NoteMVO> getNote() {
    return note;
  }

  public void setNote(List<NoteMVO> note) {
    this.note = note;
  }

  public ResourceMVO resourceOrderItem(List<RelatedResourceOrderItemMVO> resourceOrderItem) {
    this.resourceOrderItem = resourceOrderItem;
    return this;
  }

  public ResourceMVO addResourceOrderItemItem(RelatedResourceOrderItemMVO resourceOrderItemItem) {
    if (this.resourceOrderItem == null) {
      this.resourceOrderItem = new ArrayList<>();
    }
    this.resourceOrderItem.add(resourceOrderItemItem);
    return this;
  }

  /**
   * A list of resource order items related to this resource
   * @return resourceOrderItem
  */
  @Valid 
  @Schema(name = "resourceOrderItem", description = "A list of resource order items related to this resource", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("resourceOrderItem")
  public List<RelatedResourceOrderItemMVO> getResourceOrderItem() {
    return resourceOrderItem;
  }

  public void setResourceOrderItem(List<RelatedResourceOrderItemMVO> resourceOrderItem) {
    this.resourceOrderItem = resourceOrderItem;
  }

  public ResourceMVO place(List<RelatedPlaceRefMVO> place) {
    this.place = place;
    return this;
  }

  public ResourceMVO addPlaceItem(RelatedPlaceRefMVO placeItem) {
    if (this.place == null) {
      this.place = new ArrayList<>();
    }
    this.place.add(placeItem);
    return this;
  }

  /**
   * Get place
   * @return place
  */
  @Valid 
  @Schema(name = "place", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("place")
  public List<RelatedPlaceRefMVO> getPlace() {
    return place;
  }

  public void setPlace(List<RelatedPlaceRefMVO> place) {
    this.place = place;
  }

  public ResourceMVO relatedParty(List<RelatedPartyRefOrPartyRoleRefMVO> relatedParty) {
    this.relatedParty = relatedParty;
    return this;
  }

  public ResourceMVO addRelatedPartyItem(RelatedPartyRefOrPartyRoleRefMVO relatedPartyItem) {
    if (this.relatedParty == null) {
      this.relatedParty = new ArrayList<>();
    }
    this.relatedParty.add(relatedPartyItem);
    return this;
  }

  /**
   * Get relatedParty
   * @return relatedParty
  */
  @Valid 
  @Schema(name = "relatedParty", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("relatedParty")
  public List<RelatedPartyRefOrPartyRoleRefMVO> getRelatedParty() {
    return relatedParty;
  }

  public void setRelatedParty(List<RelatedPartyRefOrPartyRoleRefMVO> relatedParty) {
    this.relatedParty = relatedParty;
  }

  public ResourceMVO resourceRelationship(List<ResourceRelationshipMVO> resourceRelationship) {
    this.resourceRelationship = resourceRelationship;
    return this;
  }

  public ResourceMVO addResourceRelationshipItem(ResourceRelationshipMVO resourceRelationshipItem) {
    if (this.resourceRelationship == null) {
      this.resourceRelationship = new ArrayList<>();
    }
    this.resourceRelationship.add(resourceRelationshipItem);
    return this;
  }

  /**
   * Get resourceRelationship
   * @return resourceRelationship
  */
  @Valid 
  @Schema(name = "resourceRelationship", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("resourceRelationship")
  public List<ResourceRelationshipMVO> getResourceRelationship() {
    return resourceRelationship;
  }

  public void setResourceRelationship(List<ResourceRelationshipMVO> resourceRelationship) {
    this.resourceRelationship = resourceRelationship;
  }

  public ResourceMVO resourceCharacteristic(List<CharacteristicMVO> resourceCharacteristic) {
    this.resourceCharacteristic = resourceCharacteristic;
    return this;
  }

  public ResourceMVO addResourceCharacteristicItem(CharacteristicMVO resourceCharacteristicItem) {
    if (this.resourceCharacteristic == null) {
      this.resourceCharacteristic = new ArrayList<>();
    }
    this.resourceCharacteristic.add(resourceCharacteristicItem);
    return this;
  }

  /**
   * Get resourceCharacteristic
   * @return resourceCharacteristic
  */
  @Valid 
  @Schema(name = "resourceCharacteristic", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("resourceCharacteristic")
  public List<CharacteristicMVO> getResourceCharacteristic() {
    return resourceCharacteristic;
  }

  public void setResourceCharacteristic(List<CharacteristicMVO> resourceCharacteristic) {
    this.resourceCharacteristic = resourceCharacteristic;
  }

  public ResourceMVO attachment(List<AttachmentRefMVO> attachment) {
    this.attachment = attachment;
    return this;
  }

  public ResourceMVO addAttachmentItem(AttachmentRefMVO attachmentItem) {
    if (this.attachment == null) {
      this.attachment = new ArrayList<>();
    }
    this.attachment.add(attachmentItem);
    return this;
  }

  /**
   * Get attachment
   * @return attachment
  */
  @Valid 
  @Schema(name = "attachment", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("attachment")
  public List<AttachmentRefMVO> getAttachment() {
    return attachment;
  }

  public void setAttachment(List<AttachmentRefMVO> attachment) {
    this.attachment = attachment;
  }

  public ResourceMVO resourceSpecification(ResourceSpecificationRefMVO resourceSpecification) {
    this.resourceSpecification = resourceSpecification;
    return this;
  }

  /**
   * Get resourceSpecification
   * @return resourceSpecification
  */
  @Valid 
  @Schema(name = "resourceSpecification", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("resourceSpecification")
  public ResourceSpecificationRefMVO getResourceSpecification() {
    return resourceSpecification;
  }

  public void setResourceSpecification(ResourceSpecificationRefMVO resourceSpecification) {
    this.resourceSpecification = resourceSpecification;
  }

  public ResourceMVO startOperatingDate(OffsetDateTime startOperatingDate) {
    this.startOperatingDate = startOperatingDate;
    return this;
  }

  /**
   * A date time( DateTime). The date from which the resource is operating
   * @return startOperatingDate
  */
  @Valid 
  @Schema(name = "startOperatingDate", description = "A date time( DateTime). The date from which the resource is operating", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("startOperatingDate")
  public OffsetDateTime getStartOperatingDate() {
    return startOperatingDate;
  }

  public void setStartOperatingDate(OffsetDateTime startOperatingDate) {
    this.startOperatingDate = startOperatingDate;
  }

  public ResourceMVO resourceVersion(String resourceVersion) {
    this.resourceVersion = resourceVersion;
    return this;
  }

  /**
   * A field that identifies the specific version of an instance of a resource.
   * @return resourceVersion
  */
  
  @Schema(name = "resourceVersion", description = "A field that identifies the specific version of an instance of a resource.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("resourceVersion")
  public String getResourceVersion() {
    return resourceVersion;
  }

  public void setResourceVersion(String resourceVersion) {
    this.resourceVersion = resourceVersion;
  }

  public ResourceMVO activationFeature(List<FeatureMVO> activationFeature) {
    this.activationFeature = activationFeature;
    return this;
  }

  public ResourceMVO addActivationFeatureItem(FeatureMVO activationFeatureItem) {
    if (this.activationFeature == null) {
      this.activationFeature = new ArrayList<>();
    }
    this.activationFeature.add(activationFeatureItem);
    return this;
  }

  /**
   * Configuration features
   * @return activationFeature
  */
  @Valid 
  @Schema(name = "activationFeature", description = "Configuration features", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("activationFeature")
  public List<FeatureMVO> getActivationFeature() {
    return activationFeature;
  }

  public void setActivationFeature(List<FeatureMVO> activationFeature) {
    this.activationFeature = activationFeature;
  }

  public ResourceMVO intent(IntentRefMVO intent) {
    this.intent = intent;
    return this;
  }

  /**
   * Get intent
   * @return intent
  */
  @Valid 
  @Schema(name = "intent", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("intent")
  public IntentRefMVO getIntent() {
    return intent;
  }

  public void setIntent(IntentRefMVO intent) {
    this.intent = intent;
  }

  public ResourceMVO externalIdentifier(List<ExternalIdentifierMVO> externalIdentifier) {
    this.externalIdentifier = externalIdentifier;
    return this;
  }

  public ResourceMVO addExternalIdentifierItem(ExternalIdentifierMVO externalIdentifierItem) {
    if (this.externalIdentifier == null) {
      this.externalIdentifier = new ArrayList<>();
    }
    this.externalIdentifier.add(externalIdentifierItem);
    return this;
  }

  /**
   * An identification of this resource that is owned by or originates in a software system different from the current system. The structure identifies the system itself, the nature of the resource within the system and the unique ID of the resource within the system. It is anticipated that multiple external IDs can be held for a single resource, e.g. if the resource passed through multiple systems on the way to the current system.
   * @return externalIdentifier
  */
  @Valid 
  @Schema(name = "externalIdentifier", description = "An identification of this resource that is owned by or originates in a software system different from the current system. The structure identifies the system itself, the nature of the resource within the system and the unique ID of the resource within the system. It is anticipated that multiple external IDs can be held for a single resource, e.g. if the resource passed through multiple systems on the way to the current system.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("externalIdentifier")
  public List<ExternalIdentifierMVO> getExternalIdentifier() {
    return externalIdentifier;
  }

  public void setExternalIdentifier(List<ExternalIdentifierMVO> externalIdentifier) {
    this.externalIdentifier = externalIdentifier;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ResourceMVO resourceMVO = (ResourceMVO) o;
    return Objects.equals(this.type, resourceMVO.type) &&
        Objects.equals(this.baseType, resourceMVO.baseType) &&
        Objects.equals(this.schemaLocation, resourceMVO.schemaLocation) &&
        Objects.equals(this.href, resourceMVO.href) &&
        Objects.equals(this.uuid, resourceMVO.uuid) &&
        Objects.equals(this.category, resourceMVO.category) &&
        Objects.equals(this.description, resourceMVO.description) &&
        Objects.equals(this.name, resourceMVO.name) &&
        Objects.equals(this.endOperatingDate, resourceMVO.endOperatingDate) &&
        Objects.equals(this.administrativeState, resourceMVO.administrativeState) &&
        Objects.equals(this.operationalState, resourceMVO.operationalState) &&
        Objects.equals(this.resourceStatus, resourceMVO.resourceStatus) &&
        Objects.equals(this.usageState, resourceMVO.usageState) &&
        Objects.equals(this.validFor, resourceMVO.validFor) &&
        Objects.equals(this.note, resourceMVO.note) &&
        Objects.equals(this.resourceOrderItem, resourceMVO.resourceOrderItem) &&
        Objects.equals(this.place, resourceMVO.place) &&
        Objects.equals(this.relatedParty, resourceMVO.relatedParty) &&
        Objects.equals(this.resourceRelationship, resourceMVO.resourceRelationship) &&
        Objects.equals(this.resourceCharacteristic, resourceMVO.resourceCharacteristic) &&
        Objects.equals(this.attachment, resourceMVO.attachment) &&
        Objects.equals(this.resourceSpecification, resourceMVO.resourceSpecification) &&
        Objects.equals(this.startOperatingDate, resourceMVO.startOperatingDate) &&
        Objects.equals(this.resourceVersion, resourceMVO.resourceVersion) &&
        Objects.equals(this.activationFeature, resourceMVO.activationFeature) &&
        Objects.equals(this.intent, resourceMVO.intent) &&
        Objects.equals(this.externalIdentifier, resourceMVO.externalIdentifier);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, baseType, schemaLocation, href, uuid, category, description, name, endOperatingDate, administrativeState, operationalState, resourceStatus, usageState, validFor, note, resourceOrderItem, place, relatedParty, resourceRelationship, resourceCharacteristic, attachment, resourceSpecification, startOperatingDate, resourceVersion, activationFeature, intent, externalIdentifier);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ResourceMVO {\n");
    sb.append("    atType: ").append(toIndentedString(type)).append("\n");
    sb.append("    atBaseType: ").append(toIndentedString(baseType)).append("\n");
    sb.append("    atSchemaLocation: ").append(toIndentedString(schemaLocation)).append("\n");
    sb.append("    href: ").append(toIndentedString(href)).append("\n");
    sb.append("    id: ").append(toIndentedString(uuid)).append("\n");
    sb.append("    category: ").append(toIndentedString(category)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    endOperatingDate: ").append(toIndentedString(endOperatingDate)).append("\n");
    sb.append("    administrativeState: ").append(toIndentedString(administrativeState)).append("\n");
    sb.append("    operationalState: ").append(toIndentedString(operationalState)).append("\n");
    sb.append("    resourceStatus: ").append(toIndentedString(resourceStatus)).append("\n");
    sb.append("    usageState: ").append(toIndentedString(usageState)).append("\n");
    sb.append("    validFor: ").append(toIndentedString(validFor)).append("\n");
    sb.append("    note: ").append(toIndentedString(note)).append("\n");
    sb.append("    resourceOrderItem: ").append(toIndentedString(resourceOrderItem)).append("\n");
    sb.append("    place: ").append(toIndentedString(place)).append("\n");
    sb.append("    relatedParty: ").append(toIndentedString(relatedParty)).append("\n");
    sb.append("    resourceRelationship: ").append(toIndentedString(resourceRelationship)).append("\n");
    sb.append("    resourceCharacteristic: ").append(toIndentedString(resourceCharacteristic)).append("\n");
    sb.append("    attachment: ").append(toIndentedString(attachment)).append("\n");
    sb.append("    resourceSpecification: ").append(toIndentedString(resourceSpecification)).append("\n");
    sb.append("    startOperatingDate: ").append(toIndentedString(startOperatingDate)).append("\n");
    sb.append("    resourceVersion: ").append(toIndentedString(resourceVersion)).append("\n");
    sb.append("    activationFeature: ").append(toIndentedString(activationFeature)).append("\n");
    sb.append("    intent: ").append(toIndentedString(intent)).append("\n");
    sb.append("    externalIdentifier: ").append(toIndentedString(externalIdentifier)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

