package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import org.etsi.osl.tmf.common.model.TimePeriod;

import javax.annotation.Generated;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * PerformanceMeasurement
 */

@JsonIgnoreProperties(
  value = "@type", // ignore manually set @type, it will be automatically generated by Jackson during serialization
  allowSetters = true // allows the @type to be set during deserialization
)
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "@type", visible = true)
@JsonSubTypes({
  @JsonSubTypes.Type(value = PerformanceMeasurement.class, name = "PerformanceMeasurement"),
  @JsonSubTypes.Type(value = PerformanceMeasurementAtomic.class, name = "PerformanceMeasurementAtomic"),
  @JsonSubTypes.Type(value = PerformanceMeasurementGroup.class, name = "PerformanceMeasurementGroup")
})

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-05-15T07:30:16.936523289Z[Etc/UTC]", comments = "Generator version: 7.6.0-SNAPSHOT")
public class PerformanceMeasurement implements PerformanceMeasurementRefOrValue {

  private String atType;

  private String atBaseType;

  private String atSchemaLocation;

  private String href;

  private String id;

  private String description;

  private MeasurementCollectionJobRef measurementCollectionJob;

  private TimePeriod validFor;

  @Valid
  private List<PerformanceMeasurementRelationship> relatedMeasurement = new ArrayList<>();

  private Object tag;

  public PerformanceMeasurement() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public PerformanceMeasurement(String atType) {
    this.atType = atType;
  }

  public PerformanceMeasurement atType(String atType) {
    this.atType = atType;
    return this;
  }

  /**
   * When sub-classing, this defines the sub-class Extensible name
   * @return atType
  */
  @NotNull 
  @Schema(name = "@type", description = "When sub-classing, this defines the sub-class Extensible name", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("@type")
  public String getAtType() {
    return atType;
  }

  public void setAtType(String atType) {
    this.atType = atType;
  }

  public PerformanceMeasurement atBaseType(String atBaseType) {
    this.atBaseType = atBaseType;
    return this;
  }

  /**
   * When sub-classing, this defines the super-class
   * @return atBaseType
  */
  
  @Schema(name = "@baseType", description = "When sub-classing, this defines the super-class", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("@baseType")
  public String getAtBaseType() {
    return atBaseType;
  }

  public void setAtBaseType(String atBaseType) {
    this.atBaseType = atBaseType;
  }

  public PerformanceMeasurement atSchemaLocation(String atSchemaLocation) {
    this.atSchemaLocation = atSchemaLocation;
    return this;
  }

  /**
   * A URI to a JSON-Schema file that defines additional attributes and relationships
   * @return atSchemaLocation
  */
  
  @Schema(name = "@schemaLocation", description = "A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("@schemaLocation")
  public String getAtSchemaLocation() {
    return atSchemaLocation;
  }

  public void setAtSchemaLocation(String atSchemaLocation) {
    this.atSchemaLocation = atSchemaLocation;
  }

  public PerformanceMeasurement href(String href) {
    this.href = href;
    return this;
  }

  /**
   * Hyperlink reference
   * @return href
  */
  
  @Schema(name = "href", description = "Hyperlink reference", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("href")
  public String getHref() {
    return href;
  }

  public void setHref(String href) {
    this.href = href;
  }

  public PerformanceMeasurement id(String id) {
    this.id = id;
    return this;
  }

  /**
   * unique identifier
   * @return id
  */
  
  @Schema(name = "id", description = "unique identifier", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("id")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public PerformanceMeasurement description(String description) {
    this.description = description;
    return this;
  }

  /**
   * A free-text description of the performance measurement
   * @return description
  */
  
  @Schema(name = "description", description = "A free-text description of the performance measurement", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public PerformanceMeasurement measurementCollectionJob(MeasurementCollectionJobRef measurementCollectionJob) {
    this.measurementCollectionJob = measurementCollectionJob;
    return this;
  }

  /**
   * Get measurementCollectionJob
   * @return measurementCollectionJob
  */
  @Valid 
  @Schema(name = "measurementCollectionJob", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("measurementCollectionJob")
  public MeasurementCollectionJobRef getMeasurementCollectionJob() {
    return measurementCollectionJob;
  }

  public void setMeasurementCollectionJob(MeasurementCollectionJobRef measurementCollectionJob) {
    this.measurementCollectionJob = measurementCollectionJob;
  }

  public PerformanceMeasurement validFor(TimePeriod validFor) {
    this.validFor = validFor;
    return this;
  }

  /**
   * Get validFor
   * @return validFor
  */
  @Valid 
  @Schema(name = "validFor", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("validFor")
  public TimePeriod getValidFor() {
    return validFor;
  }

  public void setValidFor(TimePeriod validFor) {
    this.validFor = validFor;
  }

  public PerformanceMeasurement relatedMeasurement(List<PerformanceMeasurementRelationship> relatedMeasurement) {
    this.relatedMeasurement = relatedMeasurement;
    return this;
  }

  public PerformanceMeasurement addRelatedMeasurementItem(PerformanceMeasurementRelationship relatedMeasurementItem) {
    if (this.relatedMeasurement == null) {
      this.relatedMeasurement = new ArrayList<>();
    }
    this.relatedMeasurement.add(relatedMeasurementItem);
    return this;
  }

  /**
   * related Performance measurements array
   * @return relatedMeasurement
  */
  @Valid @Size(min = 0) 
  @Schema(name = "relatedMeasurement", description = "related Performance measurements array", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("relatedMeasurement")
  public List<PerformanceMeasurementRelationship> getRelatedMeasurement() {
    return relatedMeasurement;
  }

  public void setRelatedMeasurement(List<PerformanceMeasurementRelationship> relatedMeasurement) {
    this.relatedMeasurement = relatedMeasurement;
  }

  public PerformanceMeasurement tag(Object tag) {
    this.tag = tag;
    return this;
  }

  /**
   * The optional tag object attached to this entire measurement
   * @return tag
  */
  
  @Schema(name = "tag", description = "The optional tag object attached to this entire measurement", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tag")
  public Object getTag() {
    return tag;
  }

  public void setTag(Object tag) {
    this.tag = tag;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PerformanceMeasurement performanceMeasurement = (PerformanceMeasurement) o;
    return Objects.equals(this.atType, performanceMeasurement.atType) &&
        Objects.equals(this.atBaseType, performanceMeasurement.atBaseType) &&
        Objects.equals(this.atSchemaLocation, performanceMeasurement.atSchemaLocation) &&
        Objects.equals(this.href, performanceMeasurement.href) &&
        Objects.equals(this.id, performanceMeasurement.id) &&
        Objects.equals(this.description, performanceMeasurement.description) &&
        Objects.equals(this.measurementCollectionJob, performanceMeasurement.measurementCollectionJob) &&
        Objects.equals(this.validFor, performanceMeasurement.validFor) &&
        Objects.equals(this.relatedMeasurement, performanceMeasurement.relatedMeasurement) &&
        Objects.equals(this.tag, performanceMeasurement.tag);
  }

  @Override
  public int hashCode() {
    return Objects.hash(atType, atBaseType, atSchemaLocation, href, id, description, measurementCollectionJob, validFor, relatedMeasurement, tag);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PerformanceMeasurement {\n");
    sb.append("    atType: ").append(toIndentedString(atType)).append("\n");
    sb.append("    atBaseType: ").append(toIndentedString(atBaseType)).append("\n");
    sb.append("    atSchemaLocation: ").append(toIndentedString(atSchemaLocation)).append("\n");
    sb.append("    href: ").append(toIndentedString(href)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    measurementCollectionJob: ").append(toIndentedString(measurementCollectionJob)).append("\n");
    sb.append("    validFor: ").append(toIndentedString(validFor)).append("\n");
    sb.append("    relatedMeasurement: ").append(toIndentedString(relatedMeasurement)).append("\n");
    sb.append("    tag: ").append(toIndentedString(tag)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

