/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.domain.model.kubernetes;

import java.util.HashMap;
import java.util.Map;
import org.etsi.osl.domain.model.DomainModelDefinition;
import org.etsi.osl.domain.model.ITMFRCM634_ModelTransformer;
import org.etsi.osl.domain.model.ITMFRI639_ModelTransformer;
import org.etsi.osl.tmf.common.model.ELifecycle;
import org.etsi.osl.tmf.common.model.EValueType;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecification;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationCreate;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationRef;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationUpdate;
import org.etsi.osl.tmf.ri639.model.ResourceCreate;
import org.etsi.osl.tmf.ri639.model.ResourceOperationalStateType;
import org.etsi.osl.tmf.ri639.model.ResourceStatusType;
import org.etsi.osl.tmf.ri639.model.ResourceUpdate;

public class KubernetesConfigMap
extends DomainModelDefinition
implements ITMFRCM634_ModelTransformer,
ITMFRI639_ModelTransformer {
    public static final String OSL_KUBCMAP_RSPEC_NAME = "kubernetes-configmap.openslice.io";
    public static final String OSL_KUBCMAP_RSPEC_VERSION = "0.0.1";
    public static final String OSL_KUBCMAP_RSPEC_CATEGORY = "ConfigMap/Kubernetes/v1";
    public static final String OSL_KUBCMAP_RESOURCE_CATEGORY = "ConfigMap/Kubernetes/v1";
    public static final String OSL_KUBCMAP_RSPEC_TYPE = "LogicalResourceSpecification";
    public static final String OSL_KUBCMAP_RSPEC_DESCRIPTION = "This Specification is used to describe a generic Kubernetes Service";
    private String osl_KUBCRD_RSPEC_UUID = null;
    private String clusterMasterURL;
    private String currentContextCluster;
    private String fullResourceName;
    private String kind;
    private String apiGroup;
    private String UID;
    private String metadata;
    private String yaml;
    private String json;
    private String namespace;
    private Map<String, String> data;
    private String dataObj;
    private Map<String, String> properties;

    public KubernetesConfigMap(String osl_KUBCRD_RSPEC_UUID, String uuid, String name, String version, String description, String category, String clusterMasterURL, String currentContextCluster, String fullResourceName, String namespace, String kind, String apiGroup, String uID, String metadata, String yaml, String json) {
        super(uuid, name, version, description, category);
        this.osl_KUBCRD_RSPEC_UUID = osl_KUBCRD_RSPEC_UUID;
        this.clusterMasterURL = clusterMasterURL;
        this.currentContextCluster = currentContextCluster;
        this.fullResourceName = fullResourceName;
        this.kind = kind;
        this.apiGroup = apiGroup;
        this.namespace = namespace;
        this.UID = uID;
        this.metadata = metadata;
        this.yaml = yaml;
        this.json = json;
        this.properties = new HashMap<String, String>();
        this.data = new HashMap<String, String>();
        this.category = "ConfigMap/Kubernetes/v1";
    }

    public ResourceSpecificationCreate toRSpecCreate_InitRepo() {
        ResourceSpecificationCreate rsc = this.toRSpecCreate();
        rsc.setName(OSL_KUBCMAP_RSPEC_NAME);
        rsc.setCategory("ConfigMap/Kubernetes/v1");
        rsc.setVersion(OSL_KUBCMAP_RSPEC_VERSION);
        rsc.setDescription(OSL_KUBCMAP_RSPEC_DESCRIPTION);
        rsc.setType(OSL_KUBCMAP_RSPEC_TYPE);
        return rsc;
    }

    public ResourceSpecificationCreate toRSpecCreate() {
        ResourceSpecificationCreate rsc = new ResourceSpecificationCreate();
        rsc.setName(this.name);
        rsc.setCategory("ConfigMap/Kubernetes/v1");
        rsc.setVersion(this.version);
        rsc.setDescription(this.version);
        rsc.setType(OSL_KUBCMAP_RSPEC_TYPE);
        rsc.setLifecycleStatus(ELifecycle.ACTIVE.getValue());
        rsc.addResourceSpecificationCharacteristicItemShort("clusterMasterURL", this.clusterMasterURL, EValueType.TEXT.getValue(), "URL of cluster", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("currentContextCluster", this.currentContextCluster, EValueType.TEXT.getValue(), "", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("fullResourceName", this.fullResourceName, EValueType.TEXT.getValue(), "", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("Kind", this.kind, EValueType.TEXT.getValue(), "", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("apiGroup", this.apiGroup, EValueType.TEXT.getValue(), "", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("UID", this.UID, EValueType.TEXT.getValue(), "", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("metadata", this.metadata, EValueType.OBJECT.getValue(), "", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("json", this.json, EValueType.TEXT.getValue(), "", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("data", this.dataObj, EValueType.OBJECT.getValue(), "", Boolean.valueOf(false));
        if (this.properties != null) {
            this.properties.forEach((kPropName, vProVal) -> {
                EValueType etype = EValueType.TEXT;
                rsc.addResourceSpecificationCharacteristicItemShort(kPropName, vProVal, etype.getValue(), "", Boolean.valueOf(false));
            });
        }
        if (this.data != null) {
            this.data.forEach((kPropName, vProVal) -> {
                EValueType etype = EValueType.TEXT;
                rsc.addResourceSpecificationCharacteristicItemShort(kPropName, vProVal, etype.getValue(), "", Boolean.valueOf(false));
            });
        }
        return rsc;
    }

    public ResourceSpecificationUpdate toRSpecUpdate() {
        return this.toRSpecCreate();
    }

    public KubernetesConfigMap fromRSpec(ResourceSpecification rSpec) {
        this.osl_KUBCRD_RSPEC_UUID = rSpec.getUuid();
        return this;
    }

    public ResourceCreate toResourceCreate() {
        if (this.osl_KUBCRD_RSPEC_UUID == null) {
            return null;
        }
        ResourceSpecificationRef rSpecRef = new ResourceSpecificationRef();
        rSpecRef.setId(this.osl_KUBCRD_RSPEC_UUID);
        rSpecRef.setName(OSL_KUBCMAP_RSPEC_NAME);
        rSpecRef.setVersion(OSL_KUBCMAP_RSPEC_VERSION);
        ResourceCreate rs = new ResourceCreate();
        rs.name(this.name).category("ConfigMap/Kubernetes/v1").description(this.description).resourceStatus(ResourceStatusType.AVAILABLE).operationalState(ResourceOperationalStateType.ENABLE).resourceSpecification(rSpecRef).resourceVersion(this.version);
        Object cprefix = "";
        if (this.name.indexOf(64) > 0) {
            String firstToken = this.name.substring(0, this.name.indexOf(64));
            cprefix = this.kind + "." + firstToken + ".";
        }
        rs.addResourceCharacteristicItemShort("clusterMasterURL", this.clusterMasterURL, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("currentContextCluster", this.currentContextCluster, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("fullResourceName", this.fullResourceName, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("Kind", this.kind, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("apiGroup", this.apiGroup, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("UID", this.UID, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("metadata", this.metadata, EValueType.OBJECT.getValue());
        rs.addResourceCharacteristicItemShort("json", this.json, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("data", this.dataObj, EValueType.OBJECT.getValue());
        if (this.properties != null) {
            this.properties.forEach((kPropName, vProVal) -> {
                EValueType etype = EValueType.TEXT;
                rs.addResourceCharacteristicItemShort(kPropName, vProVal, etype.getValue());
            });
        }
        if (this.data != null) {
            this.data.forEach((kPropName, vProVal) -> {
                EValueType etype = EValueType.TEXT;
                rs.addResourceCharacteristicItemShort(kPropName, vProVal, etype.getValue());
            });
        }
        return rs;
    }

    public ResourceUpdate toResourceUpdate() {
        return this.toResourceCreate();
    }

    public static KubernetesConfigMapBuilder builder() {
        return new KubernetesConfigMapBuilder();
    }

    public String getOsl_KUBCRD_RSPEC_UUID() {
        return this.osl_KUBCRD_RSPEC_UUID;
    }

    public String getClusterMasterURL() {
        return this.clusterMasterURL;
    }

    public String getCurrentContextCluster() {
        return this.currentContextCluster;
    }

    public String getFullResourceName() {
        return this.fullResourceName;
    }

    public String getKind() {
        return this.kind;
    }

    public String getApiGroup() {
        return this.apiGroup;
    }

    public String getUID() {
        return this.UID;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public String getYaml() {
        return this.yaml;
    }

    public String getJson() {
        return this.json;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public String getDataObj() {
        return this.dataObj;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setOsl_KUBCRD_RSPEC_UUID(String osl_KUBCRD_RSPEC_UUID) {
        this.osl_KUBCRD_RSPEC_UUID = osl_KUBCRD_RSPEC_UUID;
    }

    public void setClusterMasterURL(String clusterMasterURL) {
        this.clusterMasterURL = clusterMasterURL;
    }

    public void setCurrentContextCluster(String currentContextCluster) {
        this.currentContextCluster = currentContextCluster;
    }

    public void setFullResourceName(String fullResourceName) {
        this.fullResourceName = fullResourceName;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public void setApiGroup(String apiGroup) {
        this.apiGroup = apiGroup;
    }

    public void setUID(String UID) {
        this.UID = UID;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public void setYaml(String yaml) {
        this.yaml = yaml;
    }

    public void setJson(String json) {
        this.json = json;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setData(Map<String, String> data) {
        this.data = data;
    }

    public void setDataObj(String dataObj) {
        this.dataObj = dataObj;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public static class KubernetesConfigMapBuilder {
        private String osl_KUBCRD_RSPEC_UUID;
        private String uuid;
        private String name;
        private String version;
        private String description;
        private String category;
        private String clusterMasterURL;
        private String currentContextCluster;
        private String fullResourceName;
        private String namespace;
        private String kind;
        private String apiGroup;
        private String uID;
        private String metadata;
        private String yaml;
        private String json;

        KubernetesConfigMapBuilder() {
        }

        public KubernetesConfigMapBuilder osl_KUBCRD_RSPEC_UUID(String osl_KUBCRD_RSPEC_UUID) {
            this.osl_KUBCRD_RSPEC_UUID = osl_KUBCRD_RSPEC_UUID;
            return this;
        }

        public KubernetesConfigMapBuilder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public KubernetesConfigMapBuilder name(String name) {
            this.name = name;
            return this;
        }

        public KubernetesConfigMapBuilder version(String version) {
            this.version = version;
            return this;
        }

        public KubernetesConfigMapBuilder description(String description) {
            this.description = description;
            return this;
        }

        public KubernetesConfigMapBuilder category(String category) {
            this.category = category;
            return this;
        }

        public KubernetesConfigMapBuilder clusterMasterURL(String clusterMasterURL) {
            this.clusterMasterURL = clusterMasterURL;
            return this;
        }

        public KubernetesConfigMapBuilder currentContextCluster(String currentContextCluster) {
            this.currentContextCluster = currentContextCluster;
            return this;
        }

        public KubernetesConfigMapBuilder fullResourceName(String fullResourceName) {
            this.fullResourceName = fullResourceName;
            return this;
        }

        public KubernetesConfigMapBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public KubernetesConfigMapBuilder kind(String kind) {
            this.kind = kind;
            return this;
        }

        public KubernetesConfigMapBuilder apiGroup(String apiGroup) {
            this.apiGroup = apiGroup;
            return this;
        }

        public KubernetesConfigMapBuilder uID(String uID) {
            this.uID = uID;
            return this;
        }

        public KubernetesConfigMapBuilder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public KubernetesConfigMapBuilder yaml(String yaml) {
            this.yaml = yaml;
            return this;
        }

        public KubernetesConfigMapBuilder json(String json) {
            this.json = json;
            return this;
        }

        public KubernetesConfigMap build() {
            return new KubernetesConfigMap(this.osl_KUBCRD_RSPEC_UUID, this.uuid, this.name, this.version, this.description, this.category, this.clusterMasterURL, this.currentContextCluster, this.fullResourceName, this.namespace, this.kind, this.apiGroup, this.uID, this.metadata, this.yaml, this.json);
        }

        public String toString() {
            return "KubernetesConfigMap.KubernetesConfigMapBuilder(osl_KUBCRD_RSPEC_UUID=" + this.osl_KUBCRD_RSPEC_UUID + ", uuid=" + this.uuid + ", name=" + this.name + ", version=" + this.version + ", description=" + this.description + ", category=" + this.category + ", clusterMasterURL=" + this.clusterMasterURL + ", currentContextCluster=" + this.currentContextCluster + ", fullResourceName=" + this.fullResourceName + ", namespace=" + this.namespace + ", kind=" + this.kind + ", apiGroup=" + this.apiGroup + ", uID=" + this.uID + ", metadata=" + this.metadata + ", yaml=" + this.yaml + ", json=" + this.json + ")";
        }
    }
}

