/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.domain.model.kubernetes;

import java.util.HashMap;
import java.util.Map;
import org.etsi.osl.domain.model.DomainModelDefinition;
import org.etsi.osl.domain.model.ITMFRCM634_ModelTransformer;
import org.etsi.osl.domain.model.ITMFRI639_ModelTransformer;
import org.etsi.osl.tmf.common.model.ELifecycle;
import org.etsi.osl.tmf.common.model.EValueType;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecification;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationCreate;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationRef;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationUpdate;
import org.etsi.osl.tmf.ri639.model.ResourceCreate;
import org.etsi.osl.tmf.ri639.model.ResourceOperationalStateType;
import org.etsi.osl.tmf.ri639.model.ResourceStatusType;
import org.etsi.osl.tmf.ri639.model.ResourceUpdate;

public class KubernetesCRV1
extends DomainModelDefinition
implements ITMFRCM634_ModelTransformer,
ITMFRI639_ModelTransformer {
    public static final String OSL_KUBCRV1_RSPEC_NAME = "kubernetes-cr-v1.openslice.io";
    public static final String OSL_KUBCRV1_RSPEC_VERSION = "0.0.4";
    public static final String OSL_KUBCRV1_RSPEC_CATEGORY = "KubernetesCRV1-apiextensions.k8s.io/v1";
    public static final String OSL_KUBCRV1_RSPEC_TYPE = "LogicalResourceSpecification";
    public static final String OSL_KUBCRV1_RSPEC_DESCRIPTION = "This Specification is used to describe a generic KubernetesCRV1";
    private String osl_KUBCRV1_RSPEC_UUID = null;
    private String clusterMasterURL;
    private String currentContextCluster;
    private String fullResourceName;
    private String kind;
    private String apiGroup;
    private String namespace;
    private String UID;
    private String metadata;
    private String yaml;
    private String json;
    private Map<String, String> properties;
    private Map<String, String> additionalProperties;
    private String cr_spec_applied;
    private String statusCheckFieldName;
    private String statusCheckValueStandby;
    private String statusCheckValueAlarm;
    private String statusCheckValueAvailable;
    private String statusCheckValueReserved;
    private String statusCheckValueUnknown;
    private String statusCheckValueSuspended;
    private ResourceStatusType statusValue;

    public KubernetesCRV1(String osl_KUBCRV1_RSPEC_UUID, String uuid, String name, String version, String description, String category, String clusterMasterURL, String currentContextCluster, String fullResourceName, String namespace, String kind, String apiGroup, String uID, String metadata, ResourceStatusType statusValue, String yaml, String json) {
        super(uuid, name, version, description, category);
        this.osl_KUBCRV1_RSPEC_UUID = osl_KUBCRV1_RSPEC_UUID;
        this.clusterMasterURL = clusterMasterURL;
        this.currentContextCluster = currentContextCluster;
        this.fullResourceName = fullResourceName;
        this.kind = kind;
        this.apiGroup = apiGroup;
        this.namespace = namespace;
        this.UID = uID;
        this.metadata = metadata;
        this.yaml = yaml;
        this.json = json;
        this.statusValue = statusValue;
        this.properties = new HashMap<String, String>();
        this.additionalProperties = new HashMap<String, String>();
    }

    public ResourceSpecificationCreate toRSpecCreate_InitRepo() {
        ResourceSpecificationCreate rsc = this.toRSpecCreate();
        rsc.setName(OSL_KUBCRV1_RSPEC_NAME);
        rsc.setCategory(OSL_KUBCRV1_RSPEC_CATEGORY);
        rsc.setVersion(OSL_KUBCRV1_RSPEC_VERSION);
        rsc.setDescription(OSL_KUBCRV1_RSPEC_DESCRIPTION);
        rsc.setType(OSL_KUBCRV1_RSPEC_TYPE);
        return rsc;
    }

    public ResourceSpecificationCreate toRSpecCreate() {
        ResourceSpecificationCreate rsc = new ResourceSpecificationCreate();
        rsc.setName(this.name);
        rsc.setCategory(OSL_KUBCRV1_RSPEC_CATEGORY);
        rsc.setVersion(this.version);
        rsc.setDescription(this.description);
        rsc.setType(OSL_KUBCRV1_RSPEC_TYPE);
        rsc.setLifecycleStatus(ELifecycle.ACTIVE.getValue());
        rsc.addResourceSpecificationCharacteristicItemShort("clusterMasterURL", "", EValueType.TEXT.getValue(), "", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("currentContextCluster", "", EValueType.TEXT.getValue(), "", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("fullResourceName", "", EValueType.TEXT.getValue(), "", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("Kind", "", EValueType.TEXT.getValue(), "", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("apiGroup", "", EValueType.TEXT.getValue(), "", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("UID", "", EValueType.TEXT.getValue(), "", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("namespace", "", EValueType.TEXT.getValue(), "", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("metadata", "", EValueType.TEXT.getValue(), "", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("json", "", EValueType.TEXT.getValue(), "", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("_CR_SPEC", "", EValueType.TEXT.getValue(), "Used for providing the json Custom Resource description to apply", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("_CR_SPEC_LASTSEND", "", EValueType.TEXT.getValue(), "Used for providing the last description send", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("_CR_SPEC_APPLIED", "", EValueType.TEXT.getValue(), "Used for providing the json Custom Resource description as applied by Kubernetes", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("_CR_CHECK_FIELD", "", EValueType.TEXT.getValue(), "Used for providing the field that need to be checked for the resource status", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("_CR_CHECKVAL_STANDBY", "", EValueType.TEXT.getValue(), "Used for providing the equivalent value from resource to signal the standby status", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("_CR_CHECKVAL_ALARM", "", EValueType.TEXT.getValue(), "Used for providing the equivalent value from resource to signal the alarm status", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("_CR_CHECKVAL_AVAILABLE", "", EValueType.TEXT.getValue(), "Used for providing the equivalent value from resource to signal the available status", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("_CR_CHECKVAL_RESERVED", "", EValueType.TEXT.getValue(), "Used for providing the equivalent value from resource to signal the reserved status", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("_CR_CHECKVAL_UNKNOWN", "", EValueType.TEXT.getValue(), "Used for providing the equivalent value from resource to signal the unknown status", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("_CR_CHECKVAL_SUSPENDED", "", EValueType.TEXT.getValue(), "Used for providing the equivalent value from resource to signal the suspended status", Boolean.valueOf(false));
        return rsc;
    }

    public ResourceSpecificationUpdate toRSpecUpdate() {
        return this.toRSpecCreate();
    }

    public KubernetesCRV1 fromRSpec(ResourceSpecification rSpec) {
        this.osl_KUBCRV1_RSPEC_UUID = rSpec.getUuid();
        return this;
    }

    public ResourceCreate toResourceCreate() {
        if (this.osl_KUBCRV1_RSPEC_UUID == null) {
            return null;
        }
        ResourceSpecificationRef rSpecRef = new ResourceSpecificationRef();
        rSpecRef.setId(this.osl_KUBCRV1_RSPEC_UUID);
        rSpecRef.setName(OSL_KUBCRV1_RSPEC_NAME);
        rSpecRef.setVersion(OSL_KUBCRV1_RSPEC_VERSION);
        ResourceCreate rs = new ResourceCreate();
        rs.name(this.name).category(this.category).description(this.description).resourceStatus(ResourceStatusType.RESERVED).operationalState(ResourceOperationalStateType.ENABLE).resourceSpecification(rSpecRef).resourceVersion(this.version);
        rs.addResourceCharacteristicItemShort("clusterMasterURL", this.clusterMasterURL, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("currentContextCluster", this.currentContextCluster, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("fullResourceName", this.fullResourceName, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("Kind", this.kind, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("apiGroup", this.apiGroup, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("apiVersion", this.version, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("UID", this.UID, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("namespace", this.namespace, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("metadata", this.metadata, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("json", this.json, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("_CR_SPEC_APPLIED", this.cr_spec_applied, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("_CR_CHECK_FIELD", this.statusCheckFieldName, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("_CR_CHECKVAL_STANDBY", this.statusCheckValueStandby, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("_CR_CHECKVAL_ALARM", this.statusCheckValueAlarm, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("_CR_CHECKVAL_AVAILABLE", this.statusCheckValueAvailable, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("_CR_CHECKVAL_RESERVED", this.statusCheckValueReserved, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("_CR_CHECKVAL_UNKNOWN", this.statusCheckValueUnknown, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("_CR_CHECKVAL_SUSPENDED", this.statusCheckValueSuspended, EValueType.TEXT.getValue());
        rs.resourceStatus(this.statusValue);
        if (this.properties != null) {
            this.properties.forEach((kPropName, vProVal) -> rs.addResourceCharacteristicItemShort(kPropName, vProVal, EValueType.TEXT.getValue()));
        }
        if (this.additionalProperties != null) {
            this.additionalProperties.forEach((kPropName, vProVal) -> rs.addResourceCharacteristicItemShort(kPropName, vProVal, EValueType.TEXT.getValue()));
        }
        return rs;
    }

    public ResourceUpdate toResourceUpdate() {
        return this.toResourceCreate();
    }

    public static KubernetesCRV1Builder builder() {
        return new KubernetesCRV1Builder();
    }

    public String getOsl_KUBCRV1_RSPEC_UUID() {
        return this.osl_KUBCRV1_RSPEC_UUID;
    }

    public String getClusterMasterURL() {
        return this.clusterMasterURL;
    }

    public String getCurrentContextCluster() {
        return this.currentContextCluster;
    }

    public String getFullResourceName() {
        return this.fullResourceName;
    }

    public String getKind() {
        return this.kind;
    }

    public String getApiGroup() {
        return this.apiGroup;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUID() {
        return this.UID;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public String getYaml() {
        return this.yaml;
    }

    public String getJson() {
        return this.json;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Map<String, String> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getCr_spec_applied() {
        return this.cr_spec_applied;
    }

    public String getStatusCheckFieldName() {
        return this.statusCheckFieldName;
    }

    public String getStatusCheckValueStandby() {
        return this.statusCheckValueStandby;
    }

    public String getStatusCheckValueAlarm() {
        return this.statusCheckValueAlarm;
    }

    public String getStatusCheckValueAvailable() {
        return this.statusCheckValueAvailable;
    }

    public String getStatusCheckValueReserved() {
        return this.statusCheckValueReserved;
    }

    public String getStatusCheckValueUnknown() {
        return this.statusCheckValueUnknown;
    }

    public String getStatusCheckValueSuspended() {
        return this.statusCheckValueSuspended;
    }

    public ResourceStatusType getStatusValue() {
        return this.statusValue;
    }

    public void setOsl_KUBCRV1_RSPEC_UUID(String osl_KUBCRV1_RSPEC_UUID) {
        this.osl_KUBCRV1_RSPEC_UUID = osl_KUBCRV1_RSPEC_UUID;
    }

    public void setClusterMasterURL(String clusterMasterURL) {
        this.clusterMasterURL = clusterMasterURL;
    }

    public void setCurrentContextCluster(String currentContextCluster) {
        this.currentContextCluster = currentContextCluster;
    }

    public void setFullResourceName(String fullResourceName) {
        this.fullResourceName = fullResourceName;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public void setApiGroup(String apiGroup) {
        this.apiGroup = apiGroup;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUID(String UID) {
        this.UID = UID;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public void setYaml(String yaml) {
        this.yaml = yaml;
    }

    public void setJson(String json) {
        this.json = json;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void setAdditionalProperties(Map<String, String> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public void setCr_spec_applied(String cr_spec_applied) {
        this.cr_spec_applied = cr_spec_applied;
    }

    public void setStatusCheckFieldName(String statusCheckFieldName) {
        this.statusCheckFieldName = statusCheckFieldName;
    }

    public void setStatusCheckValueStandby(String statusCheckValueStandby) {
        this.statusCheckValueStandby = statusCheckValueStandby;
    }

    public void setStatusCheckValueAlarm(String statusCheckValueAlarm) {
        this.statusCheckValueAlarm = statusCheckValueAlarm;
    }

    public void setStatusCheckValueAvailable(String statusCheckValueAvailable) {
        this.statusCheckValueAvailable = statusCheckValueAvailable;
    }

    public void setStatusCheckValueReserved(String statusCheckValueReserved) {
        this.statusCheckValueReserved = statusCheckValueReserved;
    }

    public void setStatusCheckValueUnknown(String statusCheckValueUnknown) {
        this.statusCheckValueUnknown = statusCheckValueUnknown;
    }

    public void setStatusCheckValueSuspended(String statusCheckValueSuspended) {
        this.statusCheckValueSuspended = statusCheckValueSuspended;
    }

    public void setStatusValue(ResourceStatusType statusValue) {
        this.statusValue = statusValue;
    }

    public static class KubernetesCRV1Builder {
        private String osl_KUBCRV1_RSPEC_UUID;
        private String uuid;
        private String name;
        private String version;
        private String description;
        private String category;
        private String clusterMasterURL;
        private String currentContextCluster;
        private String fullResourceName;
        private String namespace;
        private String kind;
        private String apiGroup;
        private String uID;
        private String metadata;
        private ResourceStatusType statusValue;
        private String yaml;
        private String json;

        KubernetesCRV1Builder() {
        }

        public KubernetesCRV1Builder osl_KUBCRV1_RSPEC_UUID(String osl_KUBCRV1_RSPEC_UUID) {
            this.osl_KUBCRV1_RSPEC_UUID = osl_KUBCRV1_RSPEC_UUID;
            return this;
        }

        public KubernetesCRV1Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public KubernetesCRV1Builder name(String name) {
            this.name = name;
            return this;
        }

        public KubernetesCRV1Builder version(String version) {
            this.version = version;
            return this;
        }

        public KubernetesCRV1Builder description(String description) {
            this.description = description;
            return this;
        }

        public KubernetesCRV1Builder category(String category) {
            this.category = category;
            return this;
        }

        public KubernetesCRV1Builder clusterMasterURL(String clusterMasterURL) {
            this.clusterMasterURL = clusterMasterURL;
            return this;
        }

        public KubernetesCRV1Builder currentContextCluster(String currentContextCluster) {
            this.currentContextCluster = currentContextCluster;
            return this;
        }

        public KubernetesCRV1Builder fullResourceName(String fullResourceName) {
            this.fullResourceName = fullResourceName;
            return this;
        }

        public KubernetesCRV1Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public KubernetesCRV1Builder kind(String kind) {
            this.kind = kind;
            return this;
        }

        public KubernetesCRV1Builder apiGroup(String apiGroup) {
            this.apiGroup = apiGroup;
            return this;
        }

        public KubernetesCRV1Builder uID(String uID) {
            this.uID = uID;
            return this;
        }

        public KubernetesCRV1Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public KubernetesCRV1Builder statusValue(ResourceStatusType statusValue) {
            this.statusValue = statusValue;
            return this;
        }

        public KubernetesCRV1Builder yaml(String yaml) {
            this.yaml = yaml;
            return this;
        }

        public KubernetesCRV1Builder json(String json) {
            this.json = json;
            return this;
        }

        public KubernetesCRV1 build() {
            return new KubernetesCRV1(this.osl_KUBCRV1_RSPEC_UUID, this.uuid, this.name, this.version, this.description, this.category, this.clusterMasterURL, this.currentContextCluster, this.fullResourceName, this.namespace, this.kind, this.apiGroup, this.uID, this.metadata, this.statusValue, this.yaml, this.json);
        }

        public String toString() {
            return "KubernetesCRV1.KubernetesCRV1Builder(osl_KUBCRV1_RSPEC_UUID=" + this.osl_KUBCRV1_RSPEC_UUID + ", uuid=" + this.uuid + ", name=" + this.name + ", version=" + this.version + ", description=" + this.description + ", category=" + this.category + ", clusterMasterURL=" + this.clusterMasterURL + ", currentContextCluster=" + this.currentContextCluster + ", fullResourceName=" + this.fullResourceName + ", namespace=" + this.namespace + ", kind=" + this.kind + ", apiGroup=" + this.apiGroup + ", uID=" + this.uID + ", metadata=" + this.metadata + ", statusValue=" + String.valueOf(this.statusValue) + ", yaml=" + this.yaml + ", json=" + this.json + ")";
        }
    }
}

