/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.domain.model.kubernetes;

import java.util.HashMap;
import java.util.Map;
import org.etsi.osl.domain.model.DomainModelDefinition;
import org.etsi.osl.domain.model.ITMFRCM634_ModelTransformer;
import org.etsi.osl.domain.model.ITMFRI639_ModelTransformer;
import org.etsi.osl.domain.model.kubernetes.KubernetesCRDProperty;
import org.etsi.osl.tmf.common.model.ELifecycle;
import org.etsi.osl.tmf.common.model.EValueType;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecification;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationCreate;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationRef;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationUpdate;
import org.etsi.osl.tmf.ri639.model.ResourceCreate;
import org.etsi.osl.tmf.ri639.model.ResourceOperationalStateType;
import org.etsi.osl.tmf.ri639.model.ResourceStatusType;
import org.etsi.osl.tmf.ri639.model.ResourceUpdate;

public class KubernetesCRDV1
extends DomainModelDefinition
implements ITMFRCM634_ModelTransformer,
ITMFRI639_ModelTransformer {
    public static final String OSL_KUBCRD_RSPEC_NAME = "kubernetes-crd.openslice.io";
    public static final String OSL_KUBCRD_RSPEC_VERSION = "0.0.3";
    public static final String OSL_KUBCRD_RSPEC_CATEGORY = "KubernetesCRD-apiextensions.k8s.io/v1";
    public static final String OSL_KUBCRD_RESOURCE_CATEGORY = "KubernetesCRD-apiextensions.k8s.io/v1";
    public static final String OSL_KUBCRD_RSPEC_TYPE = "LogicalResourceSpecification";
    public static final String OSL_KUBCRD_RSPEC_DESCRIPTION = "This Specification is used to describe a generic KubernetesCRD";
    private String osl_KUBCRD_RSPEC_UUID = null;
    private String clusterMasterURL;
    private String currentContextCluster;
    private String fullResourceName;
    private String kind;
    private String apiGroup;
    private String UID;
    private String metadata;
    private String yaml;
    private String json;
    private Map<String, KubernetesCRDProperty> properties;
    private Map<String, KubernetesCRDProperty> additionalProperties;
    private String cr_spec;
    private String statusCheckFieldName;
    private String statusCheckValueStandby;
    private String statusCheckValueAlarm;
    private String statusCheckValueAvailable;
    private String statusCheckValueReserved;
    private String statusCheckValueUnknown;
    private String statusCheckValueSuspended;

    public KubernetesCRDV1(String osl_KUBCRD_RSPEC_UUID, String uuid, String name, String version, String description, String category, String clusterMasterURL, String currentContextCluster, String fullResourceName, String kind, String apiGroup, String uID, String metadata, String yaml, String json) {
        super(uuid, name, version, description, category);
        this.osl_KUBCRD_RSPEC_UUID = osl_KUBCRD_RSPEC_UUID;
        this.clusterMasterURL = clusterMasterURL;
        this.currentContextCluster = currentContextCluster;
        this.fullResourceName = fullResourceName;
        this.kind = kind;
        this.apiGroup = apiGroup;
        this.UID = uID;
        this.metadata = metadata;
        this.yaml = yaml;
        this.json = json;
        this.properties = new HashMap<String, KubernetesCRDProperty>();
        this.additionalProperties = new HashMap<String, KubernetesCRDProperty>();
    }

    public ResourceSpecificationCreate toRSpecCreate_InitRepo() {
        ResourceSpecificationCreate rsc = this.toRSpecCreate();
        rsc.setName(OSL_KUBCRD_RSPEC_NAME);
        rsc.setCategory("KubernetesCRD-apiextensions.k8s.io/v1");
        rsc.setVersion(OSL_KUBCRD_RSPEC_VERSION);
        rsc.setDescription(OSL_KUBCRD_RSPEC_DESCRIPTION);
        rsc.setType(OSL_KUBCRD_RSPEC_TYPE);
        return rsc;
    }

    public ResourceSpecificationCreate toRSpecCreate() {
        ResourceSpecificationCreate rsc = new ResourceSpecificationCreate();
        rsc.setName(this.name);
        rsc.setCategory("KubernetesCRD-apiextensions.k8s.io/v1");
        rsc.setVersion(this.version);
        rsc.setDescription(this.version);
        rsc.setType(OSL_KUBCRD_RSPEC_TYPE);
        rsc.setLifecycleStatus(ELifecycle.ACTIVE.getValue());
        rsc.addResourceSpecificationCharacteristicItemShort("clusterMasterURL", this.clusterMasterURL, EValueType.TEXT.getValue(), "URL of cluster", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("currentContextCluster", this.currentContextCluster, EValueType.TEXT.getValue(), "", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("fullResourceName", this.fullResourceName, EValueType.TEXT.getValue(), "", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("Kind", this.kind, EValueType.TEXT.getValue(), "", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("apiGroup", this.apiGroup, EValueType.TEXT.getValue(), "", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("UID", this.UID, EValueType.TEXT.getValue(), "", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("metadata", this.metadata, EValueType.TEXT.getValue(), "", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("yaml", this.yaml, EValueType.TEXT.getValue(), "", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("json", this.json, EValueType.TEXT.getValue(), "", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("_CR_SPEC", "", EValueType.TEXT.getValue(), "Used for providing the json Custom Resource description to apply", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("_CR_SPEC_LASTSEND", "", EValueType.TEXT.getValue(), "Used for providing the last description send", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("_CR_SPEC_APPLIED", "", EValueType.TEXT.getValue(), "Used for providing the json Custom Resource description as applied by Kubernetes", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("_CR_CHECK_FIELD", "", EValueType.TEXT.getValue(), "Used for providing the field that need to be checked for the resource status", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("_CR_CHECKVAL_STANDBY", "", EValueType.TEXT.getValue(), "Used for providing the equivalent value from resource to signal the standby status", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("_CR_CHECKVAL_ALARM", "", EValueType.TEXT.getValue(), "Used for providing the equivalent value from resource to signal the alarm status", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("_CR_CHECKVAL_AVAILABLE", "", EValueType.TEXT.getValue(), "Used for providing the equivalent value from resource to signal the available status", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("_CR_CHECKVAL_RESERVED", "", EValueType.TEXT.getValue(), "Used for providing the equivalent value from resource to signal the reserved status", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("_CR_CHECKVAL_UNKNOWN", "", EValueType.TEXT.getValue(), "Used for providing the equivalent value from resource to signal the unknown status", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("_CR_CHECKVAL_SUSPENDED", "", EValueType.TEXT.getValue(), "Used for providing the equivalent value from resource to signal the suspended status", Boolean.valueOf(false));
        if (this.properties != null) {
            this.properties.forEach((kPropName, vProVal) -> {
                EValueType etype = vProVal.getValueType().equalsIgnoreCase("boolean") ? EValueType.BOOLEAN : (vProVal.getValueType().equalsIgnoreCase("integer") ? EValueType.INTEGER : (vProVal.getValueType().equalsIgnoreCase("object") ? EValueType.OBJECT : EValueType.TEXT));
                rsc.addResourceSpecificationCharacteristicItemShort(kPropName, vProVal.getDefaultValue(), etype.getValue(), vProVal.getDescription(), Boolean.valueOf(false));
            });
        }
        if (this.additionalProperties != null) {
            this.additionalProperties.forEach((kPropName, vProVal) -> rsc.addResourceSpecificationCharacteristicItemShort("additionalProperty." + kPropName, vProVal.getDefaultValue(), EValueType.TEXT.getValue(), vProVal.getDescription(), Boolean.valueOf(false)));
        }
        return rsc;
    }

    public ResourceSpecificationUpdate toRSpecUpdate() {
        return this.toRSpecCreate();
    }

    public KubernetesCRDV1 fromRSpec(ResourceSpecification rSpec) {
        this.osl_KUBCRD_RSPEC_UUID = rSpec.getUuid();
        return this;
    }

    public ResourceCreate toResourceCreate() {
        if (this.osl_KUBCRD_RSPEC_UUID == null) {
            return null;
        }
        ResourceSpecificationRef rSpecRef = new ResourceSpecificationRef();
        rSpecRef.setId(this.osl_KUBCRD_RSPEC_UUID);
        rSpecRef.setName(OSL_KUBCRD_RSPEC_NAME);
        rSpecRef.setVersion(OSL_KUBCRD_RSPEC_VERSION);
        ResourceCreate rs = new ResourceCreate();
        rs.name(this.name).category("KubernetesCRD-apiextensions.k8s.io/v1").description(this.description).resourceStatus(ResourceStatusType.AVAILABLE).operationalState(ResourceOperationalStateType.ENABLE).resourceSpecification(rSpecRef).resourceVersion(this.version);
        rs.addResourceCharacteristicItemShort("clusterMasterURL", this.clusterMasterURL, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("currentContextCluster", this.currentContextCluster, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("fullResourceName", this.fullResourceName, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("Kind", this.kind, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("apiGroup", this.apiGroup, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("UID", this.UID, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("metadata", this.metadata, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("yaml", this.yaml, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("json", this.json, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("_CR_SPEC", this.cr_spec, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("_CR_SPEC_LASTSEND", this.cr_spec, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("_CR_SPEC_APPLIED", "", EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("_CR_CHECK_FIELD", this.statusCheckFieldName, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("_CR_CHECKVAL_STANDBY", this.statusCheckValueStandby, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("_CR_CHECKVAL_ALARM", this.statusCheckValueAlarm, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("_CR_CHECKVAL_AVAILABLE", this.statusCheckValueAvailable, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("_CR_CHECKVAL_RESERVED", this.statusCheckValueReserved, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("_CR_CHECKVAL_UNKNOWN", this.statusCheckValueUnknown, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("_CR_CHECKVAL_SUSPENDED", this.statusCheckValueSuspended, EValueType.TEXT.getValue());
        if (this.properties != null) {
            this.properties.forEach((kPropName, vProVal) -> {
                EValueType etype = vProVal.getValueType().equalsIgnoreCase("boolean") ? EValueType.BOOLEAN : (vProVal.getValueType().equalsIgnoreCase("integer") ? EValueType.INTEGER : (vProVal.getValueType().equalsIgnoreCase("object") ? EValueType.OBJECT : EValueType.TEXT));
                rs.addResourceCharacteristicItemShort(kPropName, "", etype.getValue());
            });
        }
        if (this.additionalProperties != null) {
            this.additionalProperties.forEach((kPropName, vProVal) -> rs.addResourceCharacteristicItemShort("additionalProperty." + kPropName, "", EValueType.TEXT.getValue()));
        }
        return rs;
    }

    public ResourceUpdate toResourceUpdate() {
        return this.toResourceCreate();
    }

    public static KubernetesCRDV1Builder builder() {
        return new KubernetesCRDV1Builder();
    }

    public String getOsl_KUBCRD_RSPEC_UUID() {
        return this.osl_KUBCRD_RSPEC_UUID;
    }

    public String getClusterMasterURL() {
        return this.clusterMasterURL;
    }

    public String getCurrentContextCluster() {
        return this.currentContextCluster;
    }

    public String getFullResourceName() {
        return this.fullResourceName;
    }

    public String getKind() {
        return this.kind;
    }

    public String getApiGroup() {
        return this.apiGroup;
    }

    public String getUID() {
        return this.UID;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public String getYaml() {
        return this.yaml;
    }

    public String getJson() {
        return this.json;
    }

    public Map<String, KubernetesCRDProperty> getProperties() {
        return this.properties;
    }

    public Map<String, KubernetesCRDProperty> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getCr_spec() {
        return this.cr_spec;
    }

    public String getStatusCheckFieldName() {
        return this.statusCheckFieldName;
    }

    public String getStatusCheckValueStandby() {
        return this.statusCheckValueStandby;
    }

    public String getStatusCheckValueAlarm() {
        return this.statusCheckValueAlarm;
    }

    public String getStatusCheckValueAvailable() {
        return this.statusCheckValueAvailable;
    }

    public String getStatusCheckValueReserved() {
        return this.statusCheckValueReserved;
    }

    public String getStatusCheckValueUnknown() {
        return this.statusCheckValueUnknown;
    }

    public String getStatusCheckValueSuspended() {
        return this.statusCheckValueSuspended;
    }

    public void setOsl_KUBCRD_RSPEC_UUID(String osl_KUBCRD_RSPEC_UUID) {
        this.osl_KUBCRD_RSPEC_UUID = osl_KUBCRD_RSPEC_UUID;
    }

    public void setClusterMasterURL(String clusterMasterURL) {
        this.clusterMasterURL = clusterMasterURL;
    }

    public void setCurrentContextCluster(String currentContextCluster) {
        this.currentContextCluster = currentContextCluster;
    }

    public void setFullResourceName(String fullResourceName) {
        this.fullResourceName = fullResourceName;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public void setApiGroup(String apiGroup) {
        this.apiGroup = apiGroup;
    }

    public void setUID(String UID) {
        this.UID = UID;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public void setYaml(String yaml) {
        this.yaml = yaml;
    }

    public void setJson(String json) {
        this.json = json;
    }

    public void setProperties(Map<String, KubernetesCRDProperty> properties) {
        this.properties = properties;
    }

    public void setAdditionalProperties(Map<String, KubernetesCRDProperty> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public void setCr_spec(String cr_spec) {
        this.cr_spec = cr_spec;
    }

    public void setStatusCheckFieldName(String statusCheckFieldName) {
        this.statusCheckFieldName = statusCheckFieldName;
    }

    public void setStatusCheckValueStandby(String statusCheckValueStandby) {
        this.statusCheckValueStandby = statusCheckValueStandby;
    }

    public void setStatusCheckValueAlarm(String statusCheckValueAlarm) {
        this.statusCheckValueAlarm = statusCheckValueAlarm;
    }

    public void setStatusCheckValueAvailable(String statusCheckValueAvailable) {
        this.statusCheckValueAvailable = statusCheckValueAvailable;
    }

    public void setStatusCheckValueReserved(String statusCheckValueReserved) {
        this.statusCheckValueReserved = statusCheckValueReserved;
    }

    public void setStatusCheckValueUnknown(String statusCheckValueUnknown) {
        this.statusCheckValueUnknown = statusCheckValueUnknown;
    }

    public void setStatusCheckValueSuspended(String statusCheckValueSuspended) {
        this.statusCheckValueSuspended = statusCheckValueSuspended;
    }

    public static class KubernetesCRDV1Builder {
        private String osl_KUBCRD_RSPEC_UUID;
        private String uuid;
        private String name;
        private String version;
        private String description;
        private String category;
        private String clusterMasterURL;
        private String currentContextCluster;
        private String fullResourceName;
        private String kind;
        private String apiGroup;
        private String uID;
        private String metadata;
        private String yaml;
        private String json;

        KubernetesCRDV1Builder() {
        }

        public KubernetesCRDV1Builder osl_KUBCRD_RSPEC_UUID(String osl_KUBCRD_RSPEC_UUID) {
            this.osl_KUBCRD_RSPEC_UUID = osl_KUBCRD_RSPEC_UUID;
            return this;
        }

        public KubernetesCRDV1Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public KubernetesCRDV1Builder name(String name) {
            this.name = name;
            return this;
        }

        public KubernetesCRDV1Builder version(String version) {
            this.version = version;
            return this;
        }

        public KubernetesCRDV1Builder description(String description) {
            this.description = description;
            return this;
        }

        public KubernetesCRDV1Builder category(String category) {
            this.category = category;
            return this;
        }

        public KubernetesCRDV1Builder clusterMasterURL(String clusterMasterURL) {
            this.clusterMasterURL = clusterMasterURL;
            return this;
        }

        public KubernetesCRDV1Builder currentContextCluster(String currentContextCluster) {
            this.currentContextCluster = currentContextCluster;
            return this;
        }

        public KubernetesCRDV1Builder fullResourceName(String fullResourceName) {
            this.fullResourceName = fullResourceName;
            return this;
        }

        public KubernetesCRDV1Builder kind(String kind) {
            this.kind = kind;
            return this;
        }

        public KubernetesCRDV1Builder apiGroup(String apiGroup) {
            this.apiGroup = apiGroup;
            return this;
        }

        public KubernetesCRDV1Builder uID(String uID) {
            this.uID = uID;
            return this;
        }

        public KubernetesCRDV1Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public KubernetesCRDV1Builder yaml(String yaml) {
            this.yaml = yaml;
            return this;
        }

        public KubernetesCRDV1Builder json(String json) {
            this.json = json;
            return this;
        }

        public KubernetesCRDV1 build() {
            return new KubernetesCRDV1(this.osl_KUBCRD_RSPEC_UUID, this.uuid, this.name, this.version, this.description, this.category, this.clusterMasterURL, this.currentContextCluster, this.fullResourceName, this.kind, this.apiGroup, this.uID, this.metadata, this.yaml, this.json);
        }

        public String toString() {
            return "KubernetesCRDV1.KubernetesCRDV1Builder(osl_KUBCRD_RSPEC_UUID=" + this.osl_KUBCRD_RSPEC_UUID + ", uuid=" + this.uuid + ", name=" + this.name + ", version=" + this.version + ", description=" + this.description + ", category=" + this.category + ", clusterMasterURL=" + this.clusterMasterURL + ", currentContextCluster=" + this.currentContextCluster + ", fullResourceName=" + this.fullResourceName + ", kind=" + this.kind + ", apiGroup=" + this.apiGroup + ", uID=" + this.uID + ", metadata=" + this.metadata + ", yaml=" + this.yaml + ", json=" + this.json + ")";
        }
    }
}

