/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.domain.model.kubernetes;

import org.etsi.osl.domain.model.DomainModelDefinition;
import org.etsi.osl.domain.model.ITMFRCM634_ModelTransformer;
import org.etsi.osl.domain.model.ITMFRI639_ModelTransformer;
import org.etsi.osl.tmf.common.model.ELifecycle;
import org.etsi.osl.tmf.common.model.EValueType;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecification;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationCreate;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationRef;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationUpdate;
import org.etsi.osl.tmf.ri639.model.ResourceCreate;
import org.etsi.osl.tmf.ri639.model.ResourceOperationalStateType;
import org.etsi.osl.tmf.ri639.model.ResourceStatusType;
import org.etsi.osl.tmf.ri639.model.ResourceUpdate;

public class KubernetesContextDefinition
extends DomainModelDefinition
implements ITMFRCM634_ModelTransformer,
ITMFRI639_ModelTransformer {
    public static final String OSL_KUBD_RSPEC_NAME = "kubernetes-context-definition.openslice.io";
    public static final String OSL_KUBD_RSPEC_VERSION = "0.0.1";
    public static final String OSL_KUBD_RSPEC_CATEGORY = "KubernetesContextDefinition";
    public static final String OSL_KUBD_RESOURCE_CATEGORY = "KubernetesContextDefinition";
    public static final String OSL_KUBD_RSPEC_TYPE = "LogicalResourceSpecification";
    public static final String OSL_KUBD_RSPEC_DESCRIPTION = "This Specification is used to describe a KubernetesClient";
    private String osl_KUBD_SPEC_UUID = null;
    private String masterURL;
    private String currentContextName;
    private String currentContextCluster;
    private String currentContextUser;
    private String clusterVersion;

    public KubernetesContextDefinition(String osl_KUBD_SPEC_UUID, String uuid, String name, String version, String description, String category, String masterURL, String currentContextName, String currentContextCluster, String currentContextUser, String clusterVersion) {
        super(uuid, name, version, description, category);
        this.osl_KUBD_SPEC_UUID = osl_KUBD_SPEC_UUID;
        this.masterURL = masterURL;
        this.currentContextName = currentContextName;
        this.currentContextCluster = currentContextCluster;
        this.currentContextUser = currentContextUser;
        this.clusterVersion = clusterVersion;
    }

    public ResourceSpecificationCreate toRSpecCreate_InitRepo() {
        ResourceSpecificationCreate rsc = this.toRSpecCreate();
        rsc.setName(OSL_KUBD_RSPEC_NAME);
        rsc.setVersion(OSL_KUBD_RSPEC_VERSION);
        rsc.setCategory("KubernetesContextDefinition");
        rsc.setDescription(OSL_KUBD_RSPEC_DESCRIPTION);
        rsc.setType(OSL_KUBD_RSPEC_TYPE);
        rsc.setLifecycleStatus(ELifecycle.ACTIVE.getValue());
        return rsc;
    }

    public ResourceSpecificationCreate toRSpecCreate() {
        ResourceSpecificationCreate rsc = new ResourceSpecificationCreate();
        rsc.setName(this.name);
        rsc.setVersion(this.version);
        rsc.setCategory("KubernetesContextDefinition");
        rsc.setDescription(this.description);
        rsc.setType(OSL_KUBD_RSPEC_TYPE);
        rsc.setLifecycleStatus(ELifecycle.ACTIVE.getValue());
        rsc.addResourceSpecificationCharacteristicItemShort("masterURL", "", EValueType.TEXT.getValue(), "", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("resourceVersion", "", EValueType.TEXT.getValue(), "", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("currentContextName", "", EValueType.TEXT.getValue(), "", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("currentContextCluster", "", EValueType.TEXT.getValue(), "", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("currentContextUser", "", EValueType.TEXT.getValue(), "", Boolean.valueOf(false));
        rsc.addResourceSpecificationCharacteristicItemShort("clusterVersion", "", EValueType.TEXT.getValue(), "", Boolean.valueOf(false));
        return rsc;
    }

    public ResourceSpecificationUpdate toRSpecUpdate() {
        return this.toRSpecCreate();
    }

    public KubernetesContextDefinition fromRSpec(ResourceSpecification rSpec) {
        this.osl_KUBD_SPEC_UUID = rSpec.getUuid();
        return this;
    }

    public ResourceCreate toResourceCreate() throws Exception {
        if (this.osl_KUBD_SPEC_UUID == null) {
            throw new Exception("osl_UUID is null. Resource cannot be created without referring a Resource specification");
        }
        ResourceSpecificationRef rSpecRef = new ResourceSpecificationRef();
        rSpecRef.setId(this.osl_KUBD_SPEC_UUID);
        rSpecRef.setName(OSL_KUBD_RSPEC_NAME);
        rSpecRef.setVersion(OSL_KUBD_RSPEC_VERSION);
        ResourceCreate rs = new ResourceCreate();
        rs.setName(this.name);
        rs.setResourceStatus(ResourceStatusType.AVAILABLE);
        rs.setOperationalState(ResourceOperationalStateType.ENABLE);
        rs.setCategory("KubernetesContextDefinition");
        rs.setResourceSpecification(rSpecRef);
        rs.resourceVersion(this.clusterVersion);
        rs.addResourceCharacteristicItemShort("masterUrl", this.masterURL, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("currentContextName", this.currentContextName, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("currentContextCluster", this.currentContextCluster, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("currentContextUser", this.currentContextUser, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("clusterVersion", this.clusterVersion, EValueType.TEXT.getValue());
        return rs;
    }

    public ResourceUpdate toResourceUpdate() throws Exception {
        return this.toResourceCreate();
    }

    public static KubernetesContextDefinitionBuilder builder() {
        return new KubernetesContextDefinitionBuilder();
    }

    public String getOsl_KUBD_SPEC_UUID() {
        return this.osl_KUBD_SPEC_UUID;
    }

    public String getMasterURL() {
        return this.masterURL;
    }

    public String getCurrentContextName() {
        return this.currentContextName;
    }

    public String getCurrentContextCluster() {
        return this.currentContextCluster;
    }

    public String getCurrentContextUser() {
        return this.currentContextUser;
    }

    public String getClusterVersion() {
        return this.clusterVersion;
    }

    public void setOsl_KUBD_SPEC_UUID(String osl_KUBD_SPEC_UUID) {
        this.osl_KUBD_SPEC_UUID = osl_KUBD_SPEC_UUID;
    }

    public void setMasterURL(String masterURL) {
        this.masterURL = masterURL;
    }

    public void setCurrentContextName(String currentContextName) {
        this.currentContextName = currentContextName;
    }

    public void setCurrentContextCluster(String currentContextCluster) {
        this.currentContextCluster = currentContextCluster;
    }

    public void setCurrentContextUser(String currentContextUser) {
        this.currentContextUser = currentContextUser;
    }

    public void setClusterVersion(String clusterVersion) {
        this.clusterVersion = clusterVersion;
    }

    public static class KubernetesContextDefinitionBuilder {
        private String osl_KUBD_SPEC_UUID;
        private String uuid;
        private String name;
        private String version;
        private String description;
        private String category;
        private String masterURL;
        private String currentContextName;
        private String currentContextCluster;
        private String currentContextUser;
        private String clusterVersion;

        KubernetesContextDefinitionBuilder() {
        }

        public KubernetesContextDefinitionBuilder osl_KUBD_SPEC_UUID(String osl_KUBD_SPEC_UUID) {
            this.osl_KUBD_SPEC_UUID = osl_KUBD_SPEC_UUID;
            return this;
        }

        public KubernetesContextDefinitionBuilder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public KubernetesContextDefinitionBuilder name(String name) {
            this.name = name;
            return this;
        }

        public KubernetesContextDefinitionBuilder version(String version) {
            this.version = version;
            return this;
        }

        public KubernetesContextDefinitionBuilder description(String description) {
            this.description = description;
            return this;
        }

        public KubernetesContextDefinitionBuilder category(String category) {
            this.category = category;
            return this;
        }

        public KubernetesContextDefinitionBuilder masterURL(String masterURL) {
            this.masterURL = masterURL;
            return this;
        }

        public KubernetesContextDefinitionBuilder currentContextName(String currentContextName) {
            this.currentContextName = currentContextName;
            return this;
        }

        public KubernetesContextDefinitionBuilder currentContextCluster(String currentContextCluster) {
            this.currentContextCluster = currentContextCluster;
            return this;
        }

        public KubernetesContextDefinitionBuilder currentContextUser(String currentContextUser) {
            this.currentContextUser = currentContextUser;
            return this;
        }

        public KubernetesContextDefinitionBuilder clusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
            return this;
        }

        public KubernetesContextDefinition build() {
            return new KubernetesContextDefinition(this.osl_KUBD_SPEC_UUID, this.uuid, this.name, this.version, this.description, this.category, this.masterURL, this.currentContextName, this.currentContextCluster, this.currentContextUser, this.clusterVersion);
        }

        public String toString() {
            return "KubernetesContextDefinition.KubernetesContextDefinitionBuilder(osl_KUBD_SPEC_UUID=" + this.osl_KUBD_SPEC_UUID + ", uuid=" + this.uuid + ", name=" + this.name + ", version=" + this.version + ", description=" + this.description + ", category=" + this.category + ", masterURL=" + this.masterURL + ", currentContextName=" + this.currentContextName + ", currentContextCluster=" + this.currentContextCluster + ", currentContextUser=" + this.currentContextUser + ", clusterVersion=" + this.clusterVersion + ")";
        }
    }
}

