package org.etsi.osl.domain.model.kubernetes;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.etsi.osl.domain.model.DomainModelDefinition;
import org.etsi.osl.domain.model.ITMFRCM634_ModelTransformer;
import org.etsi.osl.domain.model.ITMFRI639_ModelTransformer;
import org.etsi.osl.tmf.common.model.ELifecycle;
import org.etsi.osl.tmf.common.model.EValueType;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecification;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationCreate;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationRef;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationUpdate;
import org.etsi.osl.tmf.ri639.model.ResourceCreate;
import org.etsi.osl.tmf.ri639.model.ResourceOperationalStateType;
import org.etsi.osl.tmf.ri639.model.ResourceStatusType;
import org.etsi.osl.tmf.ri639.model.ResourceUpdate;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;

/**
 * @author ctranoris
 */
@Getter
@Setter
public class KubernetesService extends DomainModelDefinition
		implements ITMFRCM634_ModelTransformer, ITMFRI639_ModelTransformer {

	public static final String OSL_KUBSERVICE_RSPEC_NAME = "kubernetes-service.openslice.io";
	public static final String OSL_KUBSERVICE_RSPEC_VERSION = "0.0.1";
	public static final String OSL_KUBSERVICE_RSPEC_CATEGORY = "Service/Kubernetes/v1";
	public static final String OSL_KUBSERVICE_RESOURCE_CATEGORY = "Service/Kubernetes/v1";
	public static final String OSL_KUBSERVICE_RSPEC_TYPE = "LogicalResourceSpecification";
	public static final String OSL_KUBSERVICE_RSPEC_DESCRIPTION = "This Specification is used to describe a generic Kubernetes Service";

	private String osl_KUBCRD_RSPEC_UUID = null; //this is assigned by the system through the DB for a specific instance
	
	private String clusterMasterURL;
	private String currentContextCluster;
	private String fullResourceName;
	private String kind;
	private String apiGroup;
	private String UID;
	private String metadata;
	private String yaml;
	private String json;
    private String namespace;
	

    private Map<String, String> spec;
    private String specObj;
    private Map<String, String> status;
    private String statusObj;
    private Map<String, String> properties;


	@Builder
	public KubernetesService(String osl_KUBCRD_RSPEC_UUID, String uuid, String name, String version, String description, String category,
			String clusterMasterURL, String currentContextCluster, String fullResourceName, String namespace,
			String kind, String apiGroup, String uID,
			String metadata,
			String yaml,
			String json) {
		super(uuid, name, version, description, category);
		this.osl_KUBCRD_RSPEC_UUID = osl_KUBCRD_RSPEC_UUID;
		this.clusterMasterURL = clusterMasterURL;
		this.currentContextCluster = currentContextCluster;
		this.fullResourceName = fullResourceName;
		this.kind = kind;
		this.apiGroup = apiGroup;
        this.namespace = namespace;
		this.UID = uID;
		this.metadata = metadata;
		this.yaml = yaml;
		this.json = json;
        this.spec = new HashMap<>();
        this.status = new HashMap<>();
        this.properties = new HashMap<>();
		this.category = OSL_KUBSERVICE_RSPEC_CATEGORY;
	}
	
	

	@Override
	public ResourceSpecificationCreate toRSpecCreate_InitRepo() {

		ResourceSpecificationCreate rsc = this.toRSpecCreate();
		rsc.setName( OSL_KUBSERVICE_RSPEC_NAME );
		rsc.setCategory( OSL_KUBSERVICE_RSPEC_CATEGORY );
		rsc.setVersion(OSL_KUBSERVICE_RSPEC_VERSION);
		rsc.setDescription( OSL_KUBSERVICE_RSPEC_DESCRIPTION );
		rsc.setType( OSL_KUBSERVICE_RSPEC_TYPE );
		
		

		return rsc;
	}
	
	@Override
	public ResourceSpecificationCreate toRSpecCreate() {

		ResourceSpecificationCreate rsc = new ResourceSpecificationCreate();
		rsc.setName( this.name );
		rsc.setCategory( OSL_KUBSERVICE_RSPEC_CATEGORY );
		rsc.setVersion( this.version );
		rsc.setDescription( this.version );
		rsc.setType( OSL_KUBSERVICE_RSPEC_TYPE );
		
		rsc.setLifecycleStatus( ELifecycle.ACTIVE.getValue() );
		rsc.addResourceSpecificationCharacteristicItemShort("clusterMasterURL", this.clusterMasterURL, EValueType.TEXT.getValue(), "URL of cluster",  false);
		rsc.addResourceSpecificationCharacteristicItemShort("currentContextCluster", this.currentContextCluster, EValueType.TEXT.getValue(), "", false);
		rsc.addResourceSpecificationCharacteristicItemShort("fullResourceName", this.fullResourceName, EValueType.TEXT.getValue(), "", false);
		rsc.addResourceSpecificationCharacteristicItemShort("Kind", this.kind, EValueType.TEXT.getValue(), "", false);
		rsc.addResourceSpecificationCharacteristicItemShort("apiGroup", this.apiGroup, EValueType.TEXT.getValue(), "", false);
		rsc.addResourceSpecificationCharacteristicItemShort("UID", this.UID, EValueType.TEXT.getValue(), "", false);
		rsc.addResourceSpecificationCharacteristicItemShort("metadata", this.metadata, EValueType.OBJECT.getValue(), "", false);
		rsc.addResourceSpecificationCharacteristicItemShort("yaml", this.yaml, EValueType.TEXT.getValue(), "", false);
		rsc.addResourceSpecificationCharacteristicItemShort("json", this.json, EValueType.TEXT.getValue(), "", false);
        rsc.addResourceSpecificationCharacteristicItemShort("spec", this.specObj, EValueType.OBJECT.getValue(), "", false);
        rsc.addResourceSpecificationCharacteristicItemShort("status", this.statusObj, EValueType.OBJECT.getValue(), "", false);
        
        
        
        
        
		if (this.status != null)
		  this.status.forEach((kPropName, vProVal) -> {
		    EValueType etype;		 
		    etype = EValueType.TEXT;
		    rsc.addResourceSpecificationCharacteristicItemShort( kPropName , vProVal, etype.getValue(), "", false);

		  });
		if (this.spec != null)
		  this.spec.forEach((kPropName, vProVal) -> {
		    EValueType etype;        
		    etype = EValueType.TEXT;
		    rsc.addResourceSpecificationCharacteristicItemShort( kPropName , vProVal, etype.getValue(), "", false);

		  });
	      if (this.properties != null)
	          this.properties.forEach((kPropName, vProVal) -> {
	            EValueType etype;        
	            etype = EValueType.TEXT;
	            rsc.addResourceSpecificationCharacteristicItemShort( kPropName , vProVal, etype.getValue(), "", false);

	          });
		


		return rsc;
	}
	
	@Override
	public ResourceSpecificationUpdate toRSpecUpdate() {
		return this.toRSpecCreate();
	}

	@Override
	public KubernetesService fromRSpec(ResourceSpecification rSpec) {
		this.osl_KUBCRD_RSPEC_UUID = rSpec.getUuid();
		return this;
	}
	
	@Override
	public ResourceCreate toResourceCreate() {

		if (osl_KUBCRD_RSPEC_UUID == null) {
			return null;
		}

		ResourceSpecificationRef rSpecRef = new ResourceSpecificationRef();
		rSpecRef.setId( osl_KUBCRD_RSPEC_UUID  );
		rSpecRef.setName( OSL_KUBSERVICE_RSPEC_NAME );
		rSpecRef.setVersion( OSL_KUBSERVICE_RSPEC_VERSION );
		
		ResourceCreate rs = new ResourceCreate();
		rs.name( this.name )
		.category( OSL_KUBSERVICE_RESOURCE_CATEGORY )
		.description( this.description )
		.resourceStatus( ResourceStatusType.AVAILABLE )
		.operationalState( ResourceOperationalStateType.ENABLE )
		.resourceSpecification( rSpecRef )
		.resourceVersion( this.version);
		
		String cprefix = "";
		if ( this.name.indexOf('@')>0) {
	        String firstToken = this.name.substring(  0, this.name.indexOf('@') );
	        cprefix = this.kind + "." + firstToken + ".";		  
		}
		
		rs.addResourceCharacteristicItemShort("clusterMasterURL", this.clusterMasterURL, EValueType.TEXT.getValue());
		rs.addResourceCharacteristicItemShort("currentContextCluster", this.currentContextCluster, EValueType.TEXT.getValue());
		rs.addResourceCharacteristicItemShort("fullResourceName", this.fullResourceName, EValueType.TEXT.getValue());
		rs.addResourceCharacteristicItemShort("Kind", this.kind, EValueType.TEXT.getValue());
		rs.addResourceCharacteristicItemShort("apiGroup", this.apiGroup, EValueType.TEXT.getValue());
		rs.addResourceCharacteristicItemShort("UID", this.UID, EValueType.TEXT.getValue());
		rs.addResourceCharacteristicItemShort("metadata", this.metadata, EValueType.OBJECT.getValue());
		rs.addResourceCharacteristicItemShort("yaml", this.yaml, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort(cprefix + "json", this.json, EValueType.TEXT.getValue());
        rs.addResourceCharacteristicItemShort("spec", this.specObj, EValueType.OBJECT.getValue());
        rs.addResourceCharacteristicItemShort("status", this.statusObj, EValueType.OBJECT.getValue());
		

        
		if (this.status != null)
		  this.status.forEach((kPropName, vProVal) -> {
		    EValueType etype;
		    etype = EValueType.TEXT;

		    rs.addResourceCharacteristicItemShort( kPropName , vProVal, etype.getValue());

		  });
        if (this.spec != null)
          this.spec.forEach((kPropName, vProVal) -> {
            EValueType etype;        
            etype = EValueType.TEXT;
            rs.addResourceCharacteristicItemShort(  kPropName , vProVal, etype.getValue());

          });
        if (this.properties != null)
          this.properties.forEach((kPropName, vProVal) -> {
            EValueType etype;
            etype = EValueType.TEXT;

            rs.addResourceCharacteristicItemShort( kPropName , vProVal, etype.getValue());

          });



		return rs;
	}
	
	@Override
	public ResourceUpdate toResourceUpdate() {
	
		return this.toResourceCreate();
	}

}
