package org.etsi.osl.metrico.services;

import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.dataformat.JsonLibrary;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.etsi.osl.tmf.pm628.model.MeasurementCollectionJob;
import org.etsi.osl.tmf.pm628.model.MeasurementCollectionJobCreateEvent;
import org.etsi.osl.tmf.pm628.model.MeasurementCollectionJobRef;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Configuration
@Component
public class MetricoServiceRouteBuilder extends RouteBuilder {

    private static final transient Log logger = LogFactory.getLog(MetricoServiceRouteBuilder.class.getName());

    @Autowired
    private MetricoService metricoService;

    @Value("${EVENT_MEASUREMENT_COLLECTION_JOB_CREATE}")
    private String EVENT_MEASUREMENT_COLLECTION_JOB_CREATE = "";

    public void configure() throws Exception {

//        from(EVENT_MEASUREMENT_COLLECTION_JOB_CREATED)
//                .log(LoggingLevel.INFO, log, EVENT_MEASUREMENT_COLLECTION_JOB_CREATED + " message received!")
//                .to("log:DEBUG?showBody=true&showHeaders=true").unmarshal()
//                .json(JsonLibrary.Jackson, MeasurementCollectionJob.class, true)
//                .bean(metricoService, "startPeriodicQueryToPrometheus(${body})");

        from(EVENT_MEASUREMENT_COLLECTION_JOB_CREATE)
                .log(LoggingLevel.INFO, log, EVENT_MEASUREMENT_COLLECTION_JOB_CREATE + " message received!")
                .to("log:DEBUG?showBody=true&showHeaders=true")
                .unmarshal().json(JsonLibrary.Jackson, MeasurementCollectionJobCreateEvent.class, true)
                .process(exchange -> {
                    MeasurementCollectionJobCreateEvent event = exchange.getIn().getBody(MeasurementCollectionJobCreateEvent.class);
                    MeasurementCollectionJobRef jobRef = event.getEvent().getMeasurementCollectionJob();
                    exchange.getIn().setBody(jobRef);
                })
                .bean(metricoService, "startPeriodicQueryToPrometheusRef(${body})");

    }


}
