package org.etsi.osl.metrico.mapper;

import org.etsi.osl.tmf.pm628.model.ScheduleDefinition;
import org.etsi.osl.tmf.pm628.model.ScheduleDefinitionMVO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

@Mapper(uses = {
        DayOfWeekRecurrenceMapper.class,
        MonthlyScheduleDayOfWeekDefinitionMapper.class
})
public interface ScheduleDefinitionMapper {
    ScheduleDefinitionMapper INSTANCE = Mappers.getMapper(ScheduleDefinitionMapper.class);

    @Mapping(source = "scheduleDefinitionStartTime", target = "scheduleDefinitionStartTime")
    @Mapping(source = "scheduleDefinitionEndTime", target = "scheduleDefinitionEndTime")
    @Mapping(source = "recurringFrequency", target = "recurringFrequency")
    @Mapping(source = "excludedDate", target = "excludedDate")
    @Mapping(source = "scheduleDefinitionHourRange", target = "scheduleDefinitionHourRange")
    @Mapping(source = "weeklyScheduledDefinition", target = "weeklyScheduledDefinition")
    @Mapping(source = "monthlyScheduleDayOfMonthDefinition", target = "monthlyScheduleDayOfMonthDefinition")
    @Mapping(source = "monthlyScheduleDayOfWeekDefinition", target = "monthlyScheduleDayOfWeekDefinition")
    @Mapping(source = "dateScheduleDefintion", target = "dateScheduleDefintion")
    ScheduleDefinition toScheduleDefinition(ScheduleDefinitionMVO scheduleDefinitionMVO);

    @Mapping(source = "scheduleDefinitionStartTime", target = "scheduleDefinitionStartTime")
    @Mapping(source = "scheduleDefinitionEndTime", target = "scheduleDefinitionEndTime")
    @Mapping(source = "recurringFrequency", target = "recurringFrequency")
    @Mapping(source = "excludedDate", target = "excludedDate")
    @Mapping(source = "scheduleDefinitionHourRange", target = "scheduleDefinitionHourRange")
    @Mapping(source = "weeklyScheduledDefinition", target = "weeklyScheduledDefinition")
    @Mapping(source = "monthlyScheduleDayOfMonthDefinition", target = "monthlyScheduleDayOfMonthDefinition")
    @Mapping(source = "monthlyScheduleDayOfWeekDefinition", target = "monthlyScheduleDayOfWeekDefinition")
    @Mapping(source = "dateScheduleDefintion", target = "dateScheduleDefintion")
    ScheduleDefinitionMVO toScheduleDefinitionMVO(ScheduleDefinition scheduleDefinition);
}