package org.etsi.osl.metrico.services;

import org.etsi.osl.tmf.pm628.model.DataAccessEndpoint;
import org.etsi.osl.tmf.pm628.model.Granularity;
import org.etsi.osl.tmf.pm628.model.MeasurementCollectionJob;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit.jupiter.SpringExtension;

import java.util.*;

import java.net.URI;
import java.net.URISyntaxException;


@SpringBootTest
@ExtendWith(SpringExtension.class)
public class MetricoServiceTest {

    @Autowired
    private MetricoService metricoService;

    private MeasurementCollectionJob mcj;

    @BeforeEach
    public void setUp() throws URISyntaxException {
        mcj = new MeasurementCollectionJob();
        mcj.setUuid("123e4567-e89b-12d3-a456-426614174000");

        mcj.granularity(Granularity.G_10SEC);

        DataAccessEndpoint dae = new DataAccessEndpoint();
        dae.setApiType("PROMETHEUS");
        dae.setUri(new URI("http://150.140.195.195:9090/api/v1/query?query=netdata_app_disk_physical_io_KiB_persec_average"));
        dae.setUuid("123e4567-e89b-12d3-a456-426614174011");
        List<DataAccessEndpoint> daeList = new ArrayList<>();
        daeList.add(dae);
        mcj.setDataAccessEndpoint(daeList);

        //job.setDataAccessEndPointUri(new URI("http://150.140.195.195:9090/api/v1/query?query=up"));

    }

    @Test
    public void testQueryToPrometheus() {
        String[] result = metricoService.queryToPrometheus(mcj);
        System.out.println(Arrays.toString(result));

        //assertEquals("OK", result);
    }

    @Test
    public void testStartPeriodicQueryToPrometheus() throws InterruptedException {
        metricoService.startPeriodicQueryToPrometheus(mcj);
        Thread.sleep(60000);
    }
}