package org.etsi.osl.metrico.reposervices;

import org.etsi.osl.metrico.model.Job;
import org.etsi.osl.metrico.repo.JobRepository;
import org.etsi.osl.tmf.pm628.model.ExecutionStateType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.OffsetDateTime;
import java.util.UUID;

@Service
public class JobRepoService {

    private static final Logger logger = LoggerFactory.getLogger(JobRepoService.class);

    private JobRepository jobRepository;

    @Autowired
    public JobRepoService(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
        if (jobRepository == null) {
            logger.error("JobRepository is null. Dependency injection failed.");
        }
    }



    public Job createAndSaveJob() {
        Job job = new Job(); // Assuming Job has a default constructor
        // Set properties on the job object as needed
        return jobRepository.save(job); // This will persist the job to the database
    }

    public Job updateJob(UUID jobId, ExecutionStateType newState, OffsetDateTime newStartDateTime, OffsetDateTime newEndDateTime, Integer newExecutionInterval) {
        // Retrieve the existing Job
        Job job = jobRepository.findById(jobId).orElse(null);
        if (job == null) {
            logger.error("Job with ID {} not found.", jobId);
            return null; // Or throw an exception
        }
        // Update the fields as needed
        if (newState != null) job.setState(newState);
        if (newStartDateTime != null) job.setStartDateTime(newStartDateTime);
        if (newEndDateTime != null) job.setEndDateTime(newEndDateTime);
        if (newExecutionInterval != null) job.setExecutionInterval(newExecutionInterval);

        // Save the updated Job back to the database
        return jobRepository.save(job);
    }

    public Job updateJob(UUID jobId, ExecutionStateType newState) {
        // Retrieve the existing Job
        Job job = jobRepository.findById(jobId).orElse(null);
        if (job == null) {
            logger.error("Job with ID {} not found.", jobId);
            return null; // Or throw an exception
        }
        // Update the fields as needed
        if (newState != null) job.setState(newState);
        // Save the updated Job back to the database
        return jobRepository.save(job);
    }
}
