package org.etsi.osl.metrico.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.test.spring.junit5.CamelSpringBootTest;
import org.etsi.osl.metrico.MetricoCommonMethods;
import org.etsi.osl.tmf.pm628.model.MeasurementCollectionJobCreateEvent;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.test.context.TestPropertySource;

import static org.mockito.Mockito.timeout;
import static org.mockito.Mockito.verify;

@CamelSpringBootTest
@SpringBootTest
@TestPropertySource(properties = {
        "EVENT_MEASUREMENT_COLLECTION_JOB_CREATE=direct:eventMeasurementCollectionJobCreate"
})
class MetricoServiceRouteBuilderTest {

    @Autowired
    private ProducerTemplate producerTemplate;

    @MockBean
    private MetricoService metricoService;

    @MockBean
    private MetricoCommonMethods metricoCommonMethods;

    @Test
    void testRouteCallsMetricoService() throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        MeasurementCollectionJobCreateEvent event = new MeasurementCollectionJobCreateEvent();
        String eventJson = objectMapper.writeValueAsString(event);

        producerTemplate.sendBody("direct:eventMeasurementCollectionJobCreate", eventJson);

        ArgumentCaptor<MeasurementCollectionJobCreateEvent> captor = ArgumentCaptor.forClass(MeasurementCollectionJobCreateEvent.class);
        verify(metricoService, timeout(1000)).startPeriodicQueryToPrometheusEvent(captor.capture());
    }
}