package org.etsi.osl.metrico.model;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.*;

class SupportedDataAccessEndpointsTest {

    @Test
    void testContainsWithValidApiType() {
        assertTrue(SupportedDataAccessEndpoints.contains("PROMETHEUS"));
    }

    @Test
    void testContainsWithValidApiTypeLowerCase() {
        assertTrue(SupportedDataAccessEndpoints.contains("prometheus"));
    }

    @Test
    void testContainsWithInvalidApiType() {
        assertFalse(SupportedDataAccessEndpoints.contains("INFLUXDB"));
    }

    @Test
    void testContainsWithEmptyString() {
        assertFalse(SupportedDataAccessEndpoints.contains(""));
    }

    @Test
    void testContainsWithNull() {
        assertThrows(NullPointerException.class, () -> SupportedDataAccessEndpoints.contains(null));
    }
}