package org.etsi.osl.metrico;

import org.etsi.osl.tmf.pm628.model.MeasurementCollectionJob;
import org.etsi.osl.tmf.pm628.model.MeasurementCollectionJobMVO;
import org.junit.jupiter.api.Test;

import java.io.IOException;

import static org.junit.jupiter.api.Assertions.*;

class JsonUtilTest {

    @Test
    void toJsonObj_validJsonString_returnsObject() throws IOException {
        String jsonString = "{\"@type\":\"MeasurementCollectionJob\",\"uuid\":\"f47ac10b-58cc-4372-a567-0e02b2c3d479\"}";
        MeasurementCollectionJobMVO mcj = JsonUtil.toJsonObj(jsonString, MeasurementCollectionJobMVO.class);
        assertNotNull(mcj);
        assertEquals("f47ac10b-58cc-4372-a567-0e02b2c3d479", mcj.getUuid());
    }

    @Test
    void toJsonObj_invalidJsonString_throwsIOException() {
        String invalidJsonString = "{\"executionState\":\"INPROGRESS\"";
        assertThrows(IOException.class, () -> {
            JsonUtil.toJsonObj(invalidJsonString, MeasurementCollectionJob.class);
        });
    }

    @Test
    void toJsonString_validObject_returnsJsonString() {
        MeasurementCollectionJobMVO mcj = new MeasurementCollectionJobMVO();
        String uuid = "f47ac10b-58cc-4372-a567-0e02b2c3d479";
        mcj.setUuid(uuid);
        String jsonString = JsonUtil.toJsonString(mcj);
        assertTrue(jsonString.contains("\"uuid\":\"f47ac10b-58cc-4372-a567-0e02b2c3d479\""));
    }

    @Test
    void toJsonString_nullObject_returnsNull() {
        String jsonString = JsonUtil.toJsonString(null);
        assertNull(jsonString);
    }

    @Test
    void toJsonString_unserializableObject_returnsNull() {
        class SelfRef {
            public SelfRef ref;
        }
        SelfRef obj = new SelfRef();
        obj.ref = obj; // creates a circular reference
        String jsonString = JsonUtil.toJsonString(obj);
        assertNull(jsonString);
    }
}