package org.etsi.osl.metrico.services;

import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.dataformat.JsonLibrary;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.etsi.osl.tmf.pm628.model.MeasurementCollectionJobCreateEvent;
import org.etsi.osl.tmf.sim638.model.ServiceAttributeValueChangeNotification;
import org.etsi.osl.tmf.sim638.model.ServiceDeleteNotification;
import org.etsi.osl.tmf.sim638.model.ServiceStateChangeNotification;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Configuration
@Component
public class MetricoServiceRouteBuilder extends RouteBuilder {

    private static final transient Log logger = LogFactory.getLog(MetricoServiceRouteBuilder.class.getName());

    @Autowired
    private MetricoService metricoService;

    @Value("${EVENT_MEASUREMENT_COLLECTION_JOB_CREATE}")
    private String EVENT_MEASUREMENT_COLLECTION_JOB_CREATE = "";

    @Value("${EVENT_SERVICE_STATE_CHANGED}")
    private String EVENT_SERVICE_STATE_CHANGED = "";

    @Value("${EVENT_SERVICE_DELETE}")
    private String EVENT_SERVICE_DELETE = "";

    @Value("${EVENT_SERVICE_ATTRIBUTE_VALUE_CHANGED}")
    private String EVENT_SERVICE_ATTRIBUTE_VALUE_CHANGED = "";

    public void configure() throws Exception {

        from(EVENT_MEASUREMENT_COLLECTION_JOB_CREATE)
                .log(LoggingLevel.INFO, log, EVENT_MEASUREMENT_COLLECTION_JOB_CREATE + " message received!")
                .to("log:DEBUG?showBody=true&showHeaders=true")
                .unmarshal()
                .json(JsonLibrary.Jackson, MeasurementCollectionJobCreateEvent.class, true)
                .bean(metricoService, "startPeriodicQueryToPrometheusEvent(${body})");

        from(EVENT_SERVICE_STATE_CHANGED)
                .log(LoggingLevel.INFO, log, EVENT_SERVICE_STATE_CHANGED + " message received!")
                .to("log:DEBUG?showBody=true&showHeaders=true")
                .unmarshal()
                .json(JsonLibrary.Jackson, ServiceStateChangeNotification.class, true)
                .bean(metricoService, "handleServiceEvent");

        from(EVENT_SERVICE_DELETE)
                .log(LoggingLevel.INFO, log, EVENT_SERVICE_DELETE + " message received!")
                .to("log:DEBUG?showBody=true&showHeaders=true")
                .unmarshal()
                .json(JsonLibrary.Jackson, ServiceDeleteNotification.class, true)
                .bean(metricoService, "handleServiceEvent");

        from(EVENT_SERVICE_ATTRIBUTE_VALUE_CHANGED)
                .log(LoggingLevel.INFO, log, EVENT_SERVICE_ATTRIBUTE_VALUE_CHANGED + " message received!")
                .to("log:DEBUG?showBody=true&showHeaders=true")
                .unmarshal()
                .json(JsonLibrary.Jackson, ServiceAttributeValueChangeNotification.class, true)
                .bean(metricoService, "handleServiceEvent");
    }

}
