package org.etsi.osl.metrico.prometheus;

import org.etsi.osl.metrico.MetricoCommonMethods;
import org.etsi.osl.metrico.model.Job;
import org.etsi.osl.metrico.services.JobService;
import org.etsi.osl.tmf.common.model.Any;
import org.etsi.osl.tmf.common.model.service.Characteristic;
import org.etsi.osl.tmf.pm628.model.ExecutionStateType;
import org.etsi.osl.tmf.pm628.model.MeasurementCollectionJob;
import org.etsi.osl.tmf.sim638.model.ServiceUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;
import java.net.URI;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.concurrent.TimeUnit;

@Component
public class PrometheusQueries {

    private static final Logger logger = LoggerFactory.getLogger(PrometheusQueries.class);

    private final JobService jobService;
    private final MetricoCommonMethods metricoCommonMethods;


    public PrometheusQueries(JobService jobService, MetricoCommonMethods metricoCommonMethods) {
        this.jobService = jobService;
        this.metricoCommonMethods = metricoCommonMethods;
    }

    public String sendQueryToPrometheus(String prometheusUrl, String query, MeasurementCollectionJob mcj, Job job) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl(prometheusUrl).path("/api/v1/query").query(query);
        String url = builder.toUriString();
        URI uri = builder.build().toUri();
        
        logger.atInfo().log("Sent query at prometheus with URL: " + prometheusUrl + " with query: " + query);
        logger.atInfo().log("Sent query  builder.toUriString(): " + url);
        logger.atInfo().log("Sent query  builder.build().toUri(): " + uri.toString() );

        WebClient webclient = WebClient.create();
        String response;

        if (webclient != null) {
            try {
              
                response = webclient.get().uri( uri ) 
                        //.header("Authorization", "Basic " + encodedClientData)
                        //.attributes( ServletOAuth2AuthorizedClientExchangeFilterFunction.clientRegistrationId("authOpensliceProvider"))
                        .retrieve()
//                        .onStatus(HttpStatusCode::is4xxClientError, r -> {
//                            logger.error("4xx eror");
//                            return Mono.error(new RuntimeException("4xx"));
//                        }).onStatus(HttpStatusCode::is5xxServerError, r -> {
//                            logger.error("5xx eror");
//                            return Mono.error(new RuntimeException("5xx"));
//                        })
                        .bodyToMono(new ParameterizedTypeReference<String>() {
                        }).block();
                logger.atDebug().log("Received " + response);
                String[] promResponse = response.split("\n");
            } catch (Exception e) {
                logger.error(" error on web client request");
                response = "{\"status\":\"" + e.getLocalizedMessage() + "\"";
                e.printStackTrace();
            }
        } else {
            logger.error("WebClient is null. Cannot be created.");
            response = "{\"status\":\"Cannot connect\"";
        }

        ServiceUpdate su = new ServiceUpdate();
        //patch TMF service
        String serviceUUID = mcj.getConsumingApplicationId();
        logger.atDebug().log("serviceUUID= " + serviceUUID);
        Characteristic serviceCharacteristicItem = new Characteristic();
        serviceCharacteristicItem.setName(mcj.getOutputFormat());
        serviceCharacteristicItem.setValueType("TEXT");
        Any val = new Any();
        val.setValue(response);
        val.setAlias("");
        serviceCharacteristicItem.setValue(val);
        su.addServiceCharacteristicItem(serviceCharacteristicItem);
        metricoCommonMethods.updateService(serviceUUID, su, true);

        return response;
    }


    public Job startPeriodicQuery(String prometheusUrl, String query, final Job ajob, MeasurementCollectionJob mcj) {

        Job job = ajob;


        if (job.getExecutionInterval() == null) {
            job.setExecutionInterval(180);
        }

        final Runnable queryHandler = () -> sendQueryToPrometheus(prometheusUrl, query, mcj, ajob);

        job = jobService.startJob(queryHandler, job);
        if (job.getState() == ExecutionStateType.FAILED) {
            jobService.stopJob(job);
            return job;
        }

        if (job.getEndDateTime() != null) {
            long stopAfterSeconds = Duration.between(OffsetDateTime.now(), job.getEndDateTime()).getSeconds();

            JobService.getScheduler().schedule(() -> {
                jobService.stopJob(ajob);
            }, stopAfterSeconds, TimeUnit.SECONDS);
        }

        return job;
    }
}


