package org.etsi.osl.metrico.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.Transient;
import lombok.Getter;
import lombok.Setter;
import org.etsi.osl.tmf.pm628.model.ExecutionStateType;
import org.springframework.format.annotation.DateTimeFormat;

import java.net.URI;
import java.time.OffsetDateTime;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;


@Getter
@Setter
public class Job{

    private ExecutionStateType state;

    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime startDateTime;

    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime endDateTime;

    private Integer executionInterval;

    private UUID dataAccessEndPointRef;

    private UUID scheduleDefinitionRef;

    private UUID measurementCollectionJobRef;  // 1:1 relationship between Job and MeasurementCollectionJob. It will be used as an id for the Job.

    private URI dataAccessEndPointUri;

    private String apiType;

    @JsonIgnore
    private boolean deleted = false;

    @Transient
    private final Runnable task = new Runnable() {
        @Override
        public void run() {
        }
    };

    @Transient
    private ScheduledFuture<?> future;

    public Job() {
        this.state = ExecutionStateType.PENDING;
        this.executionInterval = 10;
        this.startDateTime = OffsetDateTime.now();
    }

    public Job(OffsetDateTime stopDateTime){
        this();
        this.endDateTime = stopDateTime;
    }

    public Job(OffsetDateTime startDateTime, OffsetDateTime endDateTime){
        this(endDateTime);
        this.startDateTime = startDateTime;
    }

    public Job(OffsetDateTime startDateTime, OffsetDateTime endDateTime, Integer executionInterval){
        this(startDateTime, endDateTime);
        this.executionInterval = executionInterval;
    }

    @Override
    public String toString() {
        return "Job{" +
                "state=" + state +
                ", startDateTime=" + startDateTime +
                ", endDateTime=" + endDateTime +
                ", executionInterval=" + executionInterval +
                ", dataAccessEndPointRef=" + dataAccessEndPointRef +
                ", scheduleDefinitionRef=" + scheduleDefinitionRef +
                ", measurementCollectionJobRef=" + measurementCollectionJobRef +
                ", deleted=" + deleted +
                '}';
    }

}
