package org.etsi.osl.metrico.services;

import org.etsi.osl.metrico.model.Job;
import org.etsi.osl.metrico.reposervices.JobRepoService;
import org.etsi.osl.tmf.pm628.model.ExecutionStateType;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.slf4j.Logger;

import java.time.OffsetDateTime;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertNotNull;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.*;

class JobServiceTest {

    @Mock
    private JobRepoService jobRepoService;

    @Mock
    private ScheduledExecutorService scheduler;

    @Mock
    private Logger logger;

    private JobService jobService;

    @BeforeEach
    void setUp() {
        MockitoAnnotations.openMocks(this);
        jobService = new JobService(jobRepoService);
    }

    @Test
    void testStartJob_Success() {
        // Initialize the job with specific parameters
        OffsetDateTime startDateTime = OffsetDateTime.now().plusSeconds(5);
        OffsetDateTime endDateTime = startDateTime.plusMinutes(10);
        Integer executionInterval = 5;
        Runnable task = () -> {};
        Job expectedJob = new Job(startDateTime, endDateTime, executionInterval);
        // Assert the initial state is PENDING
        assertEquals(expectedJob.getState(), ExecutionStateType.PENDING);

        // Set the UUID and state of the expected job after it has been saved to the db

        expectedJob.setState(ExecutionStateType.INPROGRESS);

        // Mock jobRepoService.createAndSaveJob() to return the expected Job
        when(jobRepoService.createAndSaveJob()).thenReturn(expectedJob);

//        // Mock scheduler.scheduleAtFixedRate() to not throw an exception
//        ScheduledFuture<?> mockFuture = mock(ScheduledFuture.class);
//        when(scheduler.scheduleAtFixedRate(any(Runnable.class), eq(5L), eq(5L), eq(TimeUnit.SECONDS)))
//                .thenReturn(mockFuture);

//        // Call jobService.startJob() with valid parameters
//        Job resultJob = jobService.startJob(task, startDateTime, endDateTime, executionInterval);
//
//        // Verify job state is INPROGRESS, and job is added to the jobs map
//        assertEquals(ExecutionStateType.INPROGRESS, resultJob.getState());
//        assertNotNull(JobService.getJobs().get(resultJob.getUuid()));
//        assertEquals(expectedJob, JobService.getJobs().get(resultJob.getUuid()));
    }
    @Test
    void testStartJob_NullPointerException() {
        // Mock jobRepoService.createAndSaveJob() to throw NullPointerException
        // Call jobService.startJob() with valid parameters
        // Verify job state is FAILED
    }

    @Test
    void testStartJob_RejectedExecutionException() {
        // Mock scheduler.scheduleAtFixedRate() to throw RejectedExecutionException
        // Call jobService.startJob() with valid parameters
        // Verify job state is FAILED
    }

    @Test
    void testStopJob_InProgress() {
        // Add a job to the jobs map with state INPROGRESS
        // Call JobService.stopJob() with the job's UUID
        // Verify job state is CANCELLED
    }

    @Test
    void testStopJob_AlreadyCompleted() {
        // Add a job to the jobs map with state COMPLETED
        // Call JobService.stopJob() with the job's UUID
        // Verify job state remains COMPLETED
    }

    @Test
    void testStopJob_DoesNotExist() {
        // Call JobService.stopJob() with a non-existent job UUID
        // Verify appropriate warning is logged
    }
}