package org.etsi.osl.metrico.mapper;

import org.etsi.osl.metrico.model.Job;
import org.etsi.osl.tmf.pm628.model.DataAccessEndpoint;
import org.etsi.osl.tmf.pm628.model.MeasurementCollectionJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.UUID;

public class JobMapper {

    private static final Logger logger = LoggerFactory.getLogger(JobMapper.class);

    public static Job measurementCollectionJobMapToJob(MeasurementCollectionJob measurementCollectionJob) {
        Job job = new Job();

        job.setMeasurementCollectionJobRef(UUID.fromString(measurementCollectionJob.getUuid()));
        if(measurementCollectionJob.getDataAccessEndpoint().size()!=1){
            throw new IllegalArgumentException("DataAccessEndpoint should be exactly one");
        }else {
            DataAccessEndpoint dataAccessEndpoint = measurementCollectionJob.getDataAccessEndpoint().get(0);
            job.setDataAccessEndPointRef(UUID.fromString(dataAccessEndpoint.getUuid()));
            if( dataAccessEndpoint.getApiType().equalsIgnoreCase("PROMETHEUS")){
                job.setApiType(dataAccessEndpoint.getApiType());
            } else if (dataAccessEndpoint.getApiType() == null ) {
                throw new IllegalArgumentException("API type needs to be defined");
            }else{
                throw new IllegalArgumentException("API type not supported");
            }
            job.setDateAccessEndPointUri(dataAccessEndpoint.getUri());
            job.setQuery(dataAccessEndpoint.getUriQueryFilter());

        }

        job.setStartDateTime(measurementCollectionJob.getScheduleDefinition().get(0).getScheduleDefinitionStartTime());
        job.setEndDateTime(measurementCollectionJob.getScheduleDefinition().get(0).getScheduleDefinitionEndTime());

        /*
        Extend the reporting period and granularitypossible values
        job.setStartDateTime(measurementCollectionJob.getReportingPeriod());
        job.setExecutionInterval(measurementCollectionJob.getGranularity());
        */

        return job;
    }

}
