package org.etsi.osl.metrico;


import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.RouteBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.etsi.osl.metrico.prometheus.PrometheusQueries;
import org.etsi.osl.metrico.reposervices.JobRepoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;
import org.etsi.osl.centrallog.client.CentralLogger;

@Configuration
@Component
public class MetricoRouteBuilder extends RouteBuilder {

    private static final transient Log logger = LogFactory.getLog(MetricoRouteBuilder.class);

    final JobRepoService jobRepoService;
    private final PrometheusQueries prometheusQueries;

    public MetricoRouteBuilder(JobRepoService jobRepoService, PrometheusQueries prometheusQueries) {
        this.jobRepoService = jobRepoService;
        this.prometheusQueries = prometheusQueries;
    }

    @Value("${MEASUREMENT_COLLECTION_JOB_CREATED}")
    private static String MEASUREMENT_COLLECTION_JOB_CREATED;

    @Value("${MEASUREMENT_COLLECTION_JOB_RESPONSE}")
    private static String MEASUREMENT_COLLECTION_JOB_RESPONSE ;

    public  void configure() throws Exception{
        from(MEASUREMENT_COLLECTION_JOB_CREATED)
                .log(LoggingLevel.INFO, log, MEASUREMENT_COLLECTION_JOB_CREATED + "message received!")
                .to("log:DEBUG?showBody=true&showHeaders=true")
                .setBody(simple("Message received and processed"))
                .to(MEASUREMENT_COLLECTION_JOB_RESPONSE);

    }
}
