package org.etsi.osl.metrico.services;

import jakarta.validation.constraints.NotNull;
import org.etsi.osl.metrico.mapper.JobMapper;
import org.etsi.osl.metrico.model.Job;
import org.etsi.osl.metrico.prometheus.PrometheusQueries;
import org.etsi.osl.tmf.pm628.model.ExecutionStateType;
import org.etsi.osl.tmf.pm628.model.MeasurementCollectionJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.time.OffsetDateTime;

@Service
public class MetricoService {

    private static final Logger logger = LoggerFactory.getLogger(JobService.class);

    private final PrometheusQueries prometheusQueries;

    public MetricoService(PrometheusQueries prometheusQueries) {
        this.prometheusQueries = prometheusQueries;
    }

    public String sendQueryToPrometheus(String promURL, String promQuery) {
        return prometheusQueries.sendQueryToPrometheus(promURL, promQuery);
    }

    public String[] queryToPrometheus(@NotNull MeasurementCollectionJob givenMCJ){

        Job job = JobMapper.measurementCollectionJobMapToJob(givenMCJ);
        String promURL = job.getDataAccessEndPointUri().getScheme() + "://" + job.getDataAccessEndPointUri().getAuthority();
        String promQuery = job.getDataAccessEndPointUri().getQuery();
        promQuery = promQuery.replace("query=", "");

        return sendQueryToPrometheus(promURL, promQuery).split("\n");
    }

    public void startPeriodicQueryToPrometheus(@NotNull MeasurementCollectionJob givenMCJ){
        Job job = JobMapper.measurementCollectionJobMapToJob(givenMCJ);
        String promURL = job.getDataAccessEndPointUri().getScheme() + "://" + job.getDataAccessEndPointUri().getAuthority();
        String promQuery = job.getDataAccessEndPointUri().getQuery();
        promQuery = promQuery.replace("query=", "");

        if (job.getStartDateTime() == null){
            job.setStartDateTime(OffsetDateTime.now());
        }
        if (job.getEndDateTime() == null){
            job.setEndDateTime(job.getStartDateTime().plusHours(1));
        }
        if(job.getExecutionInterval() == null){
            job.setExecutionInterval(180);
        }

        Job newPeriodicQuery =  prometheusQueries.startPeriodicQuery(promURL, promQuery,job.getStartDateTime(), job.getEndDateTime(), job.getExecutionInterval());

        if(newPeriodicQuery.getState()== ExecutionStateType.FAILED){
            logger.atError().setMessage("Periodic query failed to start due to internal error.");
        } else {
            logger.atError().setMessage("Periodic query started, with ID: " + newPeriodicQuery.getUuid());
        }
    }

}
