package org.etsi.osl.metrico;


import org.etsi.osl.metrico.model.Job;
import org.etsi.osl.metrico.model.PeriodicQueryRequest;
import org.etsi.osl.metrico.prometheus.PrometheusQueries;
import org.etsi.osl.tmf.pm628.model.ExecutionStateType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

@RestController
public class MetricoController {

    private static final Logger logger = LoggerFactory.getLogger(MetricoController.class);

    private final PrometheusQueries prometheusQueries;

    @Autowired
    public MetricoController(PrometheusQueries prometheusQueries) {
        this.prometheusQueries = prometheusQueries;
    }

    @GetMapping("/live")
    public ResponseEntity<String> livenessCheck() {
        return new ResponseEntity<>("Application is running", HttpStatus.OK);
    }

//    @GetMapping("/queryPrometheus")
//    public ResponseEntity<String> queryPrometheus(
//            @RequestParam(defaultValue = "https") String protocol,
//            @RequestParam(required = false) String prom_ip,
//            @RequestParam(defaultValue = "9000") String prom_port,
//            @RequestParam String query
//    ) {
//        if (prom_ip == null) {
//            return new ResponseEntity<>("prom_ip parameter is missing", HttpStatus.BAD_REQUEST);
//        }
//        String prom_url = protocol + "://" + prom_ip + ":" + prom_port;
//        String[] prometheusData = PrometheusQueries.sendQueryToPrometheus(prom_url, query).split("\n");
//        return new ResponseEntity<>(Arrays.toString(prometheusData), HttpStatus.OK);
//    }

    @PostMapping("/startPeriodicQuery")
    public ResponseEntity<String> startPeriodicQuery(@RequestBody PeriodicQueryRequest request) {
        logger.atDebug().setMessage("/startPeriodicQuery endpoint called with request body: " + request).log();
        logger.atInfo().setMessage("/startPeriodicQuery endpoint called with query: " + request.getQuery()).log();
        if (request.getProm_ip() == null) {
            logger.atInfo().setMessage("/startPeriodicQuery endpoint called without a prometheus_ip: " + request).log();
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.set("Error", "prom_ip parameter is missing");
            return new ResponseEntity<>("prom_ip parameter is missing", responseHeaders, HttpStatus.BAD_REQUEST);
        }
        if (request.getQuery() == null) {
            logger.atInfo().setMessage("/startPeriodicQuery endpoint called without a query: " + request).log();
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.set("Error", "query parameter is missing");
            return new ResponseEntity<>("query parameter is missing", responseHeaders, HttpStatus.BAD_REQUEST);
        }
        if (request.getEndDateTime() == null){
            logger.atDebug().setMessage("/startPeriodicQuery endpoint called without a stopAfterSeconds. Job will not stop by itself.").log();
        }
        String prom_url = request.getProtocol() + "://" + request.getProm_ip() + ":" + request.getProm_port();
        Job newPeriodicQuery = prometheusQueries.startPeriodicQuery(prom_url, request.getQuery(), request.getStartDateTime(), request.getEndDateTime(), request.getExecutionInterval());
        if(newPeriodicQuery.getState() == ExecutionStateType.FAILED){
            return new ResponseEntity<>("Periodic query failed to start due to internal error.", HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity<>("Periodic query started, with ID: " + newPeriodicQuery.getUuid(), HttpStatus.OK);
    }


}
